/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { EuiFieldNumber, EuiFlexGroup, EuiFlexItem, EuiButtonIcon } from '@elastic/eui';
import { i18n } from '@kbn/i18n';

function NumberRow(_ref) {
  var autoFocus = _ref.autoFocus,
      disableDelete = _ref.disableDelete,
      model = _ref.model,
      isInvalid = _ref.isInvalid,
      labelledbyId = _ref.labelledbyId,
      range = _ref.range,
      onBlur = _ref.onBlur,
      onDelete = _ref.onDelete,
      onChange = _ref.onChange;
  var deleteBtnAriaLabel = i18n.translate('visDefaultEditor.controls.numberList.removeUnitButtonAriaLabel', {
    defaultMessage: 'Remove the rank value of {value}',
    values: {
      value: model.value
    }
  });
  var onValueChanged = useCallback(function (event) {
    return onChange({
      value: event.target.value,
      id: model.id
    });
  }, [onChange, model.id]);
  var onDeleteFn = useCallback(function () {
    return onDelete(model.id);
  }, [onDelete, model.id]);
  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFieldNumber, {
    "aria-labelledby": labelledbyId,
    autoFocus: autoFocus,
    compressed: true,
    isInvalid: isInvalid,
    placeholder: i18n.translate('visDefaultEditor.controls.numberList.enterValuePlaceholder', {
      defaultMessage: 'Enter a value'
    }),
    onChange: onValueChanged,
    value: model.value,
    fullWidth: true,
    min: range.min,
    max: range.max,
    onBlur: onBlur
  })), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
    "aria-label": deleteBtnAriaLabel,
    title: deleteBtnAriaLabel,
    color: "danger",
    iconType: "trash",
    onClick: onDeleteFn,
    disabled: disableDelete
  })));
}

export { NumberRow };