function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment, useState, useEffect, useCallback } from 'react';
import { htmlIdGenerator, EuiButtonIcon, EuiButtonEmpty, EuiFieldText, EuiFlexItem, EuiFlexGroup, EuiFormErrorText, EuiIcon, EuiLink, EuiSpacer, EuiText, EuiFormRow } from '@elastic/eui';
import dateMath from '@elastic/datemath';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
import { isEqual, omit } from 'lodash';
import { useMount } from 'react-use';
import { useKibana } from '../../../../kibana_react/public';
var FROM_PLACEHOLDER = "\u2212\u221E";
var TO_PLACEHOLDER = "+\u221E";
var generateId = htmlIdGenerator();

var validateDateMath = function validateDateMath() {
  var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

  if (!value) {
    return true;
  }

  var moment = dateMath.parse(value);
  return moment && moment.isValid();
};

function DateRangesParamEditor(_ref) {
  var _ref$value = _ref.value,
      value = _ref$value === void 0 ? [] : _ref$value,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity;

  var _useKibana = useKibana(),
      services = _useKibana.services;

  var _useState = useState(function () {
    return value.map(function (range) {
      return _objectSpread(_objectSpread({}, range), {}, {
        id: generateId()
      });
    });
  }),
      _useState2 = _slicedToArray(_useState, 2),
      ranges = _useState2[0],
      setRanges = _useState2[1];

  var hasInvalidRange = value.some(function (_ref2) {
    var from = _ref2.from,
        to = _ref2.to;
    return !from && !to || !validateDateMath(from) || !validateDateMath(to);
  });
  var updateRanges = useCallback(function (rangeValues) {
    // do not set internal id parameter into saved object
    setValue(rangeValues.map(function (range) {
      return omit(range, 'id');
    }));
    setRanges(rangeValues);
  }, [setValue]);
  var onAddRange = useCallback(function () {
    return updateRanges([].concat(_toConsumableArray(ranges), [{
      id: generateId()
    }]));
  }, [ranges, updateRanges]);
  useMount(function () {
    // set up an initial range when there is no default range
    if (!value.length) {
      onAddRange();
    }
  });
  useEffect(function () {
    // responsible for discarding changes
    if (value.length !== ranges.length || value.some(function (range, index) {
      return !isEqual(range, omit(ranges[index], 'id'));
    })) {
      setRanges(value.map(function (range) {
        return _objectSpread(_objectSpread({}, range), {}, {
          id: generateId()
        });
      }));
    }
  }, [ranges, value]);
  useEffect(function () {
    setValidity(!hasInvalidRange);
  }, [hasInvalidRange, setValidity]);

  var onRemoveRange = function onRemoveRange(id) {
    return updateRanges(ranges.filter(function (range) {
      return range.id !== id;
    }));
  };

  var onChangeRange = function onChangeRange(id, key, newValue) {
    return updateRanges(ranges.map(function (range) {
      return range.id === id ? _objectSpread(_objectSpread({}, range), {}, _defineProperty({}, key, newValue === '' ? undefined : newValue)) : range;
    }));
  };

  return /*#__PURE__*/React.createElement(EuiFormRow, {
    compressed: true,
    fullWidth: true
  }, /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiText, {
    size: "xs"
  }, /*#__PURE__*/React.createElement(EuiLink, {
    href: services.docLinks.links.date.dateMath,
    target: "_blank"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.controls.dateRanges.acceptedDateFormatsLinkText",
    defaultMessage: "Acceptable date formats"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), ranges.map(function (_ref3, index) {
    var from = _ref3.from,
        to = _ref3.to,
        id = _ref3.id;
    var deleteBtnTitle = i18n.translate('visDefaultEditor.controls.dateRanges.removeRangeButtonAriaLabel', {
      defaultMessage: 'Remove the range of {from} to {to}',
      values: {
        from: from || FROM_PLACEHOLDER,
        to: to || TO_PLACEHOLDER
      }
    });
    var areBothEmpty = !from && !to;
    return /*#__PURE__*/React.createElement(Fragment, {
      key: id
    }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFieldText, {
      "aria-label": i18n.translate('visDefaultEditor.controls.dateRanges.fromColumnLabel', {
        defaultMessage: 'From',
        description: 'Beginning of a date range, e.g. *From* 2018-02-26 To 2018-02-28'
      }),
      compressed: true,
      fullWidth: true,
      isInvalid: areBothEmpty || !validateDateMath(from),
      placeholder: FROM_PLACEHOLDER,
      value: from || '',
      onChange: function onChange(ev) {
        return onChangeRange(id, 'from', ev.target.value);
      },
      "data-test-subj": "visEditorDateRange".concat(index, "__from")
    })), /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiIcon, {
      type: "sortRight",
      color: "subdued"
    })), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFieldText, {
      "aria-label": i18n.translate('visDefaultEditor.controls.dateRanges.toColumnLabel', {
        defaultMessage: 'To',
        description: 'End of a date range, e.g. From 2018-02-26 *To* 2018-02-28'
      }),
      "data-test-subj": "visEditorDateRange".concat(index, "__to"),
      compressed: true,
      fullWidth: true,
      isInvalid: areBothEmpty || !validateDateMath(to),
      placeholder: TO_PLACEHOLDER,
      value: to || '',
      onChange: function onChange(ev) {
        return onChangeRange(id, 'to', ev.target.value);
      }
    })), /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
      title: deleteBtnTitle,
      "aria-label": deleteBtnTitle,
      disabled: value.length === 1,
      color: "danger",
      iconType: "trash",
      onClick: function onClick() {
        return onRemoveRange(id);
      }
    }))), /*#__PURE__*/React.createElement(EuiSpacer, {
      size: "xs"
    }));
  }), hasInvalidRange && /*#__PURE__*/React.createElement(EuiFormErrorText, null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.controls.dateRanges.errorMessage",
    defaultMessage: "Each range should have at least one valid date."
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    iconType: "plusInCircleFilled",
    onClick: onAddRange,
    size: "xs",
    "data-test-subj": "visEditorAddDateRange"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.controls.dateRanges.addRangeButtonLabel",
    defaultMessage: "Add range"
  })))));
}

export { DateRangesParamEditor };