function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiFieldNumber, EuiFlexGroup, EuiFlexItem, EuiFormRow } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { isUndefined } from 'lodash';
import { useValidation } from './utils';

function areBoundsValid(_ref) {
  var min = _ref.min,
      max = _ref.max;

  if (min === '' || max === '') {
    return false;
  }

  return max >= min;
}

function ExtendedBoundsParamEditor(_ref2) {
  var _ref2$value = _ref2.value,
      value = _ref2$value === void 0 ? {} : _ref2$value,
      setValue = _ref2.setValue,
      setValidity = _ref2.setValidity,
      showValidation = _ref2.showValidation,
      setTouched = _ref2.setTouched;
  var minLabel = i18n.translate('visDefaultEditor.controls.extendedBounds.minLabel', {
    defaultMessage: 'Min'
  });
  var maxLabel = i18n.translate('visDefaultEditor.controls.extendedBounds.maxLabel', {
    defaultMessage: 'Max'
  });
  var isValid = areBoundsValid(value);
  var error;

  if (!isValid) {
    error = i18n.translate('visDefaultEditor.controls.extendedBounds.errorMessage', {
      defaultMessage: 'Min should be less than or equal to Max.'
    });
  }

  useValidation(setValidity, isValid);

  var handleChange = function handleChange(ev, name) {
    setValue(_objectSpread(_objectSpread({}, value), {}, _defineProperty({}, name, ev.target.value === '' ? '' : parseFloat(ev.target.value))));
  };

  return /*#__PURE__*/React.createElement(EuiFormRow, {
    fullWidth: true,
    isInvalid: showValidation ? !isValid : false,
    error: error
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFieldNumber, {
    value: isUndefined(value.min) ? '' : value.min,
    onChange: function onChange(ev) {
      return handleChange(ev, 'min');
    },
    onBlur: setTouched,
    fullWidth: true,
    isInvalid: showValidation ? !isValid : false,
    "aria-label": minLabel,
    prepend: minLabel,
    compressed: true
  })), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFieldNumber, {
    value: isUndefined(value.max) ? '' : value.max,
    onChange: function onChange(ev) {
      return handleChange(ev, 'max');
    },
    onBlur: setTouched,
    fullWidth: true,
    isInvalid: showValidation ? !isValid : false,
    "aria-label": maxLabel,
    prepend: maxLabel,
    compressed: true
  }))));
}

export { ExtendedBoundsParamEditor };