function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiModal, EuiOverlayMask } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { METRIC_TYPE } from '@kbn/analytics';
import { SearchSelection } from './search_selection';
import { TypeSelection } from './type_selection';
import { VISUALIZE_ENABLE_LABS_SETTING } from '../../common/constants';
// TODO: redirect logic is specific to visualise & dashboard
// but it is likely should be decoupled. e.g. handled by the container instead
var basePath = "/create?";
var baseUrl = "/app/visualize#".concat(basePath);

var NewVisModal = /*#__PURE__*/function (_React$Component) {
  _inherits(NewVisModal, _React$Component);

  var _super = _createSuper(NewVisModal);

  function NewVisModal(props) {
    var _this$props$usageColl;

    var _this;

    _classCallCheck(this, NewVisModal);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "isLabsEnabled", void 0);

    _defineProperty(_assertThisInitialized(_this), "trackUiMetric", void 0);

    _defineProperty(_assertThisInitialized(_this), "onCloseModal", function () {
      _this.setState({
        showSearchVisModal: false
      });

      _this.props.onClose();
    });

    _defineProperty(_assertThisInitialized(_this), "onVisTypeSelected", function (visType) {
      if (!('aliasPath' in visType) && visType.requiresSearch && visType.options.showIndexSelection) {
        _this.setState({
          showSearchVisModal: true,
          visType: visType
        });
      } else {
        _this.redirectToVis(visType);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onSearchSelected", function (searchId, searchType) {
      _this.redirectToVis(_this.state.visType, searchType, searchId);
    });

    _this.isLabsEnabled = props.uiSettings.get(VISUALIZE_ENABLE_LABS_SETTING);
    _this.state = {
      showSearchVisModal: false
    };
    _this.trackUiMetric = (_this$props$usageColl = _this.props.usageCollection) === null || _this$props$usageColl === void 0 ? void 0 : _this$props$usageColl.reportUiStats.bind(_this.props.usageCollection, 'visualize');
    return _this;
  }

  _createClass(NewVisModal, [{
    key: "render",
    value: function render() {
      if (!this.props.isOpen) {
        return null;
      }

      var visNewVisDialogAriaLabel = i18n.translate('visualizations.newVisWizard.helpTextAriaLabel', {
        defaultMessage: 'Start creating your visualization by selecting a type for that visualization. Hit escape to close this modal. Hit Tab key to go further.'
      });
      var selectionModal = this.state.showSearchVisModal && this.state.visType ? /*#__PURE__*/React.createElement(EuiModal, {
        onClose: this.onCloseModal,
        className: "visNewVisSearchDialog"
      }, /*#__PURE__*/React.createElement(SearchSelection, {
        onSearchSelected: this.onSearchSelected,
        visType: this.state.visType,
        uiSettings: this.props.uiSettings,
        savedObjects: this.props.savedObjects
      })) : /*#__PURE__*/React.createElement(EuiModal, {
        onClose: this.onCloseModal,
        className: "visNewVisDialog",
        "aria-label": visNewVisDialogAriaLabel,
        role: "menu"
      }, /*#__PURE__*/React.createElement(TypeSelection, {
        showExperimental: this.isLabsEnabled,
        onVisTypeSelected: this.onVisTypeSelected,
        visTypesRegistry: this.props.visTypesRegistry,
        addBasePath: this.props.addBasePath
      }));
      return /*#__PURE__*/React.createElement(EuiOverlayMask, null, selectionModal);
    }
  }, {
    key: "redirectToVis",
    value: function redirectToVis(visType, searchType, searchId) {
      if (this.trackUiMetric) {
        this.trackUiMetric(METRIC_TYPE.CLICK, visType.name);
      }

      var params;

      if ('aliasPath' in visType) {
        params = visType.aliasPath;
        this.props.onClose();
        this.navigate(visType.aliasApp, visType.aliasPath);
        return;
      }

      params = ["type=".concat(encodeURIComponent(visType.name))];

      if (searchType) {
        params.push("".concat(searchType === 'search' ? 'savedSearchId' : 'indexPattern', "=").concat(searchId));
      }

      params = params.concat(this.props.editorParams);
      this.props.onClose();

      if (this.props.outsideVisualizeApp) {
        this.navigate('visualize', "#".concat(basePath).concat(params.join('&')));
      } else {
        location.assign(this.props.addBasePath("".concat(baseUrl).concat(params.join('&'))));
      }
    }
  }, {
    key: "navigate",
    value: function navigate(appId, params) {
      if (this.props.stateTransfer && this.props.originatingApp) {
        this.props.stateTransfer.navigateToEditor(appId, {
          path: params,
          state: {
            originatingApp: this.props.originatingApp
          }
        });
      } else {
        this.props.application.navigateToApp(appId, {
          path: params
        });
      }
    }
  }]);

  return NewVisModal;
}(React.Component);

_defineProperty(NewVisModal, "defaultProps", {
  editorParams: []
});

export { NewVisModal };