function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import './visualize_listing.scss';
import React, { useCallback, useRef, useMemo, useEffect } from 'react';
import { i18n } from '@kbn/i18n';
import { useUnmount, useMount } from 'react-use';
import { useLocation } from 'react-router-dom';
import { useKibana, TableListView } from '../../../../kibana_react/public';
import { VISUALIZE_ENABLE_LABS_SETTING } from '../../../../visualizations/public';
import { VisualizeConstants } from '../visualize_constants';
import { getTableColumns, getNoItemsMessage } from '../utils';
export var VisualizeListing = function VisualizeListing() {
  var _useKibana = useKibana(),
      _useKibana$services = _useKibana.services,
      application = _useKibana$services.application,
      chrome = _useKibana$services.chrome,
      history = _useKibana$services.history,
      savedVisualizations = _useKibana$services.savedVisualizations,
      toastNotifications = _useKibana$services.toastNotifications,
      visualizations = _useKibana$services.visualizations,
      savedObjects = _useKibana$services.savedObjects,
      savedObjectsPublic = _useKibana$services.savedObjectsPublic,
      uiSettings = _useKibana$services.uiSettings,
      visualizeCapabilities = _useKibana$services.visualizeCapabilities;

  var _useLocation = useLocation(),
      pathname = _useLocation.pathname;

  var closeNewVisModal = useRef(function () {});
  var listingLimit = savedObjectsPublic.settings.getListingLimit();
  useEffect(function () {
    if (pathname === '/new') {
      // In case the user navigated to the page via the /visualize/new URL we start the dialog immediately
      closeNewVisModal.current = visualizations.showNewVisModal({
        onClose: function onClose() {
          // In case the user came via a URL to this page, change the URL to the regular landing page URL after closing the modal
          history.push(VisualizeConstants.LANDING_PAGE_PATH);
        }
      });
    } else {
      // close modal window if exists
      closeNewVisModal.current();
    }
  }, [history, pathname, visualizations]);
  useMount(function () {
    chrome.setBreadcrumbs([{
      text: i18n.translate('visualize.visualizeListingBreadcrumbsTitle', {
        defaultMessage: 'Visualize'
      })
    }]);
    chrome.docTitle.change(i18n.translate('visualize.listingPageTitle', {
      defaultMessage: 'Visualize'
    }));
  });
  useUnmount(function () {
    return closeNewVisModal.current();
  });
  var createNewVis = useCallback(function () {
    closeNewVisModal.current = visualizations.showNewVisModal();
  }, [visualizations]);
  var editItem = useCallback(function (_ref) {
    var editUrl = _ref.editUrl,
        editApp = _ref.editApp;

    if (editApp) {
      application.navigateToApp(editApp, {
        path: editUrl
      });
      return;
    } // for visualizations the edit and view URLs are the same


    history.push(editUrl);
  }, [application, history]);
  var noItemsFragment = useMemo(function () {
    return getNoItemsMessage(createNewVis);
  }, [createNewVis]);
  var tableColumns = useMemo(function () {
    return getTableColumns(application, history);
  }, [application, history]);
  var fetchItems = useCallback(function (filter) {
    var isLabsEnabled = uiSettings.get(VISUALIZE_ENABLE_LABS_SETTING);
    return savedVisualizations.findListItems(filter, listingLimit).then(function (_ref2) {
      var total = _ref2.total,
          hits = _ref2.hits;
      return {
        total: total,
        hits: hits.filter(function (result) {
          return isLabsEnabled || result.type.stage !== 'experimental';
        })
      };
    });
  }, [listingLimit, savedVisualizations, uiSettings]);
  var deleteItems = useCallback( /*#__PURE__*/function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(selectedItems) {
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return Promise.all(selectedItems.map(function (item) {
                return savedObjects.client.delete(item.savedObjectType, item.id);
              })).catch(function (error) {
                toastNotifications.addError(error, {
                  title: i18n.translate('visualize.visualizeListingDeleteErrorTitle', {
                    defaultMessage: 'Error deleting visualization'
                  })
                });
              });

            case 2:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function (_x) {
      return _ref3.apply(this, arguments);
    };
  }(), [savedObjects.client, toastNotifications]);
  return /*#__PURE__*/React.createElement(TableListView, {
    headingId: "visualizeListingHeading" // we allow users to create visualizations even if they can't save them
    // for data exploration purposes
    ,
    createItem: createNewVis,
    findItems: fetchItems,
    deleteItems: visualizeCapabilities.delete ? deleteItems : undefined,
    editItem: visualizeCapabilities.save ? editItem : undefined,
    tableColumns: tableColumns,
    listingLimit: listingLimit,
    initialPageSize: savedObjectsPublic.settings.getPerPage(),
    initialFilter: '',
    noItemsFragment: noItemsFragment,
    entityName: i18n.translate('visualize.listing.table.entityName', {
      defaultMessage: 'visualization'
    }),
    entityNamePlural: i18n.translate('visualize.listing.table.entityNamePlural', {
      defaultMessage: 'visualizations'
    }),
    tableListTitle: i18n.translate('visualize.listing.table.listTitle', {
      defaultMessage: 'Visualizations'
    }),
    toastNotifications: toastNotifications
  });
};