function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { useEffect, useState } from 'react';
import { isEqual } from 'lodash';
import { merge } from 'rxjs';
import { migrateLegacyQuery } from '../../../../../kibana_legacy/public';
export var useEditorUpdates = function useEditorUpdates(services, eventEmitter, setHasUnsavedChanges, appState, savedVisInstance, visEditorController) {
  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isEmbeddableRendered = _useState2[0],
      setIsEmbeddableRendered = _useState2[1];

  var _useState3 = useState(),
      _useState4 = _slicedToArray(_useState3, 2),
      currentAppState = _useState4[0],
      setCurrentAppState = _useState4[1];

  useEffect(function () {
    if (appState && savedVisInstance) {
      var _services$data$query = services.data.query,
          timefilter = _services$data$query.timefilter.timefilter,
          filterManager = _services$data$query.filterManager;
      var embeddableHandler = savedVisInstance.embeddableHandler,
          savedVis = savedVisInstance.savedVis,
          savedSearch = savedVisInstance.savedSearch,
          vis = savedVisInstance.vis;
      var initialState = appState.getState();
      setCurrentAppState(initialState);

      var reloadVisualization = function reloadVisualization() {
        if (visEditorController) {
          visEditorController.render({
            core: services,
            data: services.data,
            uiState: vis.uiState,
            timeRange: timefilter.getTime(),
            filters: filterManager.getFilters(),
            query: appState.getState().query,
            linked: !!vis.data.savedSearchId,
            savedSearch: savedSearch
          });
        } else {
          embeddableHandler.updateInput({
            timeRange: timefilter.getTime(),
            filters: filterManager.getFilters(),
            query: appState.getState().query
          });
        }
      };

      var subscriptions = merge(timefilter.getTimeUpdate$(), timefilter.getAutoRefreshFetch$(), timefilter.getFetch$(), filterManager.getFetches$()).subscribe({
        next: reloadVisualization,
        error: services.fatalErrors.add
      });

      var handleLinkedSearch = function handleLinkedSearch(linked) {
        if (linked && !savedVis.savedSearchId && savedSearch) {
          savedVis.savedSearchId = savedSearch.id;
          vis.data.savedSearchId = savedSearch.id;

          if (vis.data.searchSource) {
            vis.data.searchSource.setParent(savedSearch.searchSource);
          }
        } else if (!linked && savedVis.savedSearchId) {
          delete savedVis.savedSearchId;
          delete vis.data.savedSearchId;
        }
      }; // update persisted state from initial state


      if (initialState.uiState) {
        vis.uiState.setSilent(initialState.uiState);
      } // update the appState when the stateful instance changes


      var updateOnChange = function updateOnChange() {
        appState.transitions.set('uiState', vis.uiState.getChanges());
      };

      vis.uiState.on('change', updateOnChange);
      var unsubscribeStateUpdates = appState.subscribe(function (state) {
        setCurrentAppState(state);

        if (savedVis.id && !services.history.location.pathname.includes(savedVis.id)) {
          // this filters out the case when manipulating the browser history back/forward
          // and initializing different visualizations
          return;
        }

        var newQuery = migrateLegacyQuery(state.query);

        if (!isEqual(state.query, newQuery)) {
          appState.transitions.set('query', newQuery);
        }

        if (!isEqual(state.uiState, vis.uiState.getChanges())) {
          vis.uiState.set(state.uiState);
        } // if the browser history was changed manually we need to reflect changes in the editor


        if (!isEqual(_objectSpread(_objectSpread({}, services.visualizations.convertFromSerializedVis(vis.serialize()).visState), {}, {
          title: vis.title
        }), state.vis)) {
          var _state$vis = state.vis,
              aggs = _state$vis.aggs,
              visState = _objectWithoutProperties(_state$vis, ["aggs"]);

          vis.setState(_objectSpread(_objectSpread({}, visState), {}, {
            data: {
              aggs: aggs
            }
          }));
          embeddableHandler.reload();
          eventEmitter.emit('updateEditor');
        }

        handleLinkedSearch(state.linked);

        if (vis.data.searchSource) {
          vis.data.searchSource.setField('query', state.query);
          vis.data.searchSource.setField('filter', state.filters);
        }

        reloadVisualization();
        setHasUnsavedChanges(true);
      });

      var updateOnEmbeddableRendered = function updateOnEmbeddableRendered() {
        return setIsEmbeddableRendered(true);
      };

      eventEmitter.on('embeddableRendered', updateOnEmbeddableRendered);
      reloadVisualization();
      return function () {
        setIsEmbeddableRendered(false);
        eventEmitter.off('embeddableRendered', updateOnEmbeddableRendered);
        subscriptions.unsubscribe();
        vis.uiState.off('change', updateOnChange);
        unsubscribeStateUpdates();
      };
    }
  }, [appState, eventEmitter, savedVisInstance, services, setHasUnsavedChanges, visEditorController]);
  return {
    isEmbeddableRendered: isEmbeddableRendered,
    currentAppState: currentAppState
  };
};