/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.ExceptionReport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ArchitectUtils {
    public static final Logger logger = Logger.getLogger(ArchitectUtils.class);

    private ArchitectUtils() {
    }

    public static void startup() {
        ExceptionReport.init();
    }

    public static void configureLog4j() {
        String configName = "log4j.properties";
        URL config = ArchitectUtils.class.getClassLoader().getResource(configName);
        if (config == null) {
            System.err.println("Warning: Couldn't find log4j config resource '" + configName + "'");
        } else {
            PropertyConfigurator.configure((URL)config);
            logger.info((Object)"Log4J configured successfully");
        }
    }

    public static boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static String truncateString(String s) {
        if (s == null || s.length() < 28) {
            return s;
        }
        return s.substring(27) + "...";
    }

    public static String quoteCSV(Object val) {
        if (val == null) {
            return "";
        }
        if (val instanceof String) {
            return ArchitectUtils.quoteCSVStr((String)val);
        }
        return val.toString();
    }

    public static String quoteCSVStr(String val) {
        CharSequence doubleQuote = "\"".subSequence(0, "\"".length());
        CharSequence doubleDoubleQuote = "\"\"".subSequence(0, "\"\"".length());
        CharSequence newLine = "\n".subSequence(0, "\n".length());
        CharSequence cr = "\r".subSequence(0, "\r".length());
        CharSequence comma = ",".subSequence(0, ",".length());
        if (val.contains(doubleQuote)) {
            StringBuffer sb = new StringBuffer(doubleQuote);
            sb.append(val.replace(doubleQuote, doubleDoubleQuote));
            sb.append(doubleQuote);
            return sb.toString();
        }
        if (val.contains(newLine) || val.contains(cr) || val.contains(comma)) {
            StringBuffer sb = new StringBuffer(doubleQuote);
            sb.append(val);
            sb.append(doubleQuote);
            return sb.toString();
        }
        return val;
    }

    public static boolean columnsDiffer(SQLColumn targetColumn, SQLColumn sourceColumn) {
        int targetType = ArchitectUtils.compressType(targetColumn.getType());
        int sourceType = ArchitectUtils.compressType(sourceColumn.getType());
        int targetPrecision = targetColumn.getPrecision();
        int sourcePrecision = sourceColumn.getPrecision();
        int targetScale = targetColumn.getScale();
        int sourceScale = sourceColumn.getScale();
        if (!ArchitectUtils.needsScale(targetType)) {
            targetScale = 0;
        }
        if (!ArchitectUtils.needsPrecision(targetType)) {
            targetPrecision = 0;
        }
        if (!ArchitectUtils.needsScale(sourceType)) {
            sourceScale = 0;
        }
        if (!ArchitectUtils.needsPrecision(sourceType)) {
            sourcePrecision = 0;
        }
        return sourceType != targetType || targetPrecision != sourcePrecision || targetScale != sourceScale || targetColumn.getNullable() != sourceColumn.getNullable();
    }

    public static boolean needsScale(int type) {
        return type == 3 || type == 2;
    }

    public static boolean needsPrecision(int type) {
        int NCHAR = -15;
        int NVARCHAR = -9;
        return type == 3 || type == 2 || type == 12 || type == 1 || type == -15 || type == -9;
    }

    public static boolean columnTypesDiffer(int t1, int t2) {
        int targetType;
        int sourceType = ArchitectUtils.compressType(t1);
        return sourceType != (targetType = ArchitectUtils.compressType(t2));
    }

    private static int compressType(int type) {
        if (type == 3) {
            return 2;
        }
        return type;
    }

    public static String checkForValidPlDotIni(String plDotIniPath, String projectName) throws SQLObjectException {
        while (!ArchitectUtils.isPlDotIniPathValid(plDotIniPath)) {
            File newPlIniFile;
            Object[] options = new String[]{"Browse", "Create"};
            String message = plDotIniPath == null ? "location is not set" : (new File(plDotIniPath).isFile() ? "file \n\n\"" + plDotIniPath + "\"\n\n could not be read" : "file \n\n\"" + plDotIniPath + "\"\n\n does not exist");
            Boolean isHeadless = Boolean.valueOf(System.getProperty("ca.sqlpower.headless", "false"));
            int choice = isHeadless != false ? 1 : JOptionPane.showOptionDialog(null, "The " + projectName + " keeps its list of database connections" + "\nin a file called PL.INI.  Your PL.INI " + message + "." + "\n\nYou can browse for an existing PL.INI file on your system" + "\nor allow the " + projectName + " to create a new one in your home directory." + "\n\nHint: If you are a Power*Loader Suite user, you should browse for" + "\nan existing PL.INI in your Power*Loader installation directory.", "Missing PL.INI", 0, 1, null, options, null);
            if (choice == -1) {
                throw new SQLObjectException("Can't start without a pl.ini file");
            }
            if (choice == 0) {
                JFileChooser fc = new JFileChooser();
                fc.setFileFilter(SPSUtils.INI_FILE_FILTER);
                fc.setDialogTitle("Locate your PL.INI file");
                int fcChoice = fc.showOpenDialog(null);
                newPlIniFile = fcChoice == 0 ? fc.getSelectedFile() : null;
            } else if (choice == 1) {
                newPlIniFile = new File(System.getProperty("user.home"), "pl.ini");
            } else {
                throw new SQLObjectException("Unexpected return from JOptionPane.showOptionDialog to get pl.ini");
            }
            if (newPlIniFile == null) continue;
            try {
                newPlIniFile.createNewFile();
                return newPlIniFile.getPath();
            }
            catch (IOException e1) {
                logger.error((Object)("Caught IO exception while creating empty PL.INI at \"" + newPlIniFile.getPath() + "\""), (Throwable)e1);
                ASUtils.showExceptionDialogNoReport("Failed to create file \"" + newPlIniFile.getPath() + "\".", e1);
            }
        }
        return plDotIniPath;
    }

    private static boolean isPlDotIniPathValid(String plDotIniPath) {
        logger.debug((Object)("Checking pl.ini path: " + plDotIniPath));
        String path = plDotIniPath;
        if (path == null) {
            return false;
        }
        File f = new File(path);
        return f.canRead() && f.isFile();
    }

    public static String convertClassToString(Class<?> c) {
        if (SQLTable.class.equals(c)) {
            return "Table";
        }
        if (SQLColumn.class.equals(c)) {
            return "Column";
        }
        if (SQLRelationship.class.equals(c)) {
            return "Relationship";
        }
        if (SQLIndex.class.equals(c)) {
            return "Index";
        }
        if (JDBCDataSourceType.class.equals(c)) {
            return "Data Source Type";
        }
        return c.getSimpleName();
    }

    public static UserDefinedSQLType getSQLType(int sqlType, List<UserDefinedSQLType> types) {
        for (UserDefinedSQLType st : types) {
            if (!st.getType().equals(sqlType)) continue;
            return st;
        }
        throw new IllegalArgumentException(sqlType + " is not a sql datatype.");
    }

    public static void setUpstreamTypesInTable(SQLTable table, ArchitectSession session) {
        List<UserDefinedSQLType> types = session.getSQLTypes();
        for (SQLColumn col : table.getColumnsWithoutPopulating()) {
            if (col.getUserDefinedSQLType().getUpstreamType() != null) continue;
            col.setType(ArchitectUtils.getSQLType(col.getType(), types));
        }
    }
}

