/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.completion.ml.common.PrefixMatchingType;
import com.intellij.psi.codeStyle.NameUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CharIterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000bJ;\u0010\f\u001a\u00020\u0006\"\u0004\b\u0000\u0010\r*\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u0002H\rH\u0002\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/completion/ml/common/PrefixMatchingUtil;", "", "()V", "baseName", "", "calculateFeatures", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "prefix", "features", "", "addFeature", "T", "name", "value", "defaultValue", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", "PrefixMatchingScores", "intellij.statsCollector"})
public final class PrefixMatchingUtil {
    @NotNull
    public static final String baseName = "prefix";
    public static final PrefixMatchingUtil INSTANCE;

    public final void calculateFeatures(@NotNull LookupElement element, @NotNull String prefix, @NotNull Map<String, Object> features2) {
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)prefix, (String)baseName);
                Intrinsics.checkParameterIsNotNull(features2, (String)"features");
                CharSequence charSequence = prefix;
                boolean bl = false;
                if (charSequence.length() == 0) break block2;
                String string = element.getLookupString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.lookupString");
                charSequence = string;
                bl = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            return;
        }
        PrefixMatchingScores.Builder builder = new PrefixMatchingScores.Builder();
        String string = element.getLookupString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.lookupString");
        PrefixMatchingScores prefixMatchingScores = builder.build(prefix, string);
        this.addFeature(features2, "same_start_count", prefixMatchingScores.getStart(), 0);
        this.addFeature(features2, "greedy_score", prefixMatchingScores.getGreedy(), 0.0);
        this.addFeature(features2, "greedy_with_case_score", prefixMatchingScores.getGreedyWithCase(), 0.0);
        this.addFeature(features2, "matched_words_score", prefixMatchingScores.getWords(), 0.0);
        this.addFeature(features2, "matched_words_relative", prefixMatchingScores.getWordsRelative(), 0.0);
        this.addFeature(features2, "matched_words_with_case_score", prefixMatchingScores.getWordsWithCase(), 0.0);
        this.addFeature(features2, "matched_words_with_case_relative", prefixMatchingScores.getWordsWithCaseRelative(), 0.0);
        this.addFeature(features2, "skipped_words", prefixMatchingScores.getSkippedWords(), 0);
        this.addFeature(features2, "matching_type", prefixMatchingScores.getType(), PrefixMatchingType.UNKNOWN);
        this.addFeature(features2, "exact", prefixMatchingScores.getExact(), false);
        this.addFeature(features2, "matched_last_word", prefixMatchingScores.getExactFinal(), false);
    }

    private final <T> void addFeature(@NotNull Map<String, T> $this$addFeature, String name, T value, T defaultValue) {
        if (Intrinsics.areEqual(value, defaultValue) ^ true) {
            $this$addFeature.put("prefix_" + name, value);
        }
    }

    private PrefixMatchingUtil() {
    }

    static {
        PrefixMatchingUtil prefixMatchingUtil;
        INSTANCE = prefixMatchingUtil = new PrefixMatchingUtil();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 32\u00020\u0001:\u000223B_\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\u0010H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J\t\u0010&\u001a\u00020\bH\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\t\u0010(\u001a\u00020\bH\u00c6\u0003J\t\u0010)\u001a\u00020\bH\u00c6\u0003J\t\u0010*\u001a\u00020\bH\u00c6\u0003J\t\u0010+\u001a\u00020\bH\u00c6\u0003Jw\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u00c6\u0001J\u0013\u0010-\u001a\u00020\u00032\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u00020\u0006H\u00d6\u0001J\t\u00100\u001a\u000201H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016\u00a8\u00064"}, d2={"Lcom/intellij/completion/ml/common/PrefixMatchingUtil$PrefixMatchingScores;", "", "exact", "", "exactFinal", "start", "", "greedy", "", "greedyWithCase", "words", "wordsRelative", "wordsWithCase", "wordsWithCaseRelative", "skippedWords", "type", "Lcom/intellij/completion/ml/common/PrefixMatchingType;", "(ZZIDDDDDDILcom/intellij/completion/ml/common/PrefixMatchingType;)V", "getExact", "()Z", "getExactFinal", "getGreedy", "()D", "getGreedyWithCase", "getSkippedWords", "()I", "getStart", "getType", "()Lcom/intellij/completion/ml/common/PrefixMatchingType;", "getWords", "getWordsRelative", "getWordsWithCase", "getWordsWithCaseRelative", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "", "Builder", "Companion", "intellij.statsCollector"})
    public static final class PrefixMatchingScores {
        private final boolean exact;
        private final boolean exactFinal;
        private final int start;
        private final double greedy;
        private final double greedyWithCase;
        private final double words;
        private final double wordsRelative;
        private final double wordsWithCase;
        private final double wordsWithCaseRelative;
        private final int skippedWords;
        @NotNull
        private final PrefixMatchingType type;
        private static final PrefixMatchingScores EMPTY_PREFIX_MATCHING_SCORE;
        public static final Companion Companion;

        public final boolean getExact() {
            return this.exact;
        }

        public final boolean getExactFinal() {
            return this.exactFinal;
        }

        public final int getStart() {
            return this.start;
        }

        public final double getGreedy() {
            return this.greedy;
        }

        public final double getGreedyWithCase() {
            return this.greedyWithCase;
        }

        public final double getWords() {
            return this.words;
        }

        public final double getWordsRelative() {
            return this.wordsRelative;
        }

        public final double getWordsWithCase() {
            return this.wordsWithCase;
        }

        public final double getWordsWithCaseRelative() {
            return this.wordsWithCaseRelative;
        }

        public final int getSkippedWords() {
            return this.skippedWords;
        }

        @NotNull
        public final PrefixMatchingType getType() {
            return this.type;
        }

        public PrefixMatchingScores(boolean exact, boolean exactFinal, int start, double greedy, double greedyWithCase, double words, double wordsRelative, double wordsWithCase, double wordsWithCaseRelative, int skippedWords, @NotNull PrefixMatchingType type) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
            this.exact = exact;
            this.exactFinal = exactFinal;
            this.start = start;
            this.greedy = greedy;
            this.greedyWithCase = greedyWithCase;
            this.words = words;
            this.wordsRelative = wordsRelative;
            this.wordsWithCase = wordsWithCase;
            this.wordsWithCaseRelative = wordsWithCaseRelative;
            this.skippedWords = skippedWords;
            this.type = type;
        }

        static {
            Companion = new Companion(null);
            EMPTY_PREFIX_MATCHING_SCORE = new PrefixMatchingScores(false, false, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, PrefixMatchingType.UNKNOWN);
        }

        public final boolean component1() {
            return this.exact;
        }

        public final boolean component2() {
            return this.exactFinal;
        }

        public final int component3() {
            return this.start;
        }

        public final double component4() {
            return this.greedy;
        }

        public final double component5() {
            return this.greedyWithCase;
        }

        public final double component6() {
            return this.words;
        }

        public final double component7() {
            return this.wordsRelative;
        }

        public final double component8() {
            return this.wordsWithCase;
        }

        public final double component9() {
            return this.wordsWithCaseRelative;
        }

        public final int component10() {
            return this.skippedWords;
        }

        @NotNull
        public final PrefixMatchingType component11() {
            return this.type;
        }

        @NotNull
        public final PrefixMatchingScores copy(boolean exact, boolean exactFinal, int start, double greedy, double greedyWithCase, double words, double wordsRelative, double wordsWithCase, double wordsWithCaseRelative, int skippedWords, @NotNull PrefixMatchingType type) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
            return new PrefixMatchingScores(exact, exactFinal, start, greedy, greedyWithCase, words, wordsRelative, wordsWithCase, wordsWithCaseRelative, skippedWords, type);
        }

        public static /* synthetic */ PrefixMatchingScores copy$default(PrefixMatchingScores prefixMatchingScores, boolean bl, boolean bl2, int n, double d, double d2, double d3, double d4, double d5, double d6, int n2, PrefixMatchingType prefixMatchingType, int n3, Object object) {
            if ((n3 & 1) != 0) {
                bl = prefixMatchingScores.exact;
            }
            if ((n3 & 2) != 0) {
                bl2 = prefixMatchingScores.exactFinal;
            }
            if ((n3 & 4) != 0) {
                n = prefixMatchingScores.start;
            }
            if ((n3 & 8) != 0) {
                d = prefixMatchingScores.greedy;
            }
            if ((n3 & 0x10) != 0) {
                d2 = prefixMatchingScores.greedyWithCase;
            }
            if ((n3 & 0x20) != 0) {
                d3 = prefixMatchingScores.words;
            }
            if ((n3 & 0x40) != 0) {
                d4 = prefixMatchingScores.wordsRelative;
            }
            if ((n3 & 0x80) != 0) {
                d5 = prefixMatchingScores.wordsWithCase;
            }
            if ((n3 & 0x100) != 0) {
                d6 = prefixMatchingScores.wordsWithCaseRelative;
            }
            if ((n3 & 0x200) != 0) {
                n2 = prefixMatchingScores.skippedWords;
            }
            if ((n3 & 0x400) != 0) {
                prefixMatchingType = prefixMatchingScores.type;
            }
            return prefixMatchingScores.copy(bl, bl2, n, d, d2, d3, d4, d5, d6, n2, prefixMatchingType);
        }

        @NotNull
        public String toString() {
            return "PrefixMatchingScores(exact=" + this.exact + ", exactFinal=" + this.exactFinal + ", start=" + this.start + ", greedy=" + this.greedy + ", greedyWithCase=" + this.greedyWithCase + ", words=" + this.words + ", wordsRelative=" + this.wordsRelative + ", wordsWithCase=" + this.wordsWithCase + ", wordsWithCaseRelative=" + this.wordsWithCaseRelative + ", skippedWords=" + this.skippedWords + ", type=" + (Object)((Object)this.type) + ")";
        }

        public int hashCode() {
            int n = this.exact ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.exactFinal ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            PrefixMatchingType prefixMatchingType = this.type;
            return (((((((((n2 + n3) * 31 + Integer.hashCode(this.start)) * 31 + Double.hashCode(this.greedy)) * 31 + Double.hashCode(this.greedyWithCase)) * 31 + Double.hashCode(this.words)) * 31 + Double.hashCode(this.wordsRelative)) * 31 + Double.hashCode(this.wordsWithCase)) * 31 + Double.hashCode(this.wordsWithCaseRelative)) * 31 + Integer.hashCode(this.skippedWords)) * 31 + (prefixMatchingType != null ? ((Object)((Object)prefixMatchingType)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PrefixMatchingScores)) break block3;
                    PrefixMatchingScores prefixMatchingScores = (PrefixMatchingScores)object;
                    if (this.exact != prefixMatchingScores.exact || this.exactFinal != prefixMatchingScores.exactFinal || this.start != prefixMatchingScores.start || Double.compare(this.greedy, prefixMatchingScores.greedy) != 0 || Double.compare(this.greedyWithCase, prefixMatchingScores.greedyWithCase) != 0 || Double.compare(this.words, prefixMatchingScores.words) != 0 || Double.compare(this.wordsRelative, prefixMatchingScores.wordsRelative) != 0 || Double.compare(this.wordsWithCase, prefixMatchingScores.wordsWithCase) != 0 || Double.compare(this.wordsWithCaseRelative, prefixMatchingScores.wordsWithCaseRelative) != 0 || this.skippedWords != prefixMatchingScores.skippedWords || !Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)prefixMatchingScores.type))) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J-\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ5\u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0002\u00a2\u0006\u0002\u0010#J\u001d\u0010$\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0002\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/completion/ml/common/PrefixMatchingUtil$PrefixMatchingScores$Builder;", "", "()V", "curWord", "", "exact", "", "greedyMatchingCount", "greedyMatchingScore", "", "greedyMatchingWithCaseCount", "greedyMatchingWithCaseScore", "lastWord", "lastWordSize", "skippedWords", "startMatchingCount", "wordsCount", "wordsMatchingCount", "wordsMatchingScore", "wordsMatchingWithCaseScore", "build", "Lcom/intellij/completion/ml/common/PrefixMatchingUtil$PrefixMatchingScores;", "prefix", "", "lookupString", "matchAndNext", "", "wordIndex", "withCase", "iter", "", "(IZLjava/util/Iterator;)Ljava/lang/Character;", "matchWord", "word", "ch", "(Ljava/lang/String;CILjava/util/Iterator;)Ljava/lang/Character;", "next", "(Ljava/util/Iterator;)Ljava/lang/Character;", "resolveMatchingType", "Lcom/intellij/completion/ml/common/PrefixMatchingType;", "updateMatching", "", "intellij.statsCollector"})
        public static final class Builder {
            private int startMatchingCount;
            private boolean exact;
            private double wordsMatchingScore;
            private double wordsMatchingWithCaseScore;
            private int wordsMatchingCount;
            private double greedyMatchingScore;
            private int greedyMatchingCount;
            private double greedyMatchingWithCaseScore;
            private int greedyMatchingWithCaseCount;
            private int skippedWords;
            private int lastWord;
            private int lastWordSize;
            private int wordsCount;
            private int curWord = -1;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PrefixMatchingScores build(@NotNull String prefix, @NotNull String lookupString) {
                void $this$filterTo$iv$iv22;
                Intrinsics.checkParameterIsNotNull((Object)prefix, (String)PrefixMatchingUtil.baseName);
                Intrinsics.checkParameterIsNotNull((Object)lookupString, (String)"lookupString");
                CharSequence charSequence = prefix;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return EMPTY_PREFIX_MATCHING_SCORE;
                }
                String[] stringArray = NameUtil.nameToWords((String)lookupString);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"NameUtil.nameToWords(lookupString)");
                String[] $this$filter$iv = stringArray;
                boolean $i$f$filter = false;
                String[] stringArray2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                void var9_12 = $this$filterTo$iv$iv22;
                int n = ((void)var9_12).length;
                for (int i = 0; i < n; ++i) {
                    boolean bl2;
                    void element$iv$iv;
                    block11: {
                        void it = element$iv$iv = var9_12[i];
                        boolean bl3 = false;
                        void v1 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                        CharSequence $this$all$iv = (CharSequence)v1;
                        boolean $i$f$all = false;
                        CharSequence charSequence2 = $this$all$iv;
                        for (int j = 0; j < charSequence2.length(); ++j) {
                            char element$iv;
                            char it2 = element$iv = charSequence2.charAt(j);
                            boolean bl4 = false;
                            char c = it2;
                            boolean bl5 = false;
                            if (Character.isLetterOrDigit(c)) continue;
                            bl2 = false;
                            break block11;
                        }
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List words = (List)destination$iv$iv;
                this.startMatchingCount = StringsKt.commonPrefixWith((CharSequence)lookupString, (CharSequence)prefix, (boolean)true).length();
                this.exact = Intrinsics.areEqual((Object)lookupString, (Object)prefix);
                this.wordsCount = words.size();
                String string = (String)CollectionsKt.lastOrNull((List)words);
                if (string == null) {
                    string = "";
                }
                this.lastWordSize = string.length();
                CharIterator iter = StringsKt.iterator((CharSequence)prefix);
                char ch = iter.nextChar();
                boolean $this$filterTo$iv$iv22 = false;
                for (String word : (Iterable)words) {
                    void i;
                    char c = ch;
                    n = 0;
                    if (!Character.isLetterOrDigit(c)) {
                        if (StringsKt.contains$default((CharSequence)lookupString, (char)ch, (boolean)false, (int)2, null)) {
                            Character c2 = this.matchAndNext((int)i, true, (Iterator)iter);
                            if (c2 == null) {
                                break;
                            }
                            ch = c2.charValue();
                        } else {
                            Character c3 = this.next((Iterator)iter);
                            if (c3 == null) {
                                break;
                            }
                            ch = c3.charValue();
                        }
                    }
                    String string2 = word;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"word");
                    Character c4 = this.matchWord(string2, ch, (int)i, (Iterator)iter);
                    if (c4 == null) {
                        break;
                    }
                    ch = c4.charValue();
                    ++i;
                }
                return new PrefixMatchingScores(this.exact, this.lastWord == this.lastWordSize, this.startMatchingCount, this.greedyMatchingScore, this.greedyMatchingWithCaseScore, this.wordsMatchingScore, this.wordsCount == 0 ? 0.0 : this.wordsMatchingScore / (double)this.wordsCount, this.wordsMatchingWithCaseScore, this.wordsCount == 0 ? 0.0 : this.wordsMatchingWithCaseScore / (double)this.wordsCount, this.skippedWords, this.resolveMatchingType(prefix));
            }

            private final PrefixMatchingType resolveMatchingType(String prefix) {
                int n = prefix.length();
                return n == this.startMatchingCount ? PrefixMatchingType.START_WITH : (n == this.wordsMatchingCount ? PrefixMatchingType.WORDS_FIRST_CHAR : (n == this.greedyMatchingWithCaseCount ? PrefixMatchingType.GREEDY_WITH_CASE : (n == this.greedyMatchingCount ? PrefixMatchingType.GREEDY : PrefixMatchingType.UNKNOWN)));
            }

            private final Character matchWord(String word, char ch, int wordIndex, Iterator<Character> iter) {
                char wordCh;
                char curCh = ch;
                String string = word;
                int n = string.length();
                for (int i = 0; i < n && CharsKt.equals((char)(wordCh = string.charAt(i)), (char)curCh, (boolean)true); ++i) {
                    Character c = this.matchAndNext(wordIndex, wordCh == curCh, iter);
                    if (c == null) {
                        return null;
                    }
                    curCh = c.charValue();
                }
                return Character.valueOf(curCh);
            }

            private final Character matchAndNext(int wordIndex, boolean withCase, Iterator<Character> iter) {
                this.updateMatching(wordIndex, withCase);
                return this.next(iter);
            }

            private final Character next(Iterator<Character> iter) {
                return iter.hasNext() ? iter.next() : null;
            }

            private final void updateMatching(int word, boolean withCase) {
                if (word != this.curWord) {
                    int wordsDif = word - this.curWord;
                    this.skippedWords += wordsDif - 1;
                    double step = 1.0 / (double)wordsDif;
                    this.curWord = word;
                    this.wordsMatchingScore += step;
                    this.greedyMatchingScore += step;
                    int n = this.wordsMatchingCount;
                    this.wordsMatchingCount = n + 1;
                    if (withCase) {
                        this.greedyMatchingWithCaseScore += step;
                        this.wordsMatchingWithCaseScore += step;
                    }
                } else {
                    double d = this.greedyMatchingScore;
                    this.greedyMatchingScore = d + 1.0;
                    if (withCase) {
                        d = this.greedyMatchingWithCaseScore;
                        this.greedyMatchingWithCaseScore = d + 1.0;
                    }
                }
                int n = this.greedyMatchingCount;
                this.greedyMatchingCount = n + 1;
                if (withCase) {
                    n = this.greedyMatchingWithCaseCount;
                    this.greedyMatchingWithCaseCount = n + 1;
                }
                if (word == this.wordsCount - 1) {
                    n = this.lastWord;
                    this.lastWord = n + 1;
                }
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/completion/ml/common/PrefixMatchingUtil$PrefixMatchingScores$Companion;", "", "()V", "EMPTY_PREFIX_MATCHING_SCORE", "Lcom/intellij/completion/ml/common/PrefixMatchingUtil$PrefixMatchingScores;", "intellij.statsCollector"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

