/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.sender;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.stats.network.UtilsKt;
import com.intellij.stats.network.service.RequestService;
import com.intellij.stats.network.service.ResponseData;
import com.intellij.stats.sender.DailyLimitSendingWatcher;
import com.intellij.stats.sender.PersistentSentDataInfo;
import com.intellij.stats.sender.StatisticSender;
import com.intellij.stats.storage.FilePathProvider;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/stats/sender/StatisticSenderImpl;", "Lcom/intellij/stats/sender/StatisticSender;", "()V", "limitWatcher", "Lcom/intellij/stats/sender/DailyLimitSendingWatcher;", "sendContent", "", "url", "", "file", "Ljava/io/File;", "sendStatsData", "", "Companion", "intellij.statsCollector"})
public final class StatisticSenderImpl
implements StatisticSender {
    private final DailyLimitSendingWatcher limitWatcher;
    public static final int DAILY_LIMIT = 0xF00000;
    public static final Companion Companion = new Companion(null);

    @Override
    public void sendStatsData(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        UtilsKt.assertNotEDT();
        if (this.limitWatcher.isLimitReached()) {
            return;
        }
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(FilePathProvider.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        List<File> filesToSend = ((FilePathProvider)object).getDataFiles();
        Iterable $this$forEach$iv = filesToSend;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.length() <= 0L || this.limitWatcher.isLimitReached()) continue;
            boolean isSentSuccessfully = this.sendContent(url, it);
            if (isSentSuccessfully) {
                it.delete();
                continue;
            }
            return;
        }
    }

    private final boolean sendContent(String url, File file) {
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(RequestService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        ResponseData data = ((RequestService)object).postZipped(url, file);
        if (data != null && data.getCode() >= 200 && data.getCode() < 300) {
            if (data.getSentDataSize() != null) {
                this.limitWatcher.dataSent(data.getSentDataSize());
            }
            return true;
        }
        return false;
    }

    public StatisticSenderImpl() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)propertiesComponent, (String)"PropertiesComponent.getInstance()");
        this.limitWatcher = new DailyLimitSendingWatcher(0xF00000, new PersistentSentDataInfo(propertiesComponent));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/stats/sender/StatisticSenderImpl$Companion;", "", "()V", "DAILY_LIMIT", "", "intellij.statsCollector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

