/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.ProjectTopHitCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsOptionsTopHitProviderBase
implements OptionsSearchTopHitProvider.ProjectLevelProvider {
    protected boolean isEnabled(@NotNull Project project, @Nullable VcsKey vcsKey) {
        if (project == null) {
            VcsOptionsTopHitProviderBase.$$$reportNull$$$0(0);
        }
        if (project.isDefault()) {
            return true;
        }
        if (vcsKey == null) {
            return false;
        }
        List<AbstractVcs> activeVcses = Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss());
        return ContainerUtil.exists(activeVcses, it -> vcsKey.equals((Object)it.getKeyInstanceMethod()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/configurable/VcsOptionsTopHitProviderBase", "isEnabled"));
    }

    public static class InitMappingsListenerActivity
    implements ProjectManagerListener {
        public void projectOpened(@NotNull Project project) {
            if (project == null) {
                InitMappingsListenerActivity.$$$reportNull$$$0(0);
            }
            project.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> InitMappingsListenerActivity.invalidateTopHitCaches(project));
        }

        private static void invalidateTopHitCaches(@NotNull Project project) {
            if (project == null) {
                InitMappingsListenerActivity.$$$reportNull$$$0(1);
            }
            for (OptionsSearchTopHitProvider.ProjectLevelProvider provider : OptionsTopHitProvider.PROJECT_LEVEL_EP.getExtensionList()) {
                if (!(provider instanceof VcsOptionsTopHitProviderBase)) continue;
                ProjectTopHitCache.getInstance((Project)project).invalidateCachedOptions(provider.getClass());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsOptionsTopHitProviderBase$InitMappingsListenerActivity";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectOpened";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invalidateTopHitCaches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

