/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopiesContent;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.BranchConfigurationDialog;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.ChangeFormatDialog;
import org.jetbrains.idea.svn.dialogs.SvnFormatWorker;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.dialogs.WorkingCopyInfoPanel;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.QuickMergeInteractionImpl;

public class CopiesPanel
extends SimpleToolWindowPanel {
    private static final Logger LOG = Logger.getInstance(CopiesPanel.class);
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Svn Roots Detection Errors", NotificationDisplayType.STICKY_BALLOON, true);
    private static final String TOOLBAR_GROUP = "Svn.WorkingCopiesView.Toolbar";
    private static final String TOOLBAR_PLACE = "Svn.WorkingCopiesView";
    private final Project myProject;
    private final JPanel myPanel;
    private boolean isRefreshing;
    private static final String CHANGE_FORMAT = "CHANGE_FORMAT";
    private static final String CLEANUP = "CLEANUP";
    private static final String FIX_DEPTH = "FIX_DEPTH";
    private static final String CONFIGURE_BRANCHES = "CONFIGURE_BRANCHES";
    private static final String MERGE_FROM = "MERGE_FROM";

    public CopiesPanel(@NotNull Project project) {
        if (project == null) {
            CopiesPanel.$$$reportNull$$$0(0);
        }
        super(false, true);
        this.myPanel = new JBPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)8)));
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(SvnVcs.ROOTS_RELOADED, this::rootsReloaded);
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myPanel));
        ActionGroup toolbarGroup = (ActionGroup)ActionManager.getInstance().getAction(TOOLBAR_GROUP);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(TOOLBAR_PLACE, toolbarGroup, false);
        this.setToolbar(toolbar.getComponent());
        this.rootsReloaded(true);
        this.refresh();
    }

    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    public void refresh() {
        if (this.isRefreshing) {
            return;
        }
        this.isRefreshing = true;
        this.getVcs().invokeRefreshSvnRoots();
    }

    @NotNull
    private SvnVcs getVcs() {
        SvnVcs svnVcs = SvnVcs.getInstance(this.myProject);
        if (svnVcs == null) {
            CopiesPanel.$$$reportNull$$$0(1);
        }
        return svnVcs;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            CopiesPanel.$$$reportNull$$$0(2);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.vcs.svn.working.copies.information";
        }
        return super.getData(dataId);
    }

    private void rootsReloaded(boolean rootsChanged) {
        if (rootsChanged) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.doRefresh();
            } else {
                ApplicationManager.getApplication().executeOnPooledThread(this::doRefresh);
            }
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.isRefreshing = false;
            }, ModalityState.NON_MODAL);
        }
    }

    private void doRefresh() {
        List<WCInfo> infoList = this.getVcs().getWcInfosWithErrors();
        boolean hasErrors = !this.getVcs().getSvnFileUrlMapping().getErrorRoots().isEmpty();
        List<WorkingCopyFormat> supportedFormats = this.getSupportedFormats();
        ApplicationManager.getApplication().invokeLater(() -> this.setWorkingCopies(infoList, hasErrors, supportedFormats), ModalityState.NON_MODAL);
    }

    private void setWorkingCopies(@NotNull List<WCInfo> infoList, boolean hasErrors, List<WorkingCopyFormat> supportedFormats) {
        if (infoList == null) {
            CopiesPanel.$$$reportNull$$$0(3);
        }
        infoList.sort(Comparator.comparing(WCInfo::getPath));
        this.updateList(infoList, supportedFormats);
        this.isRefreshing = false;
        this.showErrorNotification(hasErrors);
    }

    private void updateList(@NotNull List<WCInfo> infoList, @NotNull List<WorkingCopyFormat> supportedFormats) {
        if (infoList == null) {
            CopiesPanel.$$$reportNull$$$0(4);
        }
        if (supportedFormats == null) {
            CopiesPanel.$$$reportNull$$$0(5);
        }
        this.myPanel.removeAll();
        for (final WCInfo wcInfo : infoList) {
            final Set<WorkingCopyFormat> upgradeFormats = CopiesPanel.getUpgradeFormats(wcInfo, supportedFormats);
            final WorkingCopyInfoPanel infoPanel = new WorkingCopyInfoPanel();
            infoPanel.setInfo(wcInfo);
            infoPanel.setUpgradeFormats(upgradeFormats);
            infoPanel.setFocusable(true);
            infoPanel.setBorder(null);
            infoPanel.update();
            infoPanel.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                        return;
                    }
                    CopiesPanel.this.performAction(wcInfo, upgradeFormats, infoPanel, e.getDescription());
                }
            });
            this.myPanel.add((Component)((Object)infoPanel));
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    static String formatWc(@NotNull WCInfo info2, @NotNull Collection<WorkingCopyFormat> upgradeFormats) {
        if (info2 == null) {
            CopiesPanel.$$$reportNull$$$0(6);
        }
        if (upgradeFormats == null) {
            CopiesPanel.$$$reportNull$$$0(7);
        }
        StringBuilder sb = new StringBuilder().append("<table>");
        sb.append("<tr valign=\"top\"><td colspan=\"3\"><b>").append(info2.getPath()).append("</b></td></tr>");
        if (info2.hasError()) {
            sb.append("<tr valign=\"top\"><td>URL:</td><td colspan=\"2\" color=\"").append(ColorUtil.toHex((Color)JBColor.red)).append("\">").append(info2.getErrorMessage()).append("</td></tr>");
        } else {
            sb.append("<tr valign=\"top\"><td>URL:</td><td colspan=\"2\">").append(info2.getUrl().toDecodedString()).append("</td></tr>");
        }
        if (upgradeFormats.size() > 1) {
            sb.append("<tr valign=\"top\"><td>Format:</td><td>").append(info2.getFormat().getName()).append("</td><td><a href=\"").append(CHANGE_FORMAT).append("\">Change</a></td></tr>");
        } else {
            sb.append("<tr valign=\"top\"><td>Format:</td><td colspan=\"2\">").append(info2.getFormat().getName()).append("</td></tr>");
        }
        if (!Depth.INFINITY.equals((Object)info2.getStickyDepth()) && !info2.hasError()) {
            sb.append("<tr valign=\"top\"><td>Depth:</td><td>").append(info2.getStickyDepth().getName()).append("</td><td><a href=\"").append(FIX_DEPTH).append("\">Fix</a></td></tr>");
        } else {
            sb.append("<tr valign=\"top\"><td>Depth:</td><td colspan=\"2\">").append(info2.getStickyDepth().getName()).append("</td></tr>");
        }
        NestedCopyType type = info2.getType();
        if (NestedCopyType.external.equals((Object)type) || NestedCopyType.switched.equals((Object)type)) {
            sb.append("<tr valign=\"top\"><td colspan=\"3\"><i>").append(type.getName()).append("</i></td></tr>");
        }
        if (info2.isIsWcRoot()) {
            sb.append("<tr valign=\"top\"><td colspan=\"3\"><i>").append("Working copy root</i></td></tr>");
        }
        if (!info2.hasError()) {
            if (info2.getFormat().isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN)) {
                sb.append("<tr valign=\"top\"><td colspan=\"3\"><a href=\"").append(CLEANUP).append("\">Cleanup</a></td></tr>");
            }
            sb.append("<tr valign=\"top\"><td colspan=\"3\"><a href=\"").append(CONFIGURE_BRANCHES).append("\">Configure Branches</a></td></tr>");
            sb.append("<tr valign=\"top\"><td colspan=\"3\"><a href=\"").append(MERGE_FROM).append("\"><b>Merge From...</b></a></i></td></tr>");
            sb.append("</table>");
        }
        return sb.toString();
    }

    @NotNull
    private List<WorkingCopyFormat> getSupportedFormats() {
        ArrayList<WorkingCopyFormat> result = new ArrayList<WorkingCopyFormat>();
        ClientFactory factory = this.getVcs().getFactory();
        try {
            result.addAll(factory.createUpgradeClient().getSupportedFormats());
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        ArrayList<WorkingCopyFormat> arrayList = result;
        if (arrayList == null) {
            CopiesPanel.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static Set<WorkingCopyFormat> getUpgradeFormats(@NotNull WCInfo info2, @NotNull List<WorkingCopyFormat> supportedFormats) {
        if (info2 == null) {
            CopiesPanel.$$$reportNull$$$0(9);
        }
        if (supportedFormats == null) {
            CopiesPanel.$$$reportNull$$$0(10);
        }
        EnumSet<WorkingCopyFormat> canUpgradeTo = EnumSet.noneOf(WorkingCopyFormat.class);
        for (WorkingCopyFormat format : supportedFormats) {
            if (!format.isOrGreater(info2.getFormat())) continue;
            canUpgradeTo.add(format);
        }
        canUpgradeTo.add(info2.getFormat());
        return canUpgradeTo;
    }

    private boolean checkRoot(@NotNull VirtualFile root, @NotNull String actionName) {
        if (root == null) {
            CopiesPanel.$$$reportNull$$$0(11);
        }
        if (actionName == null) {
            CopiesPanel.$$$reportNull$$$0(12);
        }
        if (root.isValid()) {
            return true;
        }
        Messages.showWarningDialog((Project)this.myProject, (String)("Invalid working copy root: " + root.getPath()), (String)("Can not " + actionName));
        return false;
    }

    private void performAction(@NotNull WCInfo wcInfo, @NotNull Collection<WorkingCopyFormat> upgradeFormats, @NotNull WorkingCopyInfoPanel infoPanel, @Nullable String actionName) {
        if (wcInfo == null) {
            CopiesPanel.$$$reportNull$$$0(13);
        }
        if (upgradeFormats == null) {
            CopiesPanel.$$$reportNull$$$0(14);
        }
        if (infoPanel == null) {
            CopiesPanel.$$$reportNull$$$0(15);
        }
        if (CONFIGURE_BRANCHES.equals(actionName)) {
            this.configureBranches(wcInfo);
        } else if (FIX_DEPTH.equals(actionName)) {
            this.fixDepth(wcInfo);
        } else if (CHANGE_FORMAT.equals(actionName)) {
            this.changeFormat(wcInfo, upgradeFormats);
        } else if (MERGE_FROM.equals(actionName)) {
            this.mergeFrom(wcInfo, infoPanel);
        } else if (CLEANUP.equals(actionName)) {
            this.cleanup(wcInfo);
        }
    }

    private void configureBranches(@NotNull WCInfo info2) {
        VirtualFile root;
        if (info2 == null) {
            CopiesPanel.$$$reportNull$$$0(16);
        }
        if (!this.checkRoot(root = info2.getRootInfo().getVirtualFile(), " invoke Configure Branches")) {
            return;
        }
        BranchConfigurationDialog.configureBranches(this.myProject, root);
    }

    private void fixDepth(@NotNull WCInfo info2) {
        int result;
        if (info2 == null) {
            CopiesPanel.$$$reportNull$$$0(17);
        }
        if ((result = Messages.showOkCancelDialog((Project)this.myProject, (String)("You are going to checkout into '" + info2.getPath() + "' with 'infinity' depth.\nThis will update your working copy to HEAD revision as well."), (String)"Set Working Copy Infinity Depth", (Icon)Messages.getWarningIcon())) == 0) {
            SvnCheckoutProvider.checkout(this.myProject, new File(info2.getPath()), info2.getUrl(), Revision.HEAD, Depth.INFINITY, false, null, info2.getFormat());
        }
    }

    private void mergeFrom(@NotNull WCInfo info2, @NotNull WorkingCopyInfoPanel infoPanel) {
        VirtualFile root;
        if (info2 == null) {
            CopiesPanel.$$$reportNull$$$0(18);
        }
        if (infoPanel == null) {
            CopiesPanel.$$$reportNull$$$0(19);
        }
        if (!this.checkRoot(root = info2.getRootInfo().getVirtualFile(), " invoke Merge From")) {
            return;
        }
        SelectBranchPopup.showForBranchRoot(this.myProject, root, (project, configuration, branchUrl, revision) -> {
            try {
                Url workingCopyUrlInSelectedBranch = CopiesPanel.getCorrespondingUrlInOtherBranch(configuration, info2.getUrl(), branchUrl);
                MergeContext mergeContext = new MergeContext(this.getVcs(), workingCopyUrlInSelectedBranch, info2, branchUrl.getTail(), root);
                new QuickMerge(mergeContext, new QuickMergeInteractionImpl(mergeContext)).execute();
            }
            catch (SvnBindException e) {
                AbstractVcsHelper.getInstance((Project)this.myProject).showError((VcsException)e, "Merge from " + branchUrl.getTail());
            }
        }, "Select branch", (Component)((Object)infoPanel));
    }

    private void cleanup(@NotNull WCInfo info2) {
        VirtualFile root;
        if (info2 == null) {
            CopiesPanel.$$$reportNull$$$0(20);
        }
        if (!this.checkRoot(root = info2.getRootInfo().getVirtualFile(), " invoke Cleanup")) {
            return;
        }
        new CleanupWorker(this.getVcs(), Collections.singletonList(root)).execute();
    }

    @NotNull
    private static Url getCorrespondingUrlInOtherBranch(@NotNull SvnBranchConfigurationNew configuration, @NotNull Url url, @NotNull Url otherBranchUrl) throws SvnBindException {
        if (configuration == null) {
            CopiesPanel.$$$reportNull$$$0(21);
        }
        if (url == null) {
            CopiesPanel.$$$reportNull$$$0(22);
        }
        if (otherBranchUrl == null) {
            CopiesPanel.$$$reportNull$$$0(23);
        }
        Url url2 = otherBranchUrl.appendPath(StringUtil.notNullize((String)configuration.getRelativeUrl(url)), false);
        if (url2 == null) {
            CopiesPanel.$$$reportNull$$$0(24);
        }
        return url2;
    }

    private void changeFormat(@NotNull WCInfo wcInfo, @NotNull Collection<WorkingCopyFormat> supportedFormats) {
        if (wcInfo == null) {
            CopiesPanel.$$$reportNull$$$0(25);
        }
        if (supportedFormats == null) {
            CopiesPanel.$$$reportNull$$$0(26);
        }
        ChangeFormatDialog dialog = new ChangeFormatDialog(this.myProject, new File(wcInfo.getPath()), false, !wcInfo.isIsWcRoot());
        dialog.setSupported(supportedFormats);
        dialog.setData(wcInfo.getFormat());
        if (!dialog.showAndGet()) {
            return;
        }
        WorkingCopyFormat newFormat = dialog.getUpgradeMode();
        if (!wcInfo.getFormat().equals((Object)newFormat)) {
            StoreUtil.saveDocumentsAndProjectSettings((Project)this.myProject);
            SvnFormatWorker task = new SvnFormatWorker(this.myProject, newFormat, wcInfo){

                @Override
                public void onSuccess() {
                    super.onSuccess();
                    CopiesPanel.this.refresh();
                }
            };
            ProgressManager.getInstance().run((Task)task);
        }
    }

    private void showErrorNotification(boolean hasErrors) {
        NotificationsManager manager = NotificationsManager.getNotificationsManager();
        ErrorsFoundNotification[] notifications = (ErrorsFoundNotification[])manager.getNotificationsOfType(ErrorsFoundNotification.class, this.myProject);
        if (hasErrors) {
            if (notifications.length == 0) {
                new ErrorsFoundNotification(this.myProject).notify(this.myProject.isDefault() ? null : this.myProject);
            }
        } else {
            for (ErrorsFoundNotification notification : notifications) {
                notification.expire();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/CopiesPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoList";
                break;
            }
            case 5: 
            case 10: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedFormats";
                break;
            }
            case 6: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upgradeFormats";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wcInfo";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoPanel";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherBranchUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/CopiesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFormats";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingUrlInOtherBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingCopies";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatWc";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUpgradeFormats";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkRoot";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "configureBranches";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fixDepth";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "mergeFrom";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingUrlInOtherBranch";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "changeFormat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ErrorsFoundNotification
    extends Notification {
        private static final String FIX_ACTION = "FIX";
        private static final String TITLE = "";

        private ErrorsFoundNotification(@NotNull Project project) {
            if (project == null) {
                ErrorsFoundNotification.$$$reportNull$$$0(0);
            }
            super(NOTIFICATION_GROUP.getDisplayId(), TITLE, ErrorsFoundNotification.getDescription(), NotificationType.ERROR, (NotificationListener)ErrorsFoundNotification.createListener(project));
        }

        private static NotificationListener.Adapter createListener(final @NotNull Project project) {
            if (project == null) {
                ErrorsFoundNotification.$$$reportNull$$$0(1);
            }
            return new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (ErrorsFoundNotification.FIX_ACTION.equals(event.getDescription())) {
                        WorkingCopiesContent.show(project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/idea/svn/dialogs/CopiesPanel$ErrorsFoundNotification$1";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private static String getDescription() {
            return SvnBundle.message("subversion.roots.detection.errors.found.description", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "org/jetbrains/idea/svn/dialogs/CopiesPanel$ErrorsFoundNotification";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

