/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnEditCommitMessageDialog;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class SvnEditCommitMessageAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dc;
        ChangeList[] lists;
        boolean enabled;
        if (e == null) {
            SvnEditCommitMessageAction.$$$reportNull$$$0(0);
        }
        boolean bl = enabled = (lists = (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(dc = e.getDataContext())) != null && lists.length == 1 && lists[0] instanceof SvnChangeList;
        if (!enabled) {
            return;
        }
        SvnChangeList svnList = (SvnChangeList)lists[0];
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        project = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        Consumer listener2 = (Consumer)VcsDataKeys.REMOTE_HISTORY_CHANGED_LISTENER.getData(dc);
        SvnEditCommitMessageAction.askAndEditRevision(svnList.getNumber(), svnList.getComment(), svnList.getLocation(), project, (Consumer<? super String>)listener2, false);
    }

    public static void askAndEditRevision(long number, String oldComment, SvnRepositoryLocation location, Project project, Consumer<? super String> listener2, boolean fromVersionControl) {
        SvnEditCommitMessageDialog dialog = new SvnEditCommitMessageDialog(project, number, oldComment);
        dialog.show();
        if (0 == dialog.getExitCode()) {
            String edited = dialog.getMessage();
            if (edited.trim().equals(oldComment.trim())) {
                return;
            }
            ProgressManager.getInstance().run((Task)new EditMessageTask(project, edited, location, number, listener2, fromVersionControl));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        DataContext dc;
        ChangeList[] lists;
        boolean enabled;
        if (e == null) {
            SvnEditCommitMessageAction.$$$reportNull$$$0(1);
        }
        boolean visible = enabled = (lists = (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(dc = e.getDataContext())) != null && lists.length == 1 && lists[0] instanceof SvnChangeList;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        visible = project == null ? VcsDataKeys.REMOTE_HISTORY_LOCATION.getData(dc) instanceof SvnRepositoryLocation : ProjectLevelVcsManager.getInstance((Project)project).checkVcsIsActive("svn");
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/idea/svn/history/SvnEditCommitMessageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class EditMessageTask
    extends Task.Backgroundable {
        private final String myNewMessage;
        private final SvnRepositoryLocation myLocation;
        private final long myNumber;
        private final Consumer<? super String> myListener;
        private final boolean myFromVersionControl;
        private VcsException myException;
        private final SvnVcs myVcs;

        EditMessageTask(@Nullable Project project, String newMessage, SvnRepositoryLocation location, long number, Consumer<? super String> listener2, boolean fromVersionControl) {
            super(project, "Edit Revision Comment");
            this.myNewMessage = newMessage;
            this.myLocation = location;
            this.myNumber = number;
            this.myListener = listener2;
            this.myFromVersionControl = fromVersionControl;
            this.myVcs = SvnVcs.getInstance(this.myProject);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                EditMessageTask.$$$reportNull$$$0(0);
            }
            String url = this.myLocation.getURL();
            try {
                Url root = SvnUtil.getRepositoryRoot(this.myVcs, SvnUtil.createUrl(url));
                if (root == null) {
                    this.myException = new VcsException("Can not determine repository root for URL: " + url);
                    return;
                }
                Target target = Target.on(root);
                this.myVcs.getFactory(target).createPropertyClient().setRevisionProperty(target, "svn:log", Revision.of(this.myNumber), PropertyValue.create(this.myNewMessage), false);
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }

        public void onSuccess() {
            if (this.myException != null) {
                AbstractVcsHelper.getInstance((Project)this.myProject).showError(this.myException, this.myTitle);
            } else {
                if (this.myListener != null) {
                    this.myListener.consume((Object)this.myNewMessage);
                }
                if (!this.myProject.isDefault()) {
                    CommittedChangesCache.getInstance((Project)this.myProject).commitMessageChanged((RepositoryLocation)this.myLocation, this.myNumber, this.myNewMessage);
                }
                if (this.myFromVersionControl) {
                    VcsBalloonProblemNotifier.showOverVersionControlView((Project)this.myProject, (String)("Revision #" + this.myNumber + " comment changed to:\n'" + this.myNewMessage + "'"), (MessageType)MessageType.INFO);
                } else {
                    VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)("Revision #" + this.myNumber + " comment changed to:\n'" + this.myNewMessage + "'"), (MessageType)MessageType.INFO, (NamedRunnable[])new NamedRunnable[0]);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/svn/history/SvnEditCommitMessageAction$EditMessageTask", "run"));
        }
    }
}

