/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.util;

import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CalloutBorder
implements Border {
    @NotNull
    private static final Insets INSETS = new Insets(10, 8, 4, 8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(JBColor.border());
        Graphics2D g2 = (Graphics2D)g;
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            CalloutBorder.doPaint(c, g, x, y, width, height);
        }
        finally {
            g.setColor(oldColor);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
        }
    }

    private static void doPaint(Component c, Graphics g, int x, int y, int width, int height) {
        g.drawLine(x + CalloutBorder.INSETS.left - 1, y + CalloutBorder.INSETS.top - 1, x + CalloutBorder.INSETS.left - 1, y + height - CalloutBorder.INSETS.bottom - 1);
        g.drawLine(x + CalloutBorder.INSETS.left - 1, y + height - CalloutBorder.INSETS.bottom, x + width - CalloutBorder.INSETS.right, y + height - CalloutBorder.INSETS.bottom);
        g.drawLine(x + width - CalloutBorder.INSETS.right, y + height - CalloutBorder.INSETS.bottom - 1, x + width - CalloutBorder.INSETS.right, y + CalloutBorder.INSETS.top - 1);
        int calloutWidth = CalloutBorder.INSETS.top * 3 / 2;
        if (calloutWidth % 2 != 0) {
            ++calloutWidth;
        }
        int hPadding = CalloutBorder.INSETS.left + CalloutBorder.INSETS.right;
        int leftTopWidth = (width - hPadding - calloutWidth) / 2;
        g.drawLine(x + CalloutBorder.INSETS.left - 1, y + CalloutBorder.INSETS.top - 1, x + CalloutBorder.INSETS.left - 1 + leftTopWidth, y + CalloutBorder.INSETS.top - 1);
        int rightTopWidth = width - leftTopWidth - hPadding - calloutWidth;
        g.drawLine(x + width - rightTopWidth - CalloutBorder.INSETS.right, y + CalloutBorder.INSETS.top - 1, x + width - CalloutBorder.INSETS.right, y + CalloutBorder.INSETS.top - 1);
        g.drawLine(x + CalloutBorder.INSETS.left - 1 + leftTopWidth, y + CalloutBorder.INSETS.top - 1, x + CalloutBorder.INSETS.left - 1 + leftTopWidth + calloutWidth / 2, 0);
        g.drawLine(x + CalloutBorder.INSETS.left - 1 + leftTopWidth + calloutWidth / 2, 0, x + width - rightTopWidth - CalloutBorder.INSETS.right, y + CalloutBorder.INSETS.top - 1);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return (Insets)INSETS.clone();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

