/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.highlighting.BraceHighlighter;
import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.codeInsight.highlighting.CodeBlockSupportHandler;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.model.psi.impl.TargetsKt;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdentifierHighlighterPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(IdentifierHighlighterPass.class);
    private final PsiFile myFile;
    private final Editor myEditor;
    private final Collection<TextRange> myReadAccessRanges;
    private final Collection<TextRange> myWriteAccessRanges;
    private final Collection<TextRange> myCodeBlockMarkerRanges;
    private final int myCaretOffset;
    private final ProperTextRange myVisibleRange;

    IdentifierHighlighterPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (project == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(2);
        }
        super(project, editor.getDocument(), false);
        this.myReadAccessRanges = Collections.synchronizedList(new ArrayList());
        this.myWriteAccessRanges = Collections.synchronizedList(new ArrayList());
        this.myCodeBlockMarkerRanges = Collections.synchronizedList(new ArrayList());
        this.myFile = file2;
        this.myEditor = editor;
        this.myCaretOffset = this.myEditor.getCaretModel().getOffset();
        this.myVisibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(this.myEditor);
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        HighlightUsagesHandlerBase highlightUsagesHandler;
        if (progress2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(3);
        }
        if ((highlightUsagesHandler = HighlightUsagesHandler.createCustomHandler(this.myEditor, this.myFile, this.myVisibleRange)) != null) {
            List targets2 = highlightUsagesHandler.getTargets();
            highlightUsagesHandler.computeUsages(targets2);
            List<TextRange> readUsages = highlightUsagesHandler.getReadUsages();
            for (TextRange readUsage : readUsages) {
                LOG.assertTrue(readUsage != null, (Object)("null text range from " + highlightUsagesHandler));
            }
            this.myReadAccessRanges.addAll(readUsages);
            List<TextRange> writeUsages = highlightUsagesHandler.getWriteUsages();
            for (TextRange writeUsage : writeUsages) {
                LOG.assertTrue(writeUsage != null, (Object)("null text range from " + highlightUsagesHandler));
            }
            this.myWriteAccessRanges.addAll(writeUsages);
            if (!highlightUsagesHandler.highlightReferences()) {
                return;
            }
        }
        this.collectCodeBlockMarkerRanges();
        if (Registry.is((String)"ide.symbol.identifier.highlighting")) {
            this.highlightReferencesAndDeclarations();
        } else {
            this.highlightReferencesAndDeclarationsOld();
        }
    }

    private void highlightReferencesAndDeclarationsOld() {
        PsiElement myTarget;
        int flags = 3;
        try {
            myTarget = TargetElementUtil.getInstance().findTargetElement(this.myEditor, flags, this.myCaretOffset);
        }
        catch (IndexNotReadyException e) {
            return;
        }
        if (myTarget == null && !PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
            Editor injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.myFile, this.myCaretOffset);
            myTarget = TargetElementUtil.getInstance().findTargetElement(injectedEditor, flags, injectedEditor.getCaretModel().getOffset());
        }
        if (myTarget != null) {
            this.highlightTargetUsages(myTarget);
        } else {
            PsiReference ref = TargetElementUtil.findReference(this.myEditor);
            if (ref instanceof PsiPolyVariantReference) {
                if (!ref.getElement().isValid()) {
                    throw new PsiInvalidElementAccessException(ref.getElement(), "Invalid element in " + ref + " of " + ref.getClass() + "; editor=" + this.myEditor);
                }
                ResolveResult[] results = ((PsiPolyVariantReference)ref).multiResolve(false);
                if (results.length > 0) {
                    for (ResolveResult result2 : results) {
                        PsiElement target2 = result2.getElement();
                        if (target2 == null) continue;
                        if (!target2.isValid()) {
                            throw new PsiInvalidElementAccessException(target2, "Invalid element returned from " + ref + " of " + ref.getClass() + "; editor=" + this.myEditor);
                        }
                        this.highlightTargetUsages(target2);
                    }
                }
            }
        }
    }

    private void collectCodeBlockMarkerRanges() {
        PsiElement contextElement = this.myFile.findElementAt(TargetElementUtil.adjustOffset(this.myFile, this.myEditor.getDocument(), this.myEditor.getCaretModel().getOffset()));
        this.myCodeBlockMarkerRanges.addAll(CodeBlockSupportHandler.findMarkersRanges(contextElement));
    }

    @NotNull
    public static Couple<Collection<TextRange>> getHighlightUsages(@NotNull PsiElement target2, PsiElement psiElement, boolean withDeclarations) {
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(4);
        }
        return IdentifierHighlighterPass.getUsages(target2, psiElement, withDeclarations, true);
    }

    @NotNull
    public static Collection<TextRange> getUsages(@NotNull PsiElement target2, PsiElement psiElement, boolean withDeclarations) {
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(5);
        }
        Collection collection = (Collection)IdentifierHighlighterPass.getUsages((PsiElement)target2, (PsiElement)psiElement, (boolean)withDeclarations, (boolean)false).first;
        if (collection == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    private static Couple<Collection<TextRange>> getUsages(@NotNull PsiElement target2, PsiElement psiElement, boolean withDeclarations, boolean detectAccess) {
        TextRange declRange;
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(7);
        }
        ArrayList<TextRange> readRanges = new ArrayList<TextRange>();
        ArrayList<TextRange> writeRanges = new ArrayList<TextRange>();
        ReadWriteAccessDetector detector = detectAccess ? ReadWriteAccessDetector.findDetector((PsiElement)target2) : null;
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)target2.getProject())).getFindUsagesManager();
        FindUsagesHandler findUsagesHandler = findUsagesManager.getFindUsagesHandler(target2, true);
        LocalSearchScope scope = new LocalSearchScope(psiElement);
        Collection refs = findUsagesHandler != null ? findUsagesHandler.findReferencesToHighlight(target2, (SearchScope)scope) : ReferencesSearch.search((PsiElement)target2, (SearchScope)scope).findAll();
        for (PsiReference psiReference : refs) {
            if (psiReference == null) {
                LOG.error("Null reference returned, findUsagesHandler=" + findUsagesHandler + "; target=" + target2 + " of " + target2.getClass());
                continue;
            }
            ArrayList<TextRange> destination = detector == null || detector.getReferenceAccess(target2, psiReference) == ReadWriteAccessDetector.Access.Read ? readRanges : writeRanges;
            HighlightUsagesHandler.collectHighlightRanges((PsiSymbolReference)psiReference, destination);
        }
        if (withDeclarations && (declRange = HighlightUsagesHandler.getNameIdentifierRange(psiElement.getContainingFile(), target2)) != null) {
            if (detector != null && detector.isDeclarationWriteAccess(target2)) {
                writeRanges.add(declRange);
            } else {
                readRanges.add(declRange);
            }
        }
        Couple couple = Couple.of(readRanges, writeRanges);
        if (couple == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(8);
        }
        return couple;
    }

    private void highlightTargetUsages(@NotNull PsiElement target2) {
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(9);
        }
        Couple usages = (Couple)AstLoadingFilter.disallowTreeLoading(() -> IdentifierHighlighterPass.getHighlightUsages(target2, (PsiElement)this.myFile, true), () -> "Currently highlighted file: \npsi file: " + this.myFile + ";\nvirtual file: " + this.myFile.getVirtualFile());
        this.myReadAccessRanges.addAll((Collection)usages.first);
        this.myWriteAccessRanges.addAll((Collection)usages.second);
    }

    private void highlightReferencesAndDeclarations() {
        Collection<Symbol> targetSymbols = this.getTargetSymbols();
        for (Symbol symbol : targetSymbols) {
            this.highlightTargetUsages(symbol);
        }
    }

    @NotNull
    private @NotNull Collection<@NotNull Symbol> getTargetSymbols() {
        block6: {
            Collection<Symbol> collection;
            try {
                Collection<Symbol> fromHostFile = TargetsKt.targetSymbols(this.myFile, this.myCaretOffset);
                if (fromHostFile.isEmpty()) break block6;
                collection = fromHostFile;
            }
            catch (IndexNotReadyException fromHostFile) {
                // empty catch block
            }
            if (collection == null) {
                IdentifierHighlighterPass.$$$reportNull$$$0(10);
            }
            return collection;
        }
        Editor injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.myFile, this.myCaretOffset);
        PsiFile injectedFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(injectedEditor.getDocument());
        if (injectedFile == null) {
            List<Symbol> list2 = Collections.emptyList();
            if (list2 == null) {
                IdentifierHighlighterPass.$$$reportNull$$$0(11);
            }
            return list2;
        }
        int injectedOffset = injectedEditor.getCaretModel().getOffset();
        Collection<Symbol> collection = TargetsKt.targetSymbols(injectedFile, injectedOffset);
        if (collection == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private void highlightTargetUsages(@NotNull Symbol target2) {
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(13);
        }
        Couple usages = (Couple)AstLoadingFilter.disallowTreeLoading(() -> IdentifierHighlighterPass.getUsages(this.myFile, target2), () -> "Currently highlighted file: \npsi file: " + this.myFile + ";\nvirtual file: " + this.myFile.getVirtualFile());
        this.myReadAccessRanges.addAll((Collection)usages.first);
        this.myWriteAccessRanges.addAll((Collection)usages.second);
    }

    @ApiStatus.Internal
    @NotNull
    public static Couple<List<TextRange>> getUsages(@NotNull PsiFile file2, @NotNull Symbol symbol) {
        if (file2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(14);
        }
        if (symbol == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(15);
        }
        ArrayList readRanges = new ArrayList();
        ArrayList writeRanges = new ArrayList();
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)file2);
        Project project = file2.getProject();
        PsiElement psiTarget = PsiSymbolService.getInstance().extractElementFromSymbol(symbol);
        ReadWriteAccessDetector detector = psiTarget != null ? ReadWriteAccessDetector.findDetector((PsiElement)psiTarget) : null;
        Collection<? extends PsiSymbolReference> refs = IdentifierHighlighterPass.getReferences(project, (SearchScope)searchScope, symbol, psiTarget);
        for (PsiSymbolReference psiSymbolReference : refs) {
            boolean write2 = detector != null && psiSymbolReference instanceof PsiReference && detector.getReferenceAccess(psiTarget, (PsiReference)psiSymbolReference) != ReadWriteAccessDetector.Access.Read;
            HighlightUsagesHandler.collectHighlightRanges(psiSymbolReference, write2 ? writeRanges : readRanges);
        }
        Collection declarations = SearchService.getInstance().searchPsiSymbolDeclarations(project, symbol, (SearchScope)searchScope).findAll();
        boolean bl = psiTarget != null && detector != null && detector.isDeclarationWriteAccess(psiTarget);
        for (PsiSymbolDeclaration declaration : declarations) {
            HighlightUsagesHandler.collectHighlightRanges(declaration.getDeclaringElement(), declaration.getDeclarationRange(), bl ? writeRanges : readRanges);
        }
        Couple couple = Couple.of(readRanges, writeRanges);
        if (couple == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(16);
        }
        return couple;
    }

    @NotNull
    private static Collection<? extends PsiSymbolReference> getReferences(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Symbol symbol, @Nullable PsiElement psiTarget) {
        FindUsagesHandler oldHandler;
        if (project == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(18);
        }
        if (symbol == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(19);
        }
        if (psiTarget != null && (oldHandler = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager().getFindUsagesHandler(psiTarget, true)) != null) {
            Collection<PsiReference> collection = oldHandler.findReferencesToHighlight(psiTarget, searchScope);
            if (collection == null) {
                IdentifierHighlighterPass.$$$reportNull$$$0(20);
            }
            return collection;
        }
        Collection collection = SearchService.getInstance().searchPsiSymbolReferences(project, symbol, searchScope).findAll();
        if (collection == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @Override
    public void doApplyInformationToEditor() {
        boolean virtSpace = EditorUtil.isCaretInVirtualSpace(this.myEditor);
        List infos = virtSpace || this.isCaretOverCollapsedFoldRegion() ? Collections.emptyList() : this.getHighlights();
        UpdateHighlightersUtil.setHighlightersToSingleEditor(this.myProject, this.myEditor, 0, this.myFile.getTextLength(), infos, this.getColorsScheme(), this.getId());
        this.doAdditionalCodeBlockHighlighting();
    }

    private boolean isCaretOverCollapsedFoldRegion() {
        return this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(this.myEditor.getCaretModel().getOffset()) != null;
    }

    private void doAdditionalCodeBlockHighlighting() {
        if (this.myCodeBlockMarkerRanges.size() < 2 || !(this.myEditor instanceof EditorEx)) {
            return;
        }
        ArrayList<TextRange> markers = new ArrayList<TextRange>(this.myCodeBlockMarkerRanges);
        markers.sort(Segment.BY_START_OFFSET_THEN_END_OFFSET);
        TextRange leftBraceRange = markers.get(0);
        TextRange rightBraceRange = markers.get(markers.size() - 1);
        int startLine = this.myEditor.offsetToLogicalPosition((int)leftBraceRange.getStartOffset()).line;
        int endLine = this.myEditor.offsetToLogicalPosition((int)rightBraceRange.getEndOffset()).line;
        if (endLine - startLine > 0) {
            BraceHighlightingHandler.lineMarkFragment((EditorEx)this.myEditor, this.myDocument, startLine, endLine, true);
        }
        BraceHighlightingHandler.showScopeHint(this.myEditor, BraceHighlighter.getAlarm(), leftBraceRange.getStartOffset(), leftBraceRange.getEndOffset(), null);
    }

    private List<HighlightInfo> getHighlights() {
        if (this.myReadAccessRanges.isEmpty() && this.myWriteAccessRanges.isEmpty() && this.myCodeBlockMarkerRanges.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Pair<Object, TextRange>> existingMarkupTooltips = new HashSet<Pair<Object, TextRange>>();
        for (RangeHighlighter highlighter : this.myEditor.getMarkupModel().getAllHighlighters()) {
            existingMarkupTooltips.add(Pair.create((Object)highlighter.getErrorStripeTooltip(), (Object)new TextRange(highlighter.getStartOffset(), highlighter.getEndOffset())));
        }
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>(this.myReadAccessRanges.size() + this.myWriteAccessRanges.size() + this.myCodeBlockMarkerRanges.size());
        for (TextRange range2 : this.myReadAccessRanges) {
            ContainerUtil.addIfNotNull(result2, (Object)this.createHighlightInfo(range2, HighlightInfoType.ELEMENT_UNDER_CARET_READ, existingMarkupTooltips));
        }
        for (TextRange range3 : this.myWriteAccessRanges) {
            ContainerUtil.addIfNotNull(result2, (Object)this.createHighlightInfo(range3, HighlightInfoType.ELEMENT_UNDER_CARET_WRITE, existingMarkupTooltips));
        }
        if (CodeInsightSettings.getInstance().HIGHLIGHT_BRACES) {
            this.myCodeBlockMarkerRanges.forEach(it -> ContainerUtil.addIfNotNull((Collection)result2, (Object)this.createHighlightInfo((TextRange)it, HighlightInfoType.ELEMENT_UNDER_CARET_STRUCTURAL, (Set<Pair<Object, TextRange>>)existingMarkupTooltips)));
        }
        return result2;
    }

    private HighlightInfo createHighlightInfo(TextRange range2, HighlightInfoType type, Set<Pair<Object, TextRange>> existingMarkupTooltips) {
        int start2 = range2.getStartOffset();
        String tooltip = start2 <= this.myDocument.getTextLength() ? HighlightHandlerBase.getLineTextErrorStripeTooltip(this.myDocument, start2, false) : null;
        String unescapedTooltip = existingMarkupTooltips.contains(new Pair((Object)tooltip, (Object)range2)) ? null : tooltip;
        HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(type).range(range2);
        if (unescapedTooltip != null) {
            builder2.unescapedToolTip(unescapedTooltip);
        }
        return builder2.createUnconditionally();
    }

    public static void clearMyHighlights(Document document, Project project) {
        MarkupModel markupModel = DocumentMarkupModel.forDocument(document, project, true);
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            HighlightInfo info = HighlightInfo.fromRangeHighlighter(highlighter);
            if (info == null || info.type != HighlightInfoType.ELEMENT_UNDER_CARET_READ && info.type != HighlightInfoType.ELEMENT_UNDER_CARET_WRITE) continue;
            highlighter.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass";
                break;
            }
            case 6: 
            case 8: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSymbols";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightUsages";
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: {
                break;
            }
            case 9: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "highlightTargetUsages";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

