/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.AbstractDocRenderMemoryManager;
import com.intellij.codeInsight.documentation.render.CachingDataReader;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jetbrains.annotations.NotNull;
import sun.awt.image.FileImageSource;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ToolkitImage;

class DocRenderImageManager
extends AbstractDocRenderMemoryManager<Image> {
    private final Dictionary<URL, Image> myImageProvider = new Dictionary<URL, Image>(){

        @Override
        public Image get(Object key) {
            if (!(key instanceof URL)) {
                return null;
            }
            return new ManagedImage((URL)key);
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<URL> keys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<Image> elements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Image put(URL key, Image value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Image remove(Object key) {
            throw new UnsupportedOperationException();
        }
    };

    DocRenderImageManager() {
        super("doc.render.image.cache.size");
    }

    @Override
    void destroy(@NotNull Image image) {
        if (image == null) {
            DocRenderImageManager.$$$reportNull$$$0(0);
        }
        image.flush();
    }

    void setCompletionListener(@NotNull Image image, @NotNull Runnable runnable2) {
        if (image == null) {
            DocRenderImageManager.$$$reportNull$$$0(1);
        }
        if (runnable2 == null) {
            DocRenderImageManager.$$$reportNull$$$0(2);
        }
        if (image instanceof ManagedImage) {
            ((ManagedImage)image).completionRunnable = runnable2;
        }
    }

    void dispose(@NotNull Image image) {
        if (image == null) {
            DocRenderImageManager.$$$reportNull$$$0(3);
        }
        if (image instanceof ManagedImage) {
            ((ManagedImage)image).dispose();
        }
        image.flush();
    }

    Dictionary<URL, Image> getImageProvider() {
        return this.myImageProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderImageManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "destroy";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setCompletionListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "dispose";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CachingImageSource
    extends FileImageSource {
        private final URL myURL;
        private ImageConsumer myPermanentConsumer;

        private CachingImageSource(URL url) {
            super(null);
            this.myURL = url;
        }

        private synchronized void setPermanentConsumer(ImageConsumer consumer) {
            if (this.myPermanentConsumer != null) {
                this.removeConsumer(this.myPermanentConsumer);
            }
            this.myPermanentConsumer = consumer;
        }

        private synchronized void addPermanentConsumer() {
            ImageConsumer consumer = this.myPermanentConsumer;
            if (consumer != null) {
                this.addConsumer(consumer);
            }
        }

        @Override
        protected ImageDecoder getDecoder() {
            InputStream stream = CachingDataReader.getInstance().getInputStream(this.myURL);
            return stream == null ? null : this.getDecoder(stream);
        }

        @Override
        public void doFetch() {
            this.addPermanentConsumer();
            super.doFetch();
        }
    }

    private class ManagedImage
    extends ToolkitImage
    implements ImageConsumer {
        private int myWidth;
        private int myHeight;
        private volatile Runnable completionRunnable;

        private ManagedImage(URL url) {
            super(new CachingImageSource(url));
            ((CachingImageSource)this.getSource()).setPermanentConsumer(this);
        }

        private void dispose() {
            ((CachingImageSource)this.getSource()).setPermanentConsumer(null);
        }

        @Override
        public void setDimensions(int width, int height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        @Override
        public void imageComplete(int status) {
            if (this.myWidth > 0 && this.myHeight > 0) {
                DocRenderImageManager.this.register(this, this.myWidth * this.myHeight >>> 8);
                this.myWidth = 0;
                this.myHeight = 0;
                Runnable runnable2 = this.completionRunnable;
                if (runnable2 != null) {
                    runnable2.run();
                }
            }
        }

        @Override
        public void flush() {
            super.flush();
            DocRenderImageManager.this.unregister(this);
        }

        @Override
        public void setProperties(Hashtable<?, ?> props) {
        }

        @Override
        public void setColorModel(ColorModel model) {
        }

        @Override
        public void setHints(int hintflags) {
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        }
    }
}

