/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.classstore;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.parser.Type;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001d0\u001fJ\u0011\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020#H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0013H\u0086\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u000eJ\u0010\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0013J\u000e\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0004J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0004J\u0006\u0010*\u001a\u00020\"R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00040\nj\b\u0012\u0004\u0012\u00020\u0004`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\rj\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\b\u00a8\u0006+"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "", "classes", "Lgnu/trove/TLongObjectHashMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "(Lgnu/trove/TLongObjectHashMap;)V", "classClass", "getClassClass", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "classDefinitionToShortPrettyName", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "primitiveArrayToClassDefinition", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/parser/Type;", "Lkotlin/collections/HashMap;", "softReferenceClass", "getSoftReferenceClass", "stringToClassDefinition", "", "weakReferenceClass", "getWeakReferenceClass", "containsClass", "", "name", "createStoreWithRemappedIDs", "remappingFunction", "Ljava/util/function/LongUnaryOperator;", "forEachClass", "", "func", "Lkotlin/Function1;", "get", "id", "", "", "getClassForPrimitiveArray", "t", "getClassIfExists", "getShortPrettyNameForClass", "classDefinition", "isSoftOrWeakReferenceClass", "size", "intellij.platform.ide.impl"})
public final class ClassStore {
    private final HashMap<String, ClassDefinition> stringToClassDefinition;
    private final HashSet<ClassDefinition> classDefinitionToShortPrettyName;
    @NotNull
    private final ClassDefinition softReferenceClass;
    @NotNull
    private final ClassDefinition weakReferenceClass;
    @NotNull
    private final ClassDefinition classClass;
    private final HashMap<Type, ClassDefinition> primitiveArrayToClassDefinition;
    private final TLongObjectHashMap<ClassDefinition> classes;

    @NotNull
    public final ClassDefinition getSoftReferenceClass() {
        return this.softReferenceClass;
    }

    @NotNull
    public final ClassDefinition getWeakReferenceClass() {
        return this.weakReferenceClass;
    }

    @NotNull
    public final ClassDefinition getClassClass() {
        return this.classClass;
    }

    @NotNull
    public final ClassDefinition get(int id2) {
        Object object = this.classes.get((long)id2);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (ClassDefinition)object;
    }

    @NotNull
    public final ClassDefinition get(long id2) {
        Object object = this.classes.get(id2);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (ClassDefinition)object;
    }

    @NotNull
    public final ClassDefinition get(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ClassDefinition classDefinition = this.stringToClassDefinition.get(name);
        if (classDefinition == null) {
            Intrinsics.throwNpe();
        }
        return classDefinition;
    }

    @Nullable
    public final ClassDefinition getClassIfExists(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.stringToClassDefinition.get(name);
    }

    public final boolean containsClass(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.stringToClassDefinition.containsKey(name);
    }

    @Nullable
    public final ClassDefinition getClassForPrimitiveArray(@NotNull Type t) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)t), (String)"t");
        return this.primitiveArrayToClassDefinition.get((Object)t);
    }

    public final int size() {
        return this.classes.size();
    }

    public final boolean isSoftOrWeakReferenceClass(@NotNull ClassDefinition classDefinition) {
        Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
        return Intrinsics.areEqual((Object)classDefinition, (Object)this.softReferenceClass) || Intrinsics.areEqual((Object)classDefinition, (Object)this.weakReferenceClass);
    }

    public final void forEachClass(@NotNull Function1<? super ClassDefinition, Unit> func) {
        Intrinsics.checkParameterIsNotNull(func, (String)"func");
        this.classes.forEachValue((TObjectProcedure)new TObjectProcedure<ClassDefinition>(func){
            final /* synthetic */ Function1 $func;

            public final boolean execute(ClassDefinition it) {
                ClassDefinition classDefinition = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)classDefinition, (String)"it");
                this.$func.invoke((Object)classDefinition);
                return true;
            }
            {
                this.$func = function1;
            }
        });
    }

    @NotNull
    public final ClassStore createStoreWithRemappedIDs(@NotNull LongUnaryOperator remappingFunction) {
        Intrinsics.checkParameterIsNotNull((Object)remappingFunction, (String)"remappingFunction");
        Function1<Long, Long> $fun$map$1 = new Function1<Long, Long>(remappingFunction){
            final /* synthetic */ LongUnaryOperator $remappingFunction;

            public final long invoke(long id2) {
                return this.$remappingFunction.applyAsLong(id2);
            }
            {
                this.$remappingFunction = longUnaryOperator;
                super(1);
            }
        };
        TLongObjectHashMap newClasses = new TLongObjectHashMap();
        this.classes.forEachValue((TObjectProcedure)new TObjectProcedure<ClassDefinition>(newClasses, $fun$map$1, remappingFunction){
            final /* synthetic */ TLongObjectHashMap $newClasses;
            final /* synthetic */ createStoreWithRemappedIDs.1 $map$1;
            final /* synthetic */ LongUnaryOperator $remappingFunction;

            public final boolean execute(ClassDefinition it) {
                this.$newClasses.put(this.$map$1.invoke(it.getId()), (Object)it.copyWithRemappedIDs(this.$remappingFunction));
                return true;
            }
            {
                this.$newClasses = tLongObjectHashMap;
                this.$map$1 = var2_2;
                this.$remappingFunction = longUnaryOperator;
            }
        });
        return new ClassStore((TLongObjectHashMap<ClassDefinition>)newClasses);
    }

    @NotNull
    public final String getShortPrettyNameForClass(@NotNull ClassDefinition classDefinition) {
        ClassDefinition outerClass;
        Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
        if (StringsKt.contains$default((CharSequence)classDefinition.getName(), (char)'$', (boolean)false, (int)2, null) ? (outerClass = this.stringToClassDefinition.get(StringsKt.substringBefore$default((String)classDefinition.getName(), (char)'$', null, (int)2, null))) != null && this.classDefinitionToShortPrettyName.contains(outerClass) : this.classDefinitionToShortPrettyName.contains(classDefinition)) {
            return StringsKt.substringAfterLast$default((String)classDefinition.getPrettyName(), (char)'.', null, (int)2, null);
        }
        return classDefinition.getPrettyName();
    }

    public ClassStore(@NotNull TLongObjectHashMap<ClassDefinition> classes) {
        boolean bl;
        int n;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
        this.classes = classes;
        this.stringToClassDefinition = new HashMap();
        this.classDefinitionToShortPrettyName = new HashSet();
        this.primitiveArrayToClassDefinition = new HashMap();
        1 $fun$getClashedNameWithIndex$1 = 1.INSTANCE;
        boolean bl3 = false;
        final Set clashedClassNames = new LinkedHashSet();
        this.classes.forEachValue((TObjectProcedure)new TObjectProcedure<ClassDefinition>(){

            public final boolean execute(ClassDefinition classDefinition) {
                String className = classDefinition.getName();
                boolean clashed = false;
                if (clashedClassNames.contains(className)) {
                    clashed = true;
                } else {
                    ClassDefinition clashedClass = (ClassDefinition)stringToClassDefinition.remove(className);
                    if (clashedClass != null) {
                        clashed = true;
                        ClassDefinition newDefinition = clashedClass.copyWithName(1.INSTANCE.invoke(clashedClass, 1));
                        ((Map)stringToClassDefinition).put(newDefinition.getName(), newDefinition);
                        classes.put(clashedClass.getId(), (Object)newDefinition);
                        clashedClassNames.add(className);
                    }
                }
                if (clashed) {
                    int i2 = 2;
                    String newName = null;
                    do {
                        ClassDefinition classDefinition2 = classDefinition;
                        Intrinsics.checkExpressionValueIsNotNull((Object)classDefinition2, (String)"classDefinition");
                        newName = 1.INSTANCE.invoke(classDefinition2, i2);
                        ++i2;
                    } while (stringToClassDefinition.containsKey(newName));
                    ClassDefinition newClassDefinition = classDefinition.copyWithName(newName);
                    ((Map)stringToClassDefinition).put(newName, newClassDefinition);
                    classes.put(classDefinition.getId(), (Object)newClassDefinition);
                } else {
                    Map map2 = stringToClassDefinition;
                    String string = classDefinition.getName();
                    ClassDefinition classDefinition3 = classDefinition;
                    Intrinsics.checkExpressionValueIsNotNull((Object)classDefinition3, (String)"classDefinition");
                    map2.put(string, classDefinition3);
                }
                return true;
            }
        });
        Type[] $this$forEach$iv = (Type[])clashedClassNames;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            String it = (String)t;
            boolean bl4 = false;
            Map map2 = this.stringToClassDefinition;
            boolean bl5 = false;
            Map map3 = map2;
            bl2 = false;
            boolean bl6 = !map3.containsKey(it);
            bl5 = false;
            boolean bl7 = false;
            if (!_Assertions.ENABLED || bl6) continue;
            bl2 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ClassDefinition classDefinition = this.stringToClassDefinition.get("java.lang.ref.SoftReference");
        if (classDefinition == null) {
            Intrinsics.throwNpe();
        }
        this.softReferenceClass = classDefinition;
        ClassDefinition classDefinition2 = this.stringToClassDefinition.get("java.lang.ref.WeakReference");
        if (classDefinition2 == null) {
            Intrinsics.throwNpe();
        }
        this.weakReferenceClass = classDefinition2;
        ClassDefinition classDefinition3 = this.stringToClassDefinition.get("java.lang.Class");
        if (classDefinition3 == null) {
            Intrinsics.throwNpe();
        }
        this.classClass = classDefinition3;
        $this$forEach$iv = Type.values();
        $i$f$forEach = false;
        Type[] typeArray = $this$forEach$iv;
        int n2 = typeArray.length;
        for (n = 0; n < n2; ++n) {
            ClassDefinition classDefinition4;
            Type element$iv;
            Type type = element$iv = typeArray[n];
            boolean bl8 = false;
            if (type == Type.OBJECT || this.stringToClassDefinition.get(type.getClassNameOfPrimitiveArray()) == null) continue;
            bl2 = false;
            bl = false;
            ClassDefinition classDefinition5 = classDefinition4;
            boolean bl9 = false;
            this.primitiveArrayToClassDefinition.put(type, classDefinition5);
        }
        final HashMap shortNameToClassDefinition = new HashMap();
        this.classes.forEachValue((TObjectProcedure)new TObjectProcedure<ClassDefinition>(){

            public final boolean execute(ClassDefinition it) {
                if (StringsKt.contains$default((CharSequence)it.getName(), (char)'$', (boolean)false, (int)2, null)) {
                    return true;
                }
                String prettyName = it.getPrettyName();
                String shortPrettyName = StringsKt.substringAfterLast$default((String)prettyName, (char)'.', null, (int)2, null);
                if (shortNameToClassDefinition.containsKey(shortPrettyName)) {
                    ClassDefinition prevClassDefinition = (ClassDefinition)shortNameToClassDefinition.get(shortPrettyName);
                    if (prevClassDefinition != null) {
                        ((Map)shortNameToClassDefinition).put(shortPrettyName, null);
                    }
                } else {
                    ((Map)shortNameToClassDefinition).put(shortPrettyName, it);
                }
                return true;
            }
        });
        Map $this$forEach$iv2 = shortNameToClassDefinition;
        boolean $i$f$forEach2 = false;
        Map map4 = $this$forEach$iv2;
        n = 0;
        Iterator iterator2 = map4.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$_u24__u24$classDef = element$iv = iterator2.next();
            boolean bl10 = false;
            Map.Entry entry = $dstr$_u24__u24$classDef;
            bl = false;
            ClassDefinition classDef = (ClassDefinition)entry.getValue();
            if (classDef == null) continue;
            this.classDefinitionToShortPrettyName.add(classDef);
        }
    }
}

