/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentWizard;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SeparatorWithText;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunOnTargetComboBox
extends ComboBox<Item> {
    public static final Logger LOGGER = Logger.getInstance(RunOnTargetComboBox.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private LanguageRuntimeType<?> myDefaultRuntimeType;
    private boolean hasSavedTargets;

    public RunOnTargetComboBox(@NotNull Project project) {
        if (project == null) {
            RunOnTargetComboBox.$$$reportNull$$$0(0);
        }
        this.hasSavedTargets = false;
        this.setModel(new MyModel());
        this.myProject = project;
        this.setRenderer((ListCellRenderer)((Object)new MyRenderer()));
    }

    public void initModel() {
        this.hasSavedTargets = false;
        MyModel model = (MyModel)this.getModel();
        model.removeAllElements();
        model.addElement(null);
        ArrayList types = new ArrayList();
        for (TargetEnvironmentType targetEnvironmentType : TargetEnvironmentType.EXTENSION_NAME.getExtensionList()) {
            if (!targetEnvironmentType.providesNewWizard(this.myProject, this.myDefaultRuntimeType)) continue;
            types.add(new Type(targetEnvironmentType));
        }
        if (!types.isEmpty()) {
            model.addElement(new Separator("New Targets"));
            for (Type type : types) {
                model.addElement(type);
            }
        }
    }

    public void setDefaultLanguageRuntimeTime(@Nullable LanguageRuntimeType<?> defaultLanguageRuntimeType) {
        this.myDefaultRuntimeType = defaultLanguageRuntimeType;
    }

    public void addTarget(@NotNull TargetEnvironmentConfiguration config2, int index) {
        if (config2 == null) {
            RunOnTargetComboBox.$$$reportNull$$$0(1);
        }
        if (!this.hasSavedTargets) {
            this.hasSavedTargets = true;
            ((MyModel)this.getModel()).insertElementAt(new Separator("Saved Targets"), 1);
        }
        Icon icon2 = TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)config2).getIcon();
        ((MyModel)this.getModel()).insertElementAt(new Target(config2.getDisplayName(), icon2), index);
    }

    @Nullable
    public String getSelectedTargetName() {
        return (String)ObjectUtils.doIfCast((Object)this.getSelectedItem(), Item.class, i2 -> i2.getDisplayName());
    }

    public void addTargets(List<TargetEnvironmentConfiguration> configs) {
        int index = 2;
        for (TargetEnvironmentConfiguration config2 : configs) {
            this.addTarget(config2, index);
            ++index;
        }
    }

    public void selectTarget(String configName) {
        if (configName == null) {
            this.setSelectedItem(null);
            return;
        }
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Item at = (Item)this.getModel().getElementAt(i2);
            if (!(at instanceof Target) || !configName.equals(at.getDisplayName())) continue;
            this.setSelectedItem(at);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/RunOnTargetComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyRenderer
    extends ColoredListCellRenderer<Item> {
        private MyRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends Item> list2, Item value2, int index, boolean selected2, boolean hasFocus) {
            if (value2 instanceof Separator) {
                SeparatorWithText separator = new SeparatorWithText();
                separator.setCaption(value2.getDisplayName());
                return separator;
            }
            return super.getListCellRendererComponent(list2, (Object)value2, index, selected2, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends Item> list2, Item value2, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                this.append("Local machine");
                this.setIcon(AllIcons.Nodes.HomeFolder);
            } else {
                this.append(value2.getDisplayName());
                this.setIcon(value2.getIcon());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/RunOnTargetComboBox$MyRenderer", "customizeCellRenderer"));
        }
    }

    private class MyModel
    extends DefaultComboBoxModel<Item> {
        private MyModel() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof Separator) {
                return;
            }
            if (anObject instanceof Type) {
                Pair wizardData = ((Type)anObject).createStepsForNewWizard(RunOnTargetComboBox.this.myProject, RunOnTargetComboBox.this.myDefaultRuntimeType);
                if (wizardData != null) {
                    TargetEnvironmentConfiguration newTarget = (TargetEnvironmentConfiguration)wizardData.first;
                    TargetEnvironmentWizard wizard = new TargetEnvironmentWizard(RunOnTargetComboBox.this.myProject, "New Target", newTarget, (List)wizardData.second);
                    if (wizard.showAndGet()) {
                        TargetEnvironmentsManager.getInstance().addTarget(newTarget);
                        RunOnTargetComboBox.this.addTarget(newTarget, 2);
                        RunOnTargetComboBox.this.setSelectedIndex(2);
                    }
                }
                return;
            }
            super.setSelectedItem(anObject);
        }
    }

    private static class Type<T extends TargetEnvironmentConfiguration>
    extends Item {
        @NotNull
        private final TargetEnvironmentType<T> type;

        private Type(@NotNull TargetEnvironmentType<T> type) {
            if (type == null) {
                Type.$$$reportNull$$$0(0);
            }
            super(type.getDisplayName(), type.getIcon());
            this.type = type;
        }

        @Nullable
        private Pair<T, List<AbstractWizardStepEx>> createStepsForNewWizard(Project project, LanguageRuntimeType<?> defaultRuntimeType) {
            TargetEnvironmentConfiguration config2 = (TargetEnvironmentConfiguration)this.type.createDefaultConfig();
            List steps = this.type.createStepsForNewWizard(project, config2, defaultRuntimeType);
            if (steps == null) {
                LOGGER.error("Cannot instantiate remote target wizard");
                return null;
            }
            return Pair.create((Object)config2, (Object)steps);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/RunOnTargetComboBox$Type", "<init>"));
        }
    }

    private static class Target
    extends Item {
        private Target(String name, Icon icon2) {
            super(name, icon2);
        }
    }

    private static class Separator
    extends Item {
        private Separator(String displayName) {
            super(displayName, null);
        }
    }

    public static abstract class Item {
        private final String displayName;
        private final Icon icon;

        public Item(String displayName, Icon icon2) {
            this.displayName = displayName;
            this.icon = icon2;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

