/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ColoredOutputTypeRegistry;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.GeneralToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.OutputEventSplitter;
import com.intellij.execution.testframework.sm.runner.ProcessOutputConsumer;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.events.BaseStartedNodeEvent;
import com.intellij.execution.testframework.sm.runner.events.TestDurationStrategy;
import com.intellij.execution.testframework.sm.runner.events.TestDurationStrategyKt;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.BaseTestMessage;
import jetbrains.buildServer.messages.serviceMessages.BuildNumber;
import jetbrains.buildServer.messages.serviceMessages.BuildStatisticValue;
import jetbrains.buildServer.messages.serviceMessages.BuildStatus;
import jetbrains.buildServer.messages.serviceMessages.DefaultServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.Message;
import jetbrains.buildServer.messages.serviceMessages.ProgressFinish;
import jetbrains.buildServer.messages.serviceMessages.ProgressMessage;
import jetbrains.buildServer.messages.serviceMessages.ProgressStart;
import jetbrains.buildServer.messages.serviceMessages.PublishArtifacts;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessagesParser;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import jetbrains.buildServer.messages.serviceMessages.TestStdOut;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputToGeneralTestEventsConverter
implements ProcessOutputConsumer {
    private static final Logger LOG = Logger.getInstance((String)OutputToGeneralTestEventsConverter.class.getName());
    private final MyServiceMessageVisitor myServiceMessageVisitor;
    private final String myTestFrameworkName;
    private final boolean myValidateServiceMessagesAttributes;
    private final OutputEventSplitter mySplitter;
    private volatile GeneralTestEventsProcessor myProcessor;
    private Runnable myTestingStartedHandler;
    private boolean myFirstTestingStartedEvent;

    public OutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        if (testFrameworkName == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(1);
        }
        this(testFrameworkName, consoleProperties.isEditable(), consoleProperties instanceof SMTRunnerConsoleProperties && ((SMTRunnerConsoleProperties)consoleProperties).serviceMessageHasNewLinePrefix(), !(consoleProperties instanceof SMTRunnerConsoleProperties) || !((SMTRunnerConsoleProperties)consoleProperties).isIdBasedTestTree());
    }

    public OutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, boolean doNotBufferTextUntilNewLine, boolean cutNewLineBeforeServiceMessage, boolean validateServiceMessagesAttributes) {
        if (testFrameworkName == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(2);
        }
        this.myFirstTestingStartedEvent = true;
        this.myTestFrameworkName = testFrameworkName;
        this.myValidateServiceMessagesAttributes = validateServiceMessagesAttributes;
        this.myServiceMessageVisitor = new MyServiceMessageVisitor();
        this.mySplitter = new OutputEventSplitter(!doNotBufferTextUntilNewLine, cutNewLineBeforeServiceMessage){

            @Override
            public void onTextAvailable(@NotNull String text, @NotNull Key<?> outputType) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                OutputToGeneralTestEventsConverter.this.processConsistentText(text, outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public void setProcessor(@Nullable GeneralTestEventsProcessor processor2) {
        this.myProcessor = processor2;
    }

    protected GeneralTestEventsProcessor getProcessor() {
        return this.myProcessor;
    }

    @Override
    public void flushBufferOnProcessTermination(int exitCode) {
        this.mySplitter.flush();
    }

    public void dispose() {
        this.setProcessor(null);
    }

    @Override
    public void process(String text, Key outputType) {
        this.mySplitter.process(text, outputType);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    protected void processConsistentText(@NotNull String text, Key<?> outputType, boolean tcLikeFakeOutput) {
        if (text == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(3);
        }
        this.processConsistentText(text, outputType);
    }

    protected void processConsistentText(@NotNull String text, @NotNull Key<?> outputType) {
        if (text == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(4);
        }
        if (outputType == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(5);
        }
        try {
            if (!this.processServiceMessages(text, outputType, (ServiceMessageVisitor)this.myServiceMessageVisitor)) {
                this.fireOnUncapturedOutput(text, outputType);
            }
        }
        catch (ParseException e) {
            LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(this.myTestFrameworkName) + "Error parsing text: [" + text + "]", (Throwable)e);
        }
    }

    protected boolean processServiceMessages(String text, Key outputType, final ServiceMessageVisitor visitor) throws ParseException {
        String trimmedText = text.trim();
        if (!trimmedText.startsWith("##teamcity[") || !trimmedText.endsWith("]")) {
            return false;
        }
        final Ref success = Ref.create((Object)false);
        ServiceMessagesParser parser = new ServiceMessagesParser();
        parser.setValidateRequiredAttributes(this.myValidateServiceMessagesAttributes);
        parser.parse(trimmedText, new ServiceMessageParserCallback(){

            public void regularText(@NotNull String text1) {
                if (text1 == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            public void serviceMessage(@NotNull ServiceMessage message) {
                if (message == null) {
                    2.$$$reportNull$$$0(1);
                }
                message.visit(visitor);
                success.set((Object)true);
            }

            public void parseException(@NotNull ParseException parseException, @NotNull String text1) {
                if (parseException == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (text1 == null) {
                    2.$$$reportNull$$$0(3);
                }
                LOG.error("Failed to parse service message", (Throwable)parseException, new String[]{text1});
                success.set((Object)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parseException";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "regularText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "serviceMessage";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "parseException";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (Boolean)success.get();
    }

    private void fireOnTestStarted(@NotNull TestStartedEvent testStartedEvent) {
        GeneralTestEventsProcessor processor2;
        if (testStartedEvent == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(6);
        }
        if ((processor2 = this.myProcessor) != null) {
            processor2.onTestStarted(testStartedEvent);
        }
    }

    private void fireOnTestFailure(@NotNull TestFailedEvent testFailedEvent) {
        if (testFailedEvent == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(7);
        }
        this.assertNotNull(testFailedEvent.getLocalizedFailureMessage());
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onTestFailure(testFailedEvent);
        }
    }

    private void fireOnTestIgnored(@NotNull TestIgnoredEvent testIgnoredEvent) {
        GeneralTestEventsProcessor processor2;
        if (testIgnoredEvent == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(8);
        }
        if ((processor2 = this.myProcessor) != null) {
            processor2.onTestIgnored(testIgnoredEvent);
        }
    }

    private void fireOnTestFinished(@NotNull TestFinishedEvent testFinishedEvent) {
        GeneralTestEventsProcessor processor2;
        if (testFinishedEvent == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(9);
        }
        if ((processor2 = this.myProcessor) != null) {
            processor2.onTestFinished(testFinishedEvent);
        }
    }

    private void fireOnCustomProgressTestsCategory(String categoryName, int testsCount) {
        this.assertNotNull(categoryName);
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            boolean disableCustomMode = StringUtil.isEmpty((String)categoryName);
            processor2.onCustomProgressTestsCategory(disableCustomMode ? null : categoryName, disableCustomMode ? 0 : testsCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFinished() {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onCustomProgressTestFinished();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onCustomProgressTestFailed();
        }
    }

    private void fireOnTestFrameworkAttached(@NotNull TestDurationStrategy strategy) {
        GeneralTestEventsProcessor processor2;
        if (strategy == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(10);
        }
        if ((processor2 = this.myProcessor) != null) {
            processor2.onTestsReporterAttached();
            processor2.onDurationStrategyChanged(strategy);
        }
    }

    private void fireOnSuiteTreeNodeAdded(String testName, String locationHint, String metaInfo, String id2, String parentNodeId) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onSuiteTreeNodeAdded(testName, locationHint, metaInfo, id2, parentNodeId);
        }
    }

    private void fireRootPresentationAdded(String rootName, @Nullable String comment, String rootLocation) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onRootPresentationAdded(rootName, comment, rootLocation);
        }
    }

    private void fireOnSuiteTreeStarted(String suiteName, String locationHint, String metainfo, String id2, String parentNodeId) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onSuiteTreeStarted(suiteName, locationHint, metainfo, id2, parentNodeId);
        }
    }

    private void fireOnSuiteTreeEnded(String suiteName) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onSuiteTreeEnded(suiteName);
        }
    }

    private void fireOnBuildTreeEnded() {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onBuildTreeEnded();
        }
    }

    private void fireOnTestOutput(@NotNull TestOutputEvent testOutputEvent) {
        GeneralTestEventsProcessor processor2;
        if (testOutputEvent == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(11);
        }
        if ((processor2 = this.myProcessor) != null) {
            processor2.onTestOutput(testOutputEvent);
        }
    }

    private void fireOnUncapturedOutput(String text, Key outputType) {
        this.assertNotNull(text);
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onUncapturedOutput(text, outputType);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onTestsCountInSuite(count);
        }
    }

    private void fireOnSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        GeneralTestEventsProcessor processor2;
        if (suiteStartedEvent == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(12);
        }
        if ((processor2 = this.myProcessor) != null) {
            processor2.onSuiteStarted(suiteStartedEvent);
        }
    }

    private void fireOnSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        GeneralTestEventsProcessor processor2;
        if (suiteFinishedEvent == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(13);
        }
        if ((processor2 = this.myProcessor) != null) {
            processor2.onSuiteFinished(suiteFinishedEvent);
        }
    }

    protected void fireOnErrorMsg(String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        this.assertNotNull(localizedMessage);
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onError(localizedMessage, stackTrace, isCritical);
        }
    }

    private void assertNotNull(String s) {
        if (s == null) {
            LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(this.myTestFrameworkName) + " @NotNull value is expected.");
        }
    }

    public synchronized void setTestingStartedHandler(@NotNull Runnable testingStartedHandler) {
        if (testingStartedHandler == null) {
            OutputToGeneralTestEventsConverter.$$$reportNull$$$0(14);
        }
        this.myTestingStartedHandler = testingStartedHandler;
    }

    public void onStartTesting() {
    }

    public synchronized void startTesting() {
        this.myTestingStartedHandler.run();
        this.onStartTesting();
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            processor2.onStartTesting();
        }
    }

    public synchronized void finishTesting() {
        GeneralTestEventsProcessor processor2 = this.myProcessor;
        if (processor2 != null) {
            this.setProcessor(null);
            processor2.onFinishTesting();
            Disposer.dispose((Disposable)processor2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testStartedEvent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFailedEvent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testIgnoredEvent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFinishedEvent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testOutputEvent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteStartedEvent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteFinishedEvent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testingStartedHandler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processConsistentText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnTestStarted";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnTestFailure";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnTestIgnored";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnTestFinished";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnTestFrameworkAttached";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnTestOutput";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnSuiteStarted";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "fireOnSuiteFinished";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "setTestingStartedHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyServiceMessageVisitor
    extends DefaultServiceMessageVisitor {
        @NonNls
        private static final String TESTING_STARTED = "testingStarted";
        @NonNls
        private static final String TESTING_FINISHED = "testingFinished";
        @NonNls
        private static final String KEY_TESTS_COUNT = "testCount";
        @NonNls
        private static final String ATTR_KEY_TEST_ERROR = "error";
        @NonNls
        private static final String ATTR_KEY_TEST_COUNT = "count";
        @NonNls
        private static final String ATTR_KEY_TEST_DURATION = "duration";
        @NonNls
        private static final String ATTR_KEY_TEST_OUTPUT_FILE = "outputFile";
        @NonNls
        private static final String ATTR_KEY_LOCATION_URL = "locationHint";
        @NonNls
        private static final String ATTR_KEY_LOCATION_URL_OLD = "location";
        @NonNls
        private static final String ATTR_KEY_STACKTRACE_DETAILS = "details";
        @NonNls
        private static final String ATTR_KEY_DIAGNOSTIC = "diagnosticInfo";
        @NonNls
        private static final String ATTR_KEY_CONFIG = "config";
        @NonNls
        private static final String MESSAGE = "message";
        @NonNls
        private static final String TEST_REPORTER_ATTACHED = "enteredTheMatrix";
        @NonNls
        private static final String SUITE_TREE_STARTED = "suiteTreeStarted";
        @NonNls
        private static final String SUITE_TREE_ENDED = "suiteTreeEnded";
        @NonNls
        private static final String SUITE_TREE_NODE = "suiteTreeNode";
        @NonNls
        private static final String BUILD_TREE_ENDED_NODE = "treeEnded";
        @NonNls
        private static final String ROOT_PRESENTATION = "rootName";
        @NonNls
        private static final String ATTR_KEY_STATUS = "status";
        @NonNls
        private static final String ATTR_VALUE_STATUS_ERROR = "ERROR";
        @NonNls
        private static final String ATTR_VALUE_STATUS_WARNING = "WARNING";
        @NonNls
        private static final String ATTR_KEY_TEXT = "text";
        @NonNls
        private static final String ATTR_KEY_TEXT_ATTRIBUTES = "textAttributes";
        @NonNls
        private static final String ATTR_KEY_ERROR_DETAILS = "errorDetails";
        @NonNls
        private static final String ATTR_KEY_EXPECTED_FILE_PATH = "expectedFile";
        @NonNls
        private static final String ATTR_KEY_ACTUAL_FILE_PATH = "actualFile";
        @NonNls
        public static final String CUSTOM_STATUS = "customProgressStatus";
        @NonNls
        private static final String ATTR_KEY_TEST_TYPE = "type";
        @NonNls
        private static final String ATTR_KEY_TESTS_CATEGORY = "testsCategory";
        @NonNls
        private static final String ATTR_VAL_TEST_STARTED = "testStarted";
        @NonNls
        private static final String ATTR_VAL_TEST_FINISHED = "testFinished";
        @NonNls
        private static final String ATTR_VAL_TEST_FAILED = "testFailed";

        private MyServiceMessageVisitor() {
        }

        public void visitTestSuiteStarted(@NotNull TestSuiteStarted suiteStarted) {
            if (suiteStarted == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(0);
            }
            String locationUrl = this.fetchTestLocation(suiteStarted);
            TestSuiteStartedEvent suiteStartedEvent = new TestSuiteStartedEvent(suiteStarted, locationUrl);
            OutputToGeneralTestEventsConverter.this.fireOnSuiteStarted(suiteStartedEvent);
        }

        @Nullable
        private String fetchTestLocation(TestSuiteStarted suiteStarted) {
            Map attrs = suiteStarted.getAttributes();
            String location = (String)attrs.get(ATTR_KEY_LOCATION_URL);
            if (location == null) {
                String oldLocation = (String)attrs.get(ATTR_KEY_LOCATION_URL_OLD);
                if (oldLocation != null) {
                    LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(OutputToGeneralTestEventsConverter.this.myTestFrameworkName) + "Test Runner API was changed for TeamCity 5.0 compatibility. Please use 'locationHint' attribute instead of 'location'.");
                    return oldLocation;
                }
                return null;
            }
            return location;
        }

        public void visitTestSuiteFinished(@NotNull TestSuiteFinished suiteFinished) {
            if (suiteFinished == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(1);
            }
            TestSuiteFinishedEvent finishedEvent = new TestSuiteFinishedEvent(suiteFinished);
            OutputToGeneralTestEventsConverter.this.fireOnSuiteFinished(finishedEvent);
        }

        public void visitTestStarted(@NotNull TestStarted testStarted) {
            if (testStarted == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(2);
            }
            Map attributes = testStarted.getAttributes();
            String locationUrl = (String)attributes.get(ATTR_KEY_LOCATION_URL);
            TestStartedEvent testStartedEvent = new TestStartedEvent(testStarted, locationUrl);
            testStartedEvent.setConfig(attributes.get(ATTR_KEY_CONFIG) != null);
            OutputToGeneralTestEventsConverter.this.fireOnTestStarted(testStartedEvent);
        }

        public void visitTestFinished(@NotNull TestFinished testFinished) {
            if (testFinished == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(3);
            }
            String durationStr = (String)testFinished.getAttributes().get(ATTR_KEY_TEST_DURATION);
            Long duration = null;
            if (!StringUtil.isEmptyOrSpaces((String)durationStr)) {
                duration = this.convertToLong(durationStr, (ServiceMessage)testFinished);
            }
            TestFinishedEvent testFinishedEvent = new TestFinishedEvent(testFinished, duration, (String)testFinished.getAttributes().get(ATTR_KEY_TEST_OUTPUT_FILE));
            OutputToGeneralTestEventsConverter.this.fireOnTestFinished(testFinishedEvent);
        }

        public void visitTestIgnored(@NotNull TestIgnored testIgnored) {
            if (testIgnored == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(4);
            }
            String stacktrace = (String)testIgnored.getAttributes().get(ATTR_KEY_STACKTRACE_DETAILS);
            OutputToGeneralTestEventsConverter.this.fireOnTestIgnored(new TestIgnoredEvent(testIgnored, stacktrace));
        }

        public void visitTestStdOut(@NotNull TestStdOut testStdOut) {
            if (testStdOut == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(5);
            }
            Key outputType = this.getOutputType(testStdOut.getAttributes(), ProcessOutputTypes.STDOUT);
            OutputToGeneralTestEventsConverter.this.fireOnTestOutput(new TestOutputEvent((BaseTestMessage)testStdOut, testStdOut.getStdOut(), outputType));
        }

        public void visitTestStdErr(@NotNull TestStdErr testStdErr) {
            if (testStdErr == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(6);
            }
            Key outputType = this.getOutputType(testStdErr.getAttributes(), ProcessOutputTypes.STDERR);
            OutputToGeneralTestEventsConverter.this.fireOnTestOutput(new TestOutputEvent((BaseTestMessage)testStdErr, testStdErr.getStdErr(), outputType));
        }

        @NotNull
        public Key getOutputType(Map<String, String> attributes, Key baseOutputType) {
            String textAttributes = attributes.get(ATTR_KEY_TEXT_ATTRIBUTES);
            if (textAttributes == null) {
                Key key = baseOutputType;
                if (key == null) {
                    MyServiceMessageVisitor.$$$reportNull$$$0(7);
                }
                return key;
            }
            if (textAttributes.equals(ProcessOutputTypes.STDOUT.toString())) {
                Key key = ProcessOutputTypes.STDOUT;
                if (key == null) {
                    MyServiceMessageVisitor.$$$reportNull$$$0(8);
                }
                return key;
            }
            if (textAttributes.equals(ProcessOutputTypes.STDERR.toString())) {
                Key key = ProcessOutputTypes.STDERR;
                if (key == null) {
                    MyServiceMessageVisitor.$$$reportNull$$$0(9);
                }
                return key;
            }
            if (textAttributes.equals(ProcessOutputTypes.SYSTEM.toString())) {
                Key key = ProcessOutputTypes.SYSTEM;
                if (key == null) {
                    MyServiceMessageVisitor.$$$reportNull$$$0(10);
                }
                return key;
            }
            ProcessOutputType processOutputType = ColoredOutputTypeRegistry.getInstance().getOutputType(textAttributes, baseOutputType);
            if (processOutputType == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(11);
            }
            return processOutputType;
        }

        public void visitTestFailed(@NotNull TestFailed testFailed) {
            if (testFailed == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(12);
            }
            Map attributes = testFailed.getAttributes();
            LOG.assertTrue(testFailed.getFailureMessage() != null, (Object)("No failure message for: #" + OutputToGeneralTestEventsConverter.this.myTestFrameworkName));
            boolean testError = attributes.get(ATTR_KEY_TEST_ERROR) != null;
            TestFailedEvent testFailedEvent = new TestFailedEvent(testFailed, testError, (String)attributes.get(ATTR_KEY_EXPECTED_FILE_PATH), (String)attributes.get(ATTR_KEY_ACTUAL_FILE_PATH));
            OutputToGeneralTestEventsConverter.this.fireOnTestFailure(testFailedEvent);
        }

        public void visitPublishArtifacts(@NotNull PublishArtifacts publishArtifacts) {
            if (publishArtifacts == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(13);
            }
        }

        public void visitProgressMessage(@NotNull ProgressMessage progressMessage) {
            if (progressMessage == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(14);
            }
        }

        public void visitProgressStart(@NotNull ProgressStart progressStart) {
            if (progressStart == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(15);
            }
        }

        public void visitProgressFinish(@NotNull ProgressFinish progressFinish) {
            if (progressFinish == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(16);
            }
        }

        public void visitBuildStatus(@NotNull BuildStatus buildStatus) {
            if (buildStatus == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(17);
            }
        }

        public void visitBuildNumber(@NotNull BuildNumber buildNumber) {
            if (buildNumber == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(18);
            }
        }

        public void visitBuildStatisticValue(@NotNull BuildStatisticValue buildStatsValue) {
            if (buildStatsValue == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(19);
            }
        }

        public void visitMessageWithStatus(@NotNull Message msg) {
            Map msgAttrs;
            String text;
            if (msg == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(20);
            }
            if (!StringUtil.isEmpty((String)(text = (String)(msgAttrs = msg.getAttributes()).get(ATTR_KEY_TEXT)))) {
                String status = (String)msgAttrs.get(ATTR_KEY_STATUS);
                if (status.equals(ATTR_VALUE_STATUS_ERROR)) {
                    String stackTrace = (String)msgAttrs.get(ATTR_KEY_ERROR_DETAILS);
                    OutputToGeneralTestEventsConverter.this.fireOnErrorMsg(text, stackTrace, true);
                } else if (status.equals(ATTR_VALUE_STATUS_WARNING)) {
                    String stackTrace = (String)msgAttrs.get(ATTR_KEY_ERROR_DETAILS);
                    OutputToGeneralTestEventsConverter.this.fireOnErrorMsg(text, stackTrace, false);
                } else {
                    OutputToGeneralTestEventsConverter.this.fireOnUncapturedOutput(text, this.getOutputType(msg.getAttributes(), ProcessOutputTypes.STDOUT));
                }
            }
        }

        public void visitServiceMessage(@NotNull ServiceMessage msg) {
            if (msg == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(21);
            }
            String name = msg.getMessageName();
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg.asString());
            }
            if (TESTING_STARTED.equals(name)) {
                if (!OutputToGeneralTestEventsConverter.this.myFirstTestingStartedEvent) {
                    OutputToGeneralTestEventsConverter.this.startTesting();
                }
                OutputToGeneralTestEventsConverter.this.myFirstTestingStartedEvent = false;
            } else if (TESTING_FINISHED.equals(name)) {
                OutputToGeneralTestEventsConverter.this.finishTesting();
            } else if (KEY_TESTS_COUNT.equals(name)) {
                this.processTestCountInSuite(msg);
            } else if (CUSTOM_STATUS.equals(name)) {
                this.processCustomStatus(msg);
            } else if (MESSAGE.equals(name)) {
                Map msgAttrs = msg.getAttributes();
                String text = (String)msgAttrs.get(ATTR_KEY_TEXT);
                if (!StringUtil.isEmpty((String)text)) {
                    OutputToGeneralTestEventsConverter.this.fireOnUncapturedOutput(text, ProcessOutputTypes.STDOUT);
                }
            } else if (TEST_REPORTER_ATTACHED.equals(name)) {
                OutputToGeneralTestEventsConverter.this.fireOnTestFrameworkAttached(TestDurationStrategyKt.getDurationStrategy((String)msg.getAttributes().get("durationStrategy")));
            } else if (SUITE_TREE_STARTED.equals(name)) {
                OutputToGeneralTestEventsConverter.this.fireOnSuiteTreeStarted((String)msg.getAttributes().get("name"), (String)msg.getAttributes().get(ATTR_KEY_LOCATION_URL), BaseStartedNodeEvent.getMetainfo(msg), TreeNodeEvent.getNodeId(msg), (String)msg.getAttributes().get("parentNodeId"));
            } else if (SUITE_TREE_ENDED.equals(name)) {
                OutputToGeneralTestEventsConverter.this.fireOnSuiteTreeEnded((String)msg.getAttributes().get("name"));
            } else if (SUITE_TREE_NODE.equals(name)) {
                OutputToGeneralTestEventsConverter.this.fireOnSuiteTreeNodeAdded((String)msg.getAttributes().get("name"), (String)msg.getAttributes().get(ATTR_KEY_LOCATION_URL), BaseStartedNodeEvent.getMetainfo(msg), TreeNodeEvent.getNodeId(msg), (String)msg.getAttributes().get("parentNodeId"));
            } else if (BUILD_TREE_ENDED_NODE.equals(name)) {
                OutputToGeneralTestEventsConverter.this.fireOnBuildTreeEnded();
            } else if (ROOT_PRESENTATION.equals(name)) {
                Map attributes = msg.getAttributes();
                OutputToGeneralTestEventsConverter.this.fireRootPresentationAdded((String)attributes.get("name"), (String)attributes.get("comment"), (String)attributes.get(ATTR_KEY_LOCATION_URL_OLD));
            } else {
                GeneralTestEventsProcessor.logProblem(LOG, "Unexpected service message:" + name, OutputToGeneralTestEventsConverter.this.myTestFrameworkName);
                OutputToGeneralTestEventsConverter.this.fireOnUncapturedOutput(msg.asString() + "\n", ProcessOutputTypes.STDOUT);
            }
        }

        private void processTestCountInSuite(ServiceMessage msg) {
            String countStr = (String)msg.getAttributes().get(ATTR_KEY_TEST_COUNT);
            OutputToGeneralTestEventsConverter.this.fireOnTestsCountInSuite(this.convertToInt(countStr, msg));
        }

        private int convertToInt(String countStr, ServiceMessage msg) {
            int count = 0;
            try {
                count = Integer.parseInt(countStr);
            }
            catch (NumberFormatException ex) {
                String diagnosticInfo = (String)msg.getAttributes().get(ATTR_KEY_DIAGNOSTIC);
                LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(OutputToGeneralTestEventsConverter.this.myTestFrameworkName) + "Parse integer error." + (diagnosticInfo == null ? "" : " " + diagnosticInfo), (Throwable)ex);
            }
            return count;
        }

        private long convertToLong(String countStr, @NotNull ServiceMessage msg) {
            if (msg == null) {
                MyServiceMessageVisitor.$$$reportNull$$$0(22);
            }
            long count = 0L;
            try {
                count = Long.parseLong(countStr);
            }
            catch (NumberFormatException ex) {
                String diagnosticInfo = (String)msg.getAttributes().get(ATTR_KEY_DIAGNOSTIC);
                LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(OutputToGeneralTestEventsConverter.this.myTestFrameworkName) + "Parse long error." + (diagnosticInfo == null ? "" : " " + diagnosticInfo), (Throwable)ex);
            }
            return count;
        }

        private void processCustomStatus(ServiceMessage msg) {
            Map attrs = msg.getAttributes();
            String msgType = (String)attrs.get(ATTR_KEY_TEST_TYPE);
            if (msgType != null) {
                if (msgType.equals(ATTR_VAL_TEST_STARTED)) {
                    OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestStarted();
                } else if (msgType.equals(ATTR_VAL_TEST_FINISHED)) {
                    OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestFinished();
                } else if (msgType.equals(ATTR_VAL_TEST_FAILED)) {
                    OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestFailed();
                }
                return;
            }
            String testsCategory = (String)attrs.get(ATTR_KEY_TESTS_CATEGORY);
            if (testsCategory != null) {
                String countStr = (String)msg.getAttributes().get(ATTR_KEY_TEST_COUNT);
                OutputToGeneralTestEventsConverter.this.fireOnCustomProgressTestsCategory(testsCategory, this.convertToInt(countStr, msg));
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suiteStarted";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suiteFinished";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ATTR_VAL_TEST_STARTED;
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ATTR_VAL_TEST_FINISHED;
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testIgnored";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testStdOut";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testStdErr";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ATTR_VAL_TEST_FAILED;
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "publishArtifacts";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressMessage";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressStart";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressFinish";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildStatus";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildNumber";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildStatsValue";
                    break;
                }
                case 20: 
                case 21: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "msg";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter$MyServiceMessageVisitor";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutputType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTestSuiteStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTestSuiteFinished";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTestStarted";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTestFinished";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTestIgnored";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTestStdOut";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTestStdErr";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTestFailed";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPublishArtifacts";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "visitProgressMessage";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "visitProgressStart";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "visitProgressFinish";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "visitBuildStatus";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "visitBuildNumber";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "visitBuildStatisticValue";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "visitMessageWithStatus";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "visitServiceMessage";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToLong";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

