/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.pointers;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.pointers.FacetPointersManagerImpl;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetPointerImpl<F extends Facet>
implements FacetPointer<F> {
    private final FacetPointersManagerImpl myManager;
    private String myModuleName;
    private String myFacetTypeId;
    private String myFacetName;
    private F myFacet;

    public FacetPointerImpl(FacetPointersManagerImpl manager, String id2) {
        this.myManager = manager;
        int i2 = id2.indexOf(47);
        this.myModuleName = id2.substring(0, i2);
        int j = id2.lastIndexOf(47);
        this.myFacetTypeId = id2.substring(i2 + 1, j);
        this.myFacetName = id2.substring(j + 1);
    }

    public FacetPointerImpl(FacetPointersManagerImpl manager, @NotNull F facet) {
        if (facet == null) {
            FacetPointerImpl.$$$reportNull$$$0(0);
        }
        this.myManager = manager;
        this.myFacet = facet;
        this.updateInfo(this.myFacet);
        this.registerDisposable();
    }

    public void refresh() {
        this.findAndSetFacet();
        if (this.myFacet != null) {
            this.updateInfo(this.myFacet);
        }
    }

    private void findAndSetFacet() {
        if (this.myFacet == null) {
            this.myFacet = this.findFacet();
            if (this.myFacet != null) {
                this.registerDisposable();
            }
        }
    }

    private void registerDisposable() {
        Disposer.register(this.myFacet, (Disposable)new Disposable(){

            public void dispose() {
                FacetPointerImpl.this.myManager.dispose(FacetPointerImpl.this);
                FacetPointerImpl.this.myFacet = null;
            }
        });
    }

    private void updateInfo(@NotNull F facet) {
        if (facet == null) {
            FacetPointerImpl.$$$reportNull$$$0(1);
        }
        this.myModuleName = facet.getModule().getName();
        this.myFacetTypeId = facet.getType().getStringId();
        this.myFacetName = facet.getName();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myManager.getProject();
        if (project == null) {
            FacetPointerImpl.$$$reportNull$$$0(2);
        }
        return project;
    }

    public F getFacet() {
        this.findAndSetFacet();
        return this.myFacet;
    }

    @Nullable
    private F findFacet() {
        Module module = ModuleManager.getInstance((Project)this.myManager.getProject()).findModuleByName(this.myModuleName);
        if (module == null) {
            return null;
        }
        FacetType<F, ?> type = this.getFacetType();
        if (type == null) {
            return null;
        }
        return (F)FacetManager.getInstance((Module)module).findFacet(type.getId(), this.myFacetName);
    }

    @Nullable
    public F findFacet(@NotNull ModulesProvider modulesProvider, @NotNull FacetsProvider facetsProvider) {
        Module module;
        if (modulesProvider == null) {
            FacetPointerImpl.$$$reportNull$$$0(3);
        }
        if (facetsProvider == null) {
            FacetPointerImpl.$$$reportNull$$$0(4);
        }
        if ((module = modulesProvider.getModule(this.myModuleName)) == null) {
            return null;
        }
        FacetType<F, ?> type = this.getFacetType();
        if (type == null) {
            return null;
        }
        return (F)facetsProvider.findFacet(module, type.getId(), this.myFacetName);
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            FacetPointerImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFacetName() {
        String string = this.myFacetName;
        if (string == null) {
            FacetPointerImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getId() {
        String string = FacetPointersManager.constructId((String)this.myModuleName, (String)this.myFacetTypeId, (String)this.myFacetName);
        if (string == null) {
            FacetPointerImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getFacetTypeId() {
        String string = this.myFacetTypeId;
        if (string == null) {
            FacetPointerImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getModuleName(@Nullable ModifiableModuleModel moduleModel) {
        String newName;
        if (moduleModel != null && this.myFacet != null && (newName = moduleModel.getNewName(this.myFacet.getModule())) != null) {
            String string = newName;
            if (string == null) {
                FacetPointerImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = this.myModuleName;
        if (string == null) {
            FacetPointerImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getFacetName(@NotNull ModulesProvider modulesProvider, @NotNull FacetsProvider facetsProvider) {
        if (modulesProvider == null) {
            FacetPointerImpl.$$$reportNull$$$0(11);
        }
        if (facetsProvider == null) {
            FacetPointerImpl.$$$reportNull$$$0(12);
        }
        if (this.myFacet != null) {
            String string = modulesProvider.getFacetModel(this.myFacet.getModule()).getFacetName(this.myFacet);
            if (string == null) {
                FacetPointerImpl.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = this.myFacetName;
        if (string == null) {
            FacetPointerImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public FacetType<F, ?> getFacetType() {
        return FacetTypeRegistry.getInstance().findFacetType(this.myFacetTypeId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/pointers/FacetPointerImpl";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/pointers/FacetPointerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 6: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetTypeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateInfo";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFacet";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFacetName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

