/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;

public class ConsentSettingsUi
extends JPanel
implements ConfigurableUi<List<Consent>> {
    final Collection<Pair<JCheckBox, Consent>> consentMapping = new ArrayList<Pair<JCheckBox, Consent>>();
    private final boolean myPreferencesMode;

    public ConsentSettingsUi(boolean preferencesMode) {
        this.myPreferencesMode = preferencesMode;
        this.setLayout(new GridLayout(1, 1));
    }

    public void reset(@NotNull List<Consent> consents) {
        if (consents == null) {
            ConsentSettingsUi.$$$reportNull$$$0(0);
        }
        this.consentMapping.clear();
        if (consents.isEmpty()) {
            JLabel label2 = new JLabel("There are no data-sharing options available", 0);
            label2.setVerticalAlignment(0);
            label2.setOpaque(true);
            label2.setBackground(JBColor.background());
            this.removeAll();
            this.add(label2);
            return;
        }
        JPanel body = new JPanel(new GridBagLayout());
        body.setBackground(this.myPreferencesMode ? UIUtil.getPanelBackground() : UIUtil.getEditorPaneBackground());
        boolean addCheckBox2 = this.myPreferencesMode || consents.size() > 1;
        Iterator<Consent> it = consents.iterator();
        while (it.hasNext()) {
            Consent consent = it.next();
            JComponent comp = this.createConsentElement(consent, addCheckBox2);
            body.add((Component)comp, new GridBagConstraints(0, -1, 1, 1, 1.0, !it.hasNext() && this.myPreferencesMode ? 1.0 : 0.0, 18, 2, (Insets)(it.hasNext() ? JBUI.insets((int)0, (int)0, (int)10, (int)0) : JBUI.emptyInsets()), 0, 0));
        }
        if (!ConsentOptions.getInstance().isEAP()) {
            ConsentSettingsUi.addHintLabel(body, "Data sharing preferences apply to all installed " + ApplicationInfoImpl.getShadowInstance().getShortCompanyName() + " products.");
        }
        if (!this.myPreferencesMode) {
            ConsentSettingsUi.addHintLabel(body, "You can always change this behavior in " + ShowSettingsUtil.getSettingsMenuName() + " | Appearance & Behavior | System Settings | Data Sharing.");
        }
        if (!this.myPreferencesMode) {
            body.setBorder(JBUI.Borders.empty((int)10));
        }
        this.removeAll();
        JBScrollPane scrollPane = new JBScrollPane((Component)body, 20, 30);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        this.add((Component)scrollPane);
    }

    private static void addHintLabel(JPanel body, String text) {
        JBLabel hintLabel = new JBLabel(text);
        hintLabel.setForeground(UIUtil.getContextHelpForeground());
        hintLabel.setVerticalAlignment(1);
        hintLabel.setFont((Font)JBUI.Fonts.smallFont());
        body.add((Component)hintLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 1, new Insets(JBUIScale.scale((int)16), 0, JBUIScale.scale((int)10), 0), 0, 0));
    }

    private static String getParagraphTag() {
        return "<p style=\"margin-bottom:" + JBUIScale.scale((int)10) + "px;\">";
    }

    @NotNull
    private JComponent createConsentElement(Consent consent, boolean addCheckBox2) {
        JPanel pane2;
        if (addCheckBox2) {
            Consent usageStatsConsent;
            String checkBoxText = StringUtil.capitalize((String)StringUtil.toLowerCase((String)consent.getName()));
            if (ConsentOptions.getInstance().isEAP() && (usageStatsConsent = ConsentOptions.getInstance().getUsageStatsConsent()) != null && consent.getId().equals(usageStatsConsent.getId())) {
                checkBoxText = checkBoxText + " when using EAP versions";
            }
            JBCheckBox cb = new JBCheckBox(checkBoxText, consent.isAccepted());
            pane2 = UI.PanelFactory.panel((JComponent)cb).withComment(ConsentSettingsUi.getParagraphTag() + StringUtil.replace((String)consent.getText(), (String)"\n", (String)("</p>" + ConsentSettingsUi.getParagraphTag())) + "</p>").createPanel();
            cb.setOpaque(false);
            this.consentMapping.add((Pair<JCheckBox, Consent>)Pair.create((Object)cb, (Object)consent));
        } else {
            pane2 = new JPanel(new BorderLayout());
            JEditorPane viewer = SwingHelper.createHtmlViewer(true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
            viewer.setOpaque(false);
            viewer.setFocusable(false);
            UIUtil.doNotScrollToCaret((JTextComponent)viewer);
            viewer.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    URL url = e.getURL();
                    if (url != null) {
                        BrowserUtil.browse((URL)url);
                    }
                }
            });
            viewer.setText("<html><body>" + ConsentSettingsUi.getParagraphTag() + StringUtil.replace((String)consent.getText(), (String)"\n", (String)("</p>" + ConsentSettingsUi.getParagraphTag())) + "</p></body></html>");
            StyleSheet styleSheet = ((HTMLDocument)viewer.getDocument()).getStyleSheet();
            styleSheet.addRule("body {margin-top:0;padding-top:0;}");
            styleSheet.addRule("h2, em {margin-top:" + JBUIScale.scaleFontSize((float)20.0f) + "pt;}");
            styleSheet.addRule("h1, h2, h3, p, h4, em {margin-bottom:0;padding-bottom:0;}");
            styleSheet.addRule("p, h1 {margin-top:0;padding-top:" + JBUIScale.scaleFontSize((float)6.0f) + "pt;}");
            styleSheet.addRule("li {margin-bottom:" + JBUIScale.scaleFontSize((float)6.0f) + "pt;}");
            styleSheet.addRule("h2 {margin-top:0;padding-top:" + JBUIScale.scaleFontSize((float)13.0f) + "pt;}");
            styleSheet.addRule("a, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkColor()) + ";}");
            styleSheet.addRule("a:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkHoverColor()) + ";}");
            styleSheet.addRule("a:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkPressedColor()) + ";}");
            viewer.setCaretPosition(0);
            pane2.add((Component)viewer, "Center");
            this.consentMapping.add((Pair<JCheckBox, Consent>)Pair.create(null, (Object)consent));
        }
        pane2.setOpaque(false);
        JPanel jPanel2 = pane2;
        if (jPanel2 == null) {
            ConsentSettingsUi.$$$reportNull$$$0(1);
        }
        return jPanel2;
    }

    @NotNull
    private List<Consent> getState() {
        ArrayList<Consent> result2 = new ArrayList<Consent>();
        for (Pair<JCheckBox, Consent> pair : this.consentMapping) {
            JCheckBox checkBox2 = (JCheckBox)pair.first;
            result2.add(((Consent)pair.second).derive(checkBox2 == null || checkBox2.isSelected()));
        }
        ArrayList<Consent> arrayList = result2;
        if (arrayList == null) {
            ConsentSettingsUi.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean isModified(@NotNull List<Consent> consents) {
        if (consents == null) {
            ConsentSettingsUi.$$$reportNull$$$0(3);
        }
        List<Consent> state = this.getState();
        if (consents.size() != state.size()) {
            return true;
        }
        for (int i2 = 0; i2 < state.size(); ++i2) {
            Consent consent2;
            Consent consent1 = state.get(i2);
            if (!consent1.equals(consent2 = consents.get(i2))) {
                return true;
            }
            if (consent1.isAccepted() == consent2.isAccepted()) continue;
            return true;
        }
        return false;
    }

    public void apply(@NotNull List<Consent> consents) {
        if (consents == null) {
            ConsentSettingsUi.$$$reportNull$$$0(4);
        }
        consents.clear();
        consents.addAll(this.getState());
    }

    @NotNull
    public JComponent getComponent() {
        ConsentSettingsUi consentSettingsUi = this;
        if (consentSettingsUi == null) {
            ConsentSettingsUi.$$$reportNull$$$0(5);
        }
        return consentSettingsUi;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consents";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/ConsentSettingsUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/ConsentSettingsUi";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsentElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

