/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.EmptyCompletionNotifier;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditFileTypeOverrider;
import com.intellij.ide.lightEdit.LightEditSaveConfirmationHandler;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.intentions.openInProject.LightEditOpenInProjectIntention;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import java.awt.Component;
import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditUtil {
    private static final String ENABLED_FILE_OPEN_KEY = "light.edit.file.open.enabled";
    private static final String OPEN_FILE_IN_PROJECT_HREF = "open_file_in_project";
    private static boolean ourForceOpenInExistingProjectFlag;

    private LightEditUtil() {
    }

    public static boolean openFile(@NotNull Path path) {
        VirtualFile virtualFile;
        if (path == null) {
            LightEditUtil.$$$reportNull$$$0(0);
        }
        if ((virtualFile = VfsUtil.findFile((Path)path, (boolean)true)) != null && LightEdit.openFile((VirtualFile)virtualFile)) {
            LightEditFeatureUsagesUtil.logFileOpen(LightEditFeatureUsagesUtil.OpenPlace.CommandLine);
            return true;
        }
        return false;
    }

    public static boolean isOpenInExistingProject() {
        return ourForceOpenInExistingProjectFlag && ProjectManager.getInstance().getOpenProjects().length > 0;
    }

    @NotNull
    public static Project getProject() {
        Project project = LightEditService.getInstance().getOrCreateProject();
        if (project == null) {
            LightEditUtil.$$$reportNull$$$0(1);
        }
        return project;
    }

    @Nullable
    public static Project getProjectIfCreated() {
        return LightEditService.getInstance().getProject();
    }

    static boolean confirmClose(@NotNull String message, @NotNull String title, @NotNull LightEditSaveConfirmationHandler handler2) {
        if (message == null) {
            LightEditUtil.$$$reportNull$$$0(2);
        }
        if (title == null) {
            LightEditUtil.$$$reportNull$$$0(3);
        }
        if (handler2 == null) {
            LightEditUtil.$$$reportNull$$$0(4);
        }
        String[] options2 = new String[]{LightEditUtil.getCloseSave(), LightEditUtil.getCloseDiscard(), LightEditUtil.getCloseCancel()};
        int result2 = Messages.showDialog((Project)LightEditUtil.getProject(), (String)message, (String)title, (String[])options2, (int)0, (Icon)Messages.getWarningIcon());
        if (result2 >= 0) {
            if (LightEditUtil.getCloseCancel().equals(options2[result2])) {
                return false;
            }
            if (LightEditUtil.getCloseSave().equals(options2[result2])) {
                handler2.onSave();
            } else if (LightEditUtil.getCloseDiscard().equals(options2[result2])) {
                handler2.onDiscard();
            }
            return true;
        }
        return false;
    }

    @Nullable
    static VirtualFile chooseTargetFile(@NotNull Component parent, @NotNull LightEditorInfo editorInfo) {
        FileSaverDialog saver;
        VirtualFileWrapper fileWrapper;
        if (parent == null) {
            LightEditUtil.$$$reportNull$$$0(5);
        }
        if (editorInfo == null) {
            LightEditUtil.$$$reportNull$$$0(6);
        }
        if ((fileWrapper = (saver = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(IdeBundle.message((String)"dialog.title.save.as", (Object[])new Object[0]), IdeBundle.message((String)"label.choose.target.file", (Object[])new Object[0]), LightEditUtil.getKnownExtensions()), parent)).save(VfsUtil.getUserHomeDir(), editorInfo.getFile().getPresentableName())) != null) {
            return fileWrapper.getVirtualFile(true);
        }
        return null;
    }

    private static String[] getKnownExtensions() {
        return ArrayUtil.toStringArray((Collection)Stream.of(FileTypeManager.getInstance().getRegisteredFileTypes()).map(fileType -> fileType.getDefaultExtension()).sorted().distinct().collect(Collectors.toList()));
    }

    private static String getCloseSave() {
        return ApplicationBundle.message((String)"light.edit.close.save", (Object[])new Object[0]);
    }

    private static String getCloseDiscard() {
        return ApplicationBundle.message((String)"light.edit.close.discard", (Object[])new Object[0]);
    }

    private static String getCloseCancel() {
        return ApplicationBundle.message((String)"light.edit.close.cancel", (Object[])new Object[0]);
    }

    public static void markUnknownFileTypeAsPlainTextIfNeeded(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditUtil.$$$reportNull$$$0(7);
        }
        if (project != null && !project.isDefault() && !LightEdit.owns((Project)project)) {
            return;
        }
        if (LightEditUtil.isLightEditEnabled()) {
            LightEditFileTypeOverrider.markUnknownFileTypeAsPlainText(file2);
        }
    }

    public static boolean isLightEditEnabled() {
        return Registry.is((String)ENABLED_FILE_OPEN_KEY) && !PlatformUtils.isDataGrip();
    }

    @ApiStatus.Internal
    @NotNull
    public static EmptyCompletionNotifier createEmptyCompletionNotifier() {
        return new EmptyCompletionNotifier(){

            @Override
            public void showIncompleteHint(@NotNull Editor editor, @NotNull String text, boolean isDumbMode) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(1);
                }
                HintManager.getInstance().showInformationHint(editor, StringUtil.escapeXmlEntities((String)text) + CodeInsightBundle.message((String)"completion.incomplete.light.edit.suffix", (Object[])new Object[]{LightEditUtil.OPEN_FILE_IN_PROJECT_HREF}), e -> {
                    VirtualFile file2;
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && LightEditUtil.OPEN_FILE_IN_PROJECT_HREF.equals(e.getDescription()) && (file2 = LightEditService.getInstance().getSelectedFile()) != null) {
                        LightEditOpenInProjectIntention.performOn(file2);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/lightEdit/LightEditUtil$1";
                objectArray[2] = "showIncompleteHint";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static void setForceOpenInExistingProject(boolean openInExistingProject) {
        ourForceOpenInExistingProjectFlag = openInExistingProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "confirmClose";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chooseTargetFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markUnknownFileTypeAsPlainTextIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

