/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RatesPanel
extends JPanel {
    public static final int MAX_RATE = 5;
    private static final Icon STAR = AllIcons.Ide.Rating;
    private static final Icon STAR3 = AllIcons.Ide.Rating1;
    private static final Icon STAR4 = AllIcons.Ide.Rating2;
    private static final Icon STAR5 = AllIcons.Ide.Rating3;
    private static final Icon STAR6 = AllIcons.Ide.Rating4;
    private static final Icon[] STARs = new Icon[]{IconLoader.getDisabledIcon((Icon)STAR), STAR3, STAR3, STAR4, STAR4, STAR5, STAR5, STAR6, STAR6, STAR};
    private final JLabel[] myLabels = new JLabel[5];

    public RatesPanel() {
        super(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0);
        int myLabelsLength = this.myLabels.length;
        for (int i2 = 0; i2 < myLabelsLength; ++i2) {
            this.myLabels[i2] = new JLabel();
            this.myLabels[i2].setOpaque(false);
            this.add((Component)this.myLabels[i2], gc);
        }
    }

    public void setRate(String rating) {
        int i2;
        double dblRating = 0.0;
        if (rating != null) {
            try {
                dblRating = Double.parseDouble(rating);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int intRating = (int)dblRating;
        for (i2 = 0; i2 < intRating; ++i2) {
            this.myLabels[i2].setIcon(STAR);
        }
        if (intRating < 5) {
            this.myLabels[intRating].setIcon(STARs[Double.valueOf(dblRating * 10.0).intValue() % 10]);
            for (i2 = 1 + intRating; i2 < 5; ++i2) {
                this.myLabels[i2].setIcon(IconLoader.getDisabledIcon((Icon)STAR));
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return JBUI.size((int)55, (int)11);
    }
}

