/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginSiteUtils {
    private static final Pattern TAG_PATTERN = Pattern.compile("</?\\w+((\\s+\\w+(\\s*=\\s*(?:\".*?\"|'.*?'|[\\^'\">\\s]+))?)+\\s*|\\s*)/?>");
    private static final int SHORT_DESC_SIZE = 170;
    private static final Pattern BR_PATTERN = Pattern.compile("<br\\s*/?>");

    @Nullable
    public static String preparePluginDescription(@Nullable String s, boolean shortSize) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        String description = PluginSiteUtils.prepareDescription(s, shortSize);
        return description.isEmpty() || description.endsWith(".") ? description : description + ".";
    }

    @NotNull
    private static String prepareDescription(@NotNull String s, boolean shortSize) {
        String[] sanitize;
        String[] split;
        if (s == null) {
            PluginSiteUtils.$$$reportNull$$$0(0);
        }
        if (shortSize && (split = BR_PATTERN.split(s)).length > 1 && (sanitize = PluginSiteUtils.stripTags(split[0])).length() <= 170) {
            if (sanitize == null) {
                PluginSiteUtils.$$$reportNull$$$0(1);
            }
            return sanitize;
        }
        String stripped = PluginSiteUtils.stripTags(s);
        if (shortSize) {
            for (String sep : new String[]{". ", ".\n", ": ", ":\n"}) {
                String by = PluginSiteUtils.substringBy(stripped, sep);
                if (by == null) continue;
                String string = by;
                if (string == null) {
                    PluginSiteUtils.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (stripped.length() > 170) {
                int index = (stripped = stripped.substring(0, 170)).lastIndexOf(32);
                if (index == -1) {
                    index = stripped.length();
                }
                stripped = stripped.substring(0, index) + "...";
            }
        }
        String string = stripped;
        if (string == null) {
            PluginSiteUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private static String substringBy(@NotNull String str, @NotNull String separator) {
        int end;
        if (str == null) {
            PluginSiteUtils.$$$reportNull$$$0(4);
        }
        if (separator == null) {
            PluginSiteUtils.$$$reportNull$$$0(5);
        }
        if ((end = str.indexOf(separator)) > 0 && end <= 170) {
            return str.substring(0, end + (separator.contains(":") ? 0 : separator.length())).trim();
        }
        return null;
    }

    @NotNull
    private static String stripTags(@NotNull String s) {
        if (s == null) {
            PluginSiteUtils.$$$reportNull$$$0(6);
        }
        String string = TAG_PATTERN.matcher(s).replaceAll("").trim();
        if (string == null) {
            PluginSiteUtils.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginSiteUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginSiteUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "stripTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substringBy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "stripTags";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

