/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBTableRowEditor;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DarculaUIUtil {
    public static final String COMPACT_PROPERTY = "JComponent.compactHeight";
    public static final JBValue MINIMUM_WIDTH = new JBValue.Float(49.0f);
    public static final JBValue MINIMUM_HEIGHT = new JBValue.Float(24.0f);
    public static final JBValue COMPACT_HEIGHT = new JBValue.Float(20.0f);
    public static final JBValue ARROW_BUTTON_WIDTH = new JBValue.Float(23.0f);
    public static final JBValue LW = new JBValue.Float(1.0f);
    public static final JBValue BW = new JBValue.UIInteger("Component.focusWidth", 2);
    private static final JBValue CELL_EDITOR_BW = new JBValue.UIInteger("CellEditor.border.width", 2);
    public static final JBValue BUTTON_ARC = new JBValue.UIInteger("Button.arc", 6);
    public static final JBValue COMPONENT_ARC = new JBValue.UIInteger("Component.arc", 5);

    @Deprecated
    public static void paintFocusRing(Graphics g, Rectangle r) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.translate(r.x, r.y);
            DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, COMPONENT_ARC.getFloat(), true);
        }
        finally {
            g2.dispose();
        }
    }

    public static void paintFocusOval(Graphics2D g, float x, float y, float width, float height) {
        Outline.focus.setGraphicsColor(g, true);
        float blw = BW.getFloat() + LW.getFloat();
        Path2D.Float shape = new Path2D.Float(0);
        shape.append(new Ellipse2D.Float(x - blw, y - blw, width + blw * 2.0f, height + blw * 2.0f), false);
        shape.append(new Ellipse2D.Float(x, y, width, height), false);
        g.fill(shape);
    }

    @Deprecated
    public static void paintErrorBorder(Graphics2D g, int width, int height, int arc, boolean symmetric, boolean hasFocus) {
        DarculaUIUtil.paintOutlineBorder(g, width, height, arc, symmetric, hasFocus, Outline.error);
    }

    public static void paintOutlineBorder(Graphics2D g, int width, int height, float arc, boolean symmetric, boolean hasFocus, Outline type) {
        type.setGraphicsColor(g, hasFocus);
        DarculaUIUtil.doPaint(g, width, height, arc, symmetric);
    }

    public static void paintFocusBorder(Graphics2D g, int width, int height, float arc, boolean symmetric) {
        Outline.focus.setGraphicsColor(g, true);
        DarculaUIUtil.doPaint(g, width, height, arc, symmetric);
    }

    public static void doPaint(Graphics2D g, int width, int height, float arc, boolean symmetric) {
        float bw = UIUtil.isUnderDefaultMacTheme() ? (float)JBUIScale.scale((int)3) : BW.getFloat();
        float f = UIUtil.isRetina((Graphics2D)g) ? 0.5f : 1.0f;
        float lw = UIUtil.isUnderDefaultMacTheme() ? JBUIScale.scale((float)f) : LW.getFloat();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        float outerArc = arc > 0.0f ? arc + bw - JBUIScale.scale((float)2.0f) : bw;
        float rightOuterArc = symmetric ? outerArc : JBUIScale.scale((float)6.0f);
        Path2D.Float outerRect = new Path2D.Float(0);
        ((Path2D)outerRect).moveTo((float)width - rightOuterArc, 0.0);
        ((Path2D)outerRect).quadTo(width, 0.0, width, rightOuterArc);
        ((Path2D)outerRect).lineTo(width, (float)height - rightOuterArc);
        ((Path2D)outerRect).quadTo(width, height, (float)width - rightOuterArc, height);
        ((Path2D)outerRect).lineTo(outerArc, height);
        ((Path2D)outerRect).quadTo(0.0, height, 0.0, (float)height - outerArc);
        ((Path2D)outerRect).lineTo(0.0, outerArc);
        ((Path2D)outerRect).quadTo(0.0, 0.0, outerArc, 0.0);
        outerRect.closePath();
        float rightInnerArc = symmetric ? outerArc : JBUIScale.scale((float)7.0f);
        Path2D.Float innerRect = new Path2D.Float(0);
        ((Path2D)innerRect).moveTo((float)width - rightInnerArc, bw += lw);
        ((Path2D)innerRect).quadTo((float)width - bw, bw, (float)width - bw, rightInnerArc);
        ((Path2D)innerRect).lineTo((float)width - bw, (float)height - rightInnerArc);
        ((Path2D)innerRect).quadTo((float)width - bw, (float)height - bw, (float)width - rightInnerArc, (float)height - bw);
        ((Path2D)innerRect).lineTo(outerArc, (float)height - bw);
        ((Path2D)innerRect).quadTo(bw, (float)height - bw, bw, (float)height - outerArc);
        ((Path2D)innerRect).lineTo(bw, outerArc);
        ((Path2D)innerRect).quadTo(bw, bw, outerArc, bw);
        innerRect.closePath();
        Path2D.Float path = new Path2D.Float(0);
        path.append(outerRect, false);
        path.append(innerRect, false);
        g.fill(path);
    }

    private static boolean isCurrentEventShiftDownEvent() {
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        return event instanceof KeyEvent && ((KeyEvent)event).isShiftDown();
    }

    public static int getPatchedNextVisualPositionFrom(JTextComponent t, int pos, int direction) {
        if (!DarculaUIUtil.isCurrentEventShiftDownEvent()) {
            if (direction == 7 && t.getSelectionStart() < t.getSelectionEnd() && t.getSelectionEnd() == pos) {
                return t.getSelectionStart();
            }
            if (direction == 3 && t.getSelectionStart() < t.getSelectionEnd() && t.getSelectionStart() == pos) {
                return t.getSelectionEnd();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintCellEditorBorder(Graphics2D g2, Component c, Rectangle r, boolean hasFocus) {
        g2 = (Graphics2D)g2.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            float bw = CELL_EDITOR_BW.getFloat();
            Path2D.Float border = new Path2D.Float(0);
            border.append(new Rectangle2D.Float(0.0f, 0.0f, r.width, r.height), false);
            border.append(new Rectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f), false);
            Object op = ((JComponent)c).getClientProperty("JComponent.outline");
            if (op != null || hasFocus) {
                Outline outline = op == null ? Outline.focus : Outline.valueOf(op.toString());
                outline.setGraphicsColor(g2, true);
                g2.fill(border);
            }
        }
        finally {
            g2.dispose();
        }
    }

    public static boolean isCompact(Component c) {
        return c instanceof JComponent && ((JComponent)c).getClientProperty(COMPACT_PROPERTY) == Boolean.TRUE;
    }

    public static boolean isTableCellEditor(Component c) {
        return Boolean.TRUE.equals(((JComponent)c).getClientProperty("JComboBox.isTableCellEditor")) || ComponentUtil.findParentByCondition((Component)c, p -> p instanceof JBTableRowEditor) == null && ComponentUtil.findParentByCondition((Component)c, p -> p instanceof JTable) != null;
    }

    @Deprecated
    public static float lw(Graphics2D g2) {
        return JBUIScale.scale((float)1.0f);
    }

    @Deprecated
    public static float bw() {
        return BW.getFloat();
    }

    @Deprecated
    public static float arc() {
        return COMPONENT_ARC.getFloat();
    }

    @Deprecated
    public static float buttonArc() {
        return BUTTON_ARC.get();
    }

    public static Insets paddings() {
        return JBUI.insets((int)1);
    }

    public static Color getOutlineColor(boolean enabled, boolean focused) {
        return enabled ? (focused ? JBColor.namedColor((String)"Component.focusedBorderColor", (Color)JBColor.namedColor((String)"Outline.focusedColor", (int)8892378)) : JBColor.namedColor((String)"Component.borderColor", (Color)JBColor.namedColor((String)"Outline.color", (Color)Gray.xBF))) : JBColor.namedColor((String)"Component.disabledBorderColor", (Color)JBColor.namedColor((String)"Outline.disabledColor", (Color)Gray.xCF));
    }

    @Deprecated
    public static Color getArrowButtonBackgroundColor(boolean enabled, boolean editable) {
        return JBUI.CurrentTheme.Arrow.backgroundColor((boolean)enabled, (boolean)editable);
    }

    @Deprecated
    public static Color getArrowButtonForegroundColor(boolean enabled) {
        return JBUI.CurrentTheme.Arrow.foregroundColor((boolean)enabled);
    }

    public static Dimension maximize(@Nullable Dimension s1, @NotNull Dimension s2) {
        if (s2 == null) {
            DarculaUIUtil.$$$reportNull$$$0(0);
        }
        return DarculaUIUtil.isEmpty(s1) ? s2 : new Dimension(Math.max(s1.width, s2.width), Math.max(s1.height, s2.height));
    }

    private static boolean isEmpty(Dimension d) {
        return d == null || d.width == 0 && d.height == 0;
    }

    public static Color getButtonTextColor(@NotNull AbstractButton button2) {
        Color fg;
        if (button2 == null) {
            DarculaUIUtil.$$$reportNull$$$0(1);
        }
        if ((fg = button2.getForeground()) instanceof UIResource && DarculaButtonUI.isDefaultButton(button2)) {
            Color selectedFg = UIManager.getColor("Button.default.foreground");
            if (selectedFg == null) {
                selectedFg = UIManager.getColor("Button.darcula.selectedButtonForeground");
            }
            if (selectedFg != null) {
                return selectedFg;
            }
        }
        return fg;
    }

    public static boolean isMultiLineHTML(@Nullable String text) {
        if (text != null) {
            return BasicHTML.isHTMLString(text = text.toLowerCase(Locale.getDefault())) && (text.contains("<br>") || text.contains("<br/>"));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/ui/laf/darcula/DarculaUIUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "maximize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getButtonTextColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MouseHoverPropertyTrigger
    extends MouseAdapter {
        private final JComponent repaintComponent;
        private final String hoverProperty;

        public MouseHoverPropertyTrigger(@NotNull JComponent repaintComponent, @NotNull String hoverProperty) {
            if (repaintComponent == null) {
                MouseHoverPropertyTrigger.$$$reportNull$$$0(0);
            }
            if (hoverProperty == null) {
                MouseHoverPropertyTrigger.$$$reportNull$$$0(1);
            }
            this.repaintComponent = repaintComponent;
            this.hoverProperty = hoverProperty;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setHover((JComponent)e.getComponent(), Boolean.TRUE);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setHover((JComponent)e.getComponent(), Boolean.FALSE);
        }

        private void setHover(JComponent c, Boolean value2) {
            if (c.isEnabled()) {
                c.putClientProperty(this.hoverProperty, value2);
                this.repaintComponent.repaint();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repaintComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hoverProperty";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/ui/laf/darcula/DarculaUIUtil$MouseHoverPropertyTrigger";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Outline {
        error{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                g.setColor(JBUI.CurrentTheme.Focus.errorColor((boolean)focused));
            }
        }
        ,
        warning{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                g.setColor(JBUI.CurrentTheme.Focus.warningColor((boolean)focused));
            }
        }
        ,
        defaultButton{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                if (focused) {
                    g.setColor(JBUI.CurrentTheme.Focus.defaultButtonColor());
                }
            }
        }
        ,
        focus{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                if (focused) {
                    g.setColor(JBUI.CurrentTheme.Focus.focusColor());
                }
            }
        };


        public abstract void setGraphicsColor(Graphics2D var1, boolean var2);
    }
}

