/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor;

import com.intellij.largeFilesEditor.actions.LfeActionDisabled;
import com.intellij.largeFilesEditor.actions.LfeBaseEditorActionHandler;
import com.intellij.largeFilesEditor.actions.LfeBaseProxyAction;
import com.intellij.largeFilesEditor.actions.LfeEditorActionHandlerDisabled;
import com.intellij.largeFilesEditor.actions.LfeEditorActionHandlerEscape;
import com.intellij.largeFilesEditor.actions.LfeEditorActionHandlerFind;
import com.intellij.largeFilesEditor.actions.LfeEditorActionSearchAgainHandler;
import com.intellij.largeFilesEditor.actions.LfeEditorActionSearchBackHandler;
import com.intellij.largeFilesEditor.editor.actions.LfeEditorActionTextStartEndHandler;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;

public final class PlatformActionsReplacer {
    private static final Logger logger = Logger.getInstance(PlatformActionsReplacer.class);
    private static boolean isPlatformActionsWereAdapted = false;

    public static void makeAdaptingOfPlatformActionsIfNeed() {
        if (!isPlatformActionsWereAdapted) {
            isPlatformActionsWereAdapted = true;
            PlatformActionsReplacer.makeAdaptingOfPlatformActions();
        }
    }

    private static void makeAdaptingOfPlatformActions() {
        logger.info("[Large File Editor Subsystem] Performing adapting of platform actions...");
        PlatformActionsReplacer.disableActionForLfe("HighlightUsagesInFile");
        PlatformActionsReplacer.disableActionForLfe("GotoLine");
        PlatformActionsReplacer.addEditorActionHandler("FindNext", LfeEditorActionSearchAgainHandler::new);
        PlatformActionsReplacer.addEditorActionHandler("FindPrevious", LfeEditorActionSearchBackHandler::new);
        PlatformActionsReplacer.addEditorActionHandler("EditorTextStart", origHandler -> new LfeEditorActionTextStartEndHandler(origHandler, true));
        PlatformActionsReplacer.addEditorActionHandler("EditorTextEnd", origHandler -> new LfeEditorActionTextStartEndHandler(origHandler, false));
        PlatformActionsReplacer.addEditorActionHandler("EditorEscape", LfeEditorActionHandlerEscape::new);
        PlatformActionsReplacer.addEditorActionHandler("Find", LfeEditorActionHandlerFind::new);
        PlatformActionsReplacer.addDisablingEditorActionHandler("Replace");
        PlatformActionsReplacer.addDisablingEditorActionHandler("FindWordAtCaret");
        PlatformActionsReplacer.addDisablingEditorActionHandler("SelectAllOccurrences");
        PlatformActionsReplacer.addDisablingEditorActionHandler("SelectNextOccurrence");
        PlatformActionsReplacer.addDisablingEditorActionHandler("UnselectPreviousOccurrence");
    }

    private static void addDisablingEditorActionHandler(String actionId) {
        PlatformActionsReplacer.addEditorActionHandler(actionId, LfeEditorActionHandlerDisabled::new);
    }

    private static void addEditorActionHandler(String actionId, MyEditorActionHandlerFactory<LfeBaseEditorActionHandler> lfeEditorActionHandlerFactory) {
        try {
            EditorActionManager editorActionManager = EditorActionManager.getInstance();
            EditorActionHandler originalHandler = editorActionManager.getActionHandler(actionId);
            LfeBaseEditorActionHandler newHandler = lfeEditorActionHandlerFactory.create(originalHandler);
            editorActionManager.setActionHandler(actionId, (EditorActionHandler)newHandler);
        }
        catch (ClassCastException e) {
            logger.warn((Throwable)e);
        }
    }

    private static void disableActionForLfe(String actionId) {
        PlatformActionsReplacer.replaceActionByProxy(actionId, LfeActionDisabled::new);
    }

    private static void replaceActionByProxy(String actionId, MyActionFactory<LfeBaseProxyAction> actionFactory) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction originalAction = actionManager.getAction(actionId);
        if (originalAction == null) {
            logger.warn("[Large File Editor Subsystem] Can't replace action with id=\"" + actionId + "\". Action with this id doesn't exist");
            return;
        }
        LfeBaseProxyAction proxyAction = actionFactory.create(originalAction);
        actionManager.replaceAction(actionId, (AnAction)proxyAction);
    }

    private static interface MyEditorActionHandlerFactory<T extends LfeBaseEditorActionHandler> {
        public T create(EditorActionHandler var1);
    }

    private static interface MyActionFactory<T extends LfeBaseProxyAction> {
        public T create(AnAction var1);
    }
}

