/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.util.Segment;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface SweepProcessor<T> {
    public boolean process(int var1, @NotNull T var2, boolean var3, @NotNull Collection<? extends T> var4);

    public static <T extends Segment> boolean sweep(@NotNull Generator<? extends T> generator, @NotNull SweepProcessor<T> sweepProcessor) {
        PriorityQueue<Segment> ends;
        if (generator == null) {
            SweepProcessor.$$$reportNull$$$0(0);
        }
        if (sweepProcessor == null) {
            SweepProcessor.$$$reportNull$$$0(1);
        }
        if (!generator.generateInStartOffsetOrder(arg_0 -> SweepProcessor.lambda$sweep$0(ends = new PriorityQueue<Segment>(5, Comparator.comparingInt(Segment::getEndOffset)), sweepProcessor, arg_0))) {
            return false;
        }
        while (!ends.isEmpty()) {
            Segment previous = (Segment)ends.remove();
            int prevEnd = previous.getEndOffset();
            if (sweepProcessor.process(prevEnd, previous, false, ends)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$sweep$0(Queue ends, SweepProcessor sweepProcessor, Segment marker) {
        Segment previous;
        int prevEnd;
        int start2 = marker.getStartOffset();
        while (!ends.isEmpty() && (prevEnd = (previous = (Segment)ends.peek()).getEndOffset()) <= start2) {
            if (!sweepProcessor.process(prevEnd, previous, false, ends)) {
                return false;
            }
            ends.remove();
        }
        if (!sweepProcessor.process(start2, marker, true, ends)) {
            return false;
        }
        ends.offer(marker);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "generator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sweepProcessor";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/impl/SweepProcessor";
        objectArray[2] = "sweep";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface Generator<T> {
        public boolean generateInStartOffsetOrder(@NotNull Processor<? super T> var1);
    }
}

