/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.EditKeymapsDialog;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class SystemShortcuts {
    private static final Logger LOG = Logger.getInstance(SystemShortcuts.class);
    @NotNull
    private static final String ourNotificationGroupId = "System shortcuts conflicts";
    @NotNull
    private static final String ourUnknownSysAction = "Unknown action";
    private static boolean ourIsNotificationRegistered = false;
    @NotNull
    private final Map<KeyStroke, AWTKeyStroke> myKeyStroke2SysShortcut = new HashMap<KeyStroke, AWTKeyStroke>();
    @NotNull
    private final MuteConflictsSettings myMutedConflicts = new MuteConflictsSettings();
    @NotNull
    private final Set<String> myNotifiedActions = new HashSet<String>();
    private int myNotifyCount = 0;
    @Nullable
    private Keymap myKeymap;
    @NotNull
    private final Map<AWTKeyStroke, ConflictItem> myKeymapConflicts = new HashMap<AWTKeyStroke, ConflictItem>();
    private static Class ourShkClass;
    private static Method ourMethodGetDescription;
    private static Method ourMethodReadSystemHotkeys;
    private static final boolean DEBUG_SYSTEM_SHORTCUTS;

    private SystemShortcuts() {
        this.readSystem();
    }

    @NotNull
    public static SystemShortcuts getInstance() {
        SystemShortcuts systemShortcuts = (SystemShortcuts)ApplicationManager.getApplication().getService(SystemShortcuts.class);
        if (systemShortcuts == null) {
            SystemShortcuts.$$$reportNull$$$0(0);
        }
        return systemShortcuts;
    }

    public void updateKeymapConflicts(@Nullable Keymap keymap2) {
        this.myKeymap = keymap2;
        this.myKeymapConflicts.clear();
        if (this.myKeyStroke2SysShortcut.isEmpty()) {
            return;
        }
        for (KeyStroke sysKS : this.myKeyStroke2SysShortcut.keySet()) {
            String[] actIds = SystemShortcuts.computeOnEdt(() -> keymap2.getActionIds(sysKS));
            if (actIds == null || actIds.length == 0) continue;
            @NotNull AWTKeyStroke shk = this.myKeyStroke2SysShortcut.get(sysKS);
            this.myKeymapConflicts.put(shk, new ConflictItem(sysKS, SystemShortcuts.getDescription(shk), actIds));
        }
    }

    @NotNull
    public Collection<ConflictItem> getUnmutedKeymapConflicts() {
        ArrayList<ConflictItem> result2 = new ArrayList<ConflictItem>();
        this.myKeymapConflicts.forEach((ks, ci) -> {
            if (ci.getUnmutedActionId(this.myMutedConflicts) != null) {
                result2.add((ConflictItem)ci);
            }
        });
        ArrayList<ConflictItem> arrayList = result2;
        if (arrayList == null) {
            SystemShortcuts.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public Condition<AnAction> createKeymapConflictsActionFilter() {
        if (this.myKeyStroke2SysShortcut.isEmpty() || this.myKeymap == null) {
            return null;
        }
        Condition predicat = sc -> {
            if (sc == null) {
                return false;
            }
            for (KeyStroke ks : this.myKeyStroke2SysShortcut.keySet()) {
                ConflictItem ci;
                if (!sc.startsWith((Shortcut)new KeyboardShortcut(ks, null)) || (ci = this.myKeymapConflicts.get(this.myKeyStroke2SysShortcut.get(ks))) == null || ci.getUnmutedActionId(this.myMutedConflicts) == null) continue;
                return true;
            }
            return false;
        };
        return ActionsTreeUtil.isActionFiltered(ActionManager.getInstance(), this.myKeymap, (Condition<? super Shortcut>)predicat);
    }

    @Nullable
    public Map<KeyboardShortcut, String> calculateConflicts(@NotNull Keymap keymap2, @NotNull String actionId) {
        Shortcut[] actionShortcuts;
        if (keymap2 == null) {
            SystemShortcuts.$$$reportNull$$$0(2);
        }
        if (actionId == null) {
            SystemShortcuts.$$$reportNull$$$0(3);
        }
        if (this.myKeyStroke2SysShortcut.isEmpty()) {
            return null;
        }
        HashMap<KeyboardShortcut, String> result2 = null;
        for (Shortcut sc : actionShortcuts = SystemShortcuts.computeOnEdt(() -> keymap2.getShortcuts(actionId))) {
            if (!(sc instanceof KeyboardShortcut)) continue;
            KeyboardShortcut ksc = (KeyboardShortcut)sc;
            for (KeyStroke sks : this.myKeyStroke2SysShortcut.keySet()) {
                if (!ksc.getFirstKeyStroke().equals(sks) && !sks.equals(ksc.getSecondKeyStroke())) continue;
                if (result2 == null) {
                    result2 = new HashMap<KeyboardShortcut, String>();
                }
                result2.put(ksc, SystemShortcuts.getDescription(this.myKeyStroke2SysShortcut.get(sks)));
            }
        }
        return result2;
    }

    private static <T> T computeOnEdt(Supplier<T> supplier2) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            return supplier2.get();
        }
        Ref result2 = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set(supplier2.get()));
        return (T)result2.get();
    }

    @Nullable
    public Map<KeyStroke, String> createKeystroke2SysShortcutMap() {
        if (this.myKeyStroke2SysShortcut.isEmpty()) {
            return null;
        }
        HashMap<KeyStroke, String> result2 = new HashMap<KeyStroke, String>();
        this.myKeyStroke2SysShortcut.forEach((ks, sysks) -> result2.put((KeyStroke)ks, SystemShortcuts.getDescription(sysks)));
        return result2;
    }

    private int getUnmutedConflictsCount() {
        if (this.myKeymapConflicts.isEmpty()) {
            return 0;
        }
        int result2 = 0;
        for (ConflictItem ci : this.myKeymapConflicts.values()) {
            if (ci.getUnmutedActionId(this.myMutedConflicts) == null) continue;
            ++result2;
        }
        return result2;
    }

    public void onUserPressedShortcut(@NotNull Keymap keymap2, String @NotNull [] actionIds, @NotNull KeyboardShortcut ksc) {
        if (keymap2 == null) {
            SystemShortcuts.$$$reportNull$$$0(4);
        }
        if (ksc == null) {
            SystemShortcuts.$$$reportNull$$$0(5);
        }
        if (actionIds == null) {
            SystemShortcuts.$$$reportNull$$$0(6);
        }
        if (this.myNotifyCount > 0 || actionIds.length == 0) {
            return;
        }
        KeyStroke ks = ksc.getFirstKeyStroke();
        AWTKeyStroke sysKs = this.myKeyStroke2SysShortcut.get(ks);
        if (sysKs == null && ksc.getSecondKeyStroke() != null) {
            ks = ksc.getSecondKeyStroke();
            sysKs = this.myKeyStroke2SysShortcut.get(ks);
        }
        if (sysKs == null) {
            return;
        }
        String unmutedActId = null;
        for (String actId : actionIds) {
            if (this.myNotifiedActions.contains(actId) || this.myMutedConflicts.isMutedAction(actId)) continue;
            unmutedActId = actId;
            break;
        }
        if (unmutedActId == null) {
            return;
        }
        @Nullable String macOsShortcutAction = SystemShortcuts.getDescription(sysKs);
        if (macOsShortcutAction == ourUnknownSysAction) {
            macOsShortcutAction = null;
        }
        this.doNotify(keymap2, unmutedActId, ks, macOsShortcutAction, ksc);
    }

    private void doNotify(@NotNull Keymap keymap2, @NotNull String actionId, @NotNull KeyStroke sysKS, @Nullable String macOsShortcutAction, @NotNull KeyboardShortcut conflicted) {
        String actText;
        if (keymap2 == null) {
            SystemShortcuts.$$$reportNull$$$0(7);
        }
        if (actionId == null) {
            SystemShortcuts.$$$reportNull$$$0(8);
        }
        if (sysKS == null) {
            SystemShortcuts.$$$reportNull$$$0(9);
        }
        if (conflicted == null) {
            SystemShortcuts.$$$reportNull$$$0(10);
        }
        if (!ourIsNotificationRegistered) {
            ourIsNotificationRegistered = true;
            NotificationsConfiguration.getNotificationsConfiguration().register(ourNotificationGroupId, NotificationDisplayType.STICKY_BALLOON, true);
        }
        this.updateKeymapConflicts(keymap2);
        int unmutedConflicts = this.getUnmutedConflictsCount();
        boolean hasOtherConflicts = unmutedConflicts > 1;
        AnAction act = ActionManager.getInstance().getAction(actionId);
        String string = actText = act == null ? actionId : act.getTemplateText();
        String message = hasOtherConflicts ? IdeBundle.message((String)"notification.content.more.shortcut.conflict", (Object[])new Object[]{actText, unmutedConflicts - 1}) : IdeBundle.message((String)"notification.content.shortcut.conflicts.with.macos.shortcut.modify", (Object[])new Object[]{actText, macOsShortcutAction == null ? "" : " '" + macOsShortcutAction + "'"});
        Notification notification = new Notification(ourNotificationGroupId, IdeBundle.message((String)"notification.title.shortcuts.conflicts", (Object[])new Object[0]), message, NotificationType.WARNING, null);
        if (hasOtherConflicts) {
            DumbAwareAction showKeymapPanelAction = DumbAwareAction.create((String)IdeBundle.message((String)"action.text.modify.shortcuts", (Object[])new Object[0]), e -> {
                new EditKeymapsDialog(null, actionId, true).show();
                this.updateKeymapConflicts(this.myKeymap);
            });
            notification.addAction((AnAction)showKeymapPanelAction);
        } else {
            DumbAwareAction configureShortcut = DumbAwareAction.create((String)IdeBundle.message((String)"action.text.modify.shortcut", (Object[])new Object[0]), e -> {
                Component component2 = (Component)e.getDataContext().getData(PlatformDataKeys.CONTEXT_COMPONENT);
                if (component2 == null) {
                    Window[] frames = Window.getWindows();
                    Component component3 = component2 = frames == null || frames.length == 0 ? null : frames[0];
                    if (component2 == null) {
                        LOG.error("can't show KeyboardShortcutDialog (parent component wasn't found)");
                        return;
                    }
                }
                KeymapPanel.addKeyboardShortcut(actionId, ActionShortcutRestrictions.getInstance().getForActionId(actionId), keymap2, component2, conflicted, this, new QuickList[0]);
                notification.expire();
            });
            notification.addAction((AnAction)configureShortcut);
        }
        DumbAwareAction muteAction = DumbAwareAction.create((String)IdeBundle.message((String)"action.dont.show.again.text", (Object[])new Object[0]), e -> {
            this.myMutedConflicts.addMutedAction(actionId);
            notification.expire();
        });
        notification.addAction((AnAction)muteAction);
        if (SystemInfo.isMac && !hasOtherConflicts) {
            DumbAwareAction changeSystemSettings = DumbAwareAction.create((String)IdeBundle.message((String)"action.text.change.system.shortcuts", (Object[])new Object[0]), e -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
                GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"osascript", "-e", "tell application \"System Preferences\"", "-e", "set the current pane to pane id \"com.apple.preference.keyboard\"", "-e", "reveal anchor \"shortcutsTab\" of pane id \"com.apple.preference.keyboard\"", "-e", "activate", "-e", "end tell"});
                try {
                    ExecUtil.execAndGetOutput((GeneralCommandLine)cmdLine);
                }
                catch (ExecutionException ex) {
                    LOG.error((Throwable)ex);
                }
            }));
            notification.addAction((AnAction)changeSystemSettings);
        }
        this.myNotifiedActions.add(actionId);
        ++this.myNotifyCount;
        notification.notify(null);
    }

    @NotNull
    private static String getDescription(@NotNull AWTKeyStroke systemHotkey) {
        if (systemHotkey == null) {
            SystemShortcuts.$$$reportNull$$$0(11);
        }
        if (ourShkClass == null) {
            ourShkClass = ReflectionUtil.forName((String)"java.awt.desktop.SystemHotkey");
        }
        if (ourShkClass == null) {
            return ourUnknownSysAction;
        }
        if (ourMethodGetDescription == null) {
            ourMethodGetDescription = ReflectionUtil.getMethod((Class)ourShkClass, (String)"getDescription", (Class[])new Class[0]);
        }
        String result2 = null;
        try {
            result2 = (String)ourMethodGetDescription.invoke((Object)systemHotkey, new Object[0]);
        }
        catch (Throwable e) {
            Logger.getInstance(SystemShortcuts.class).error(e);
        }
        if (result2 == null) {
            return ourUnknownSysAction;
        }
        String delimiter = " - ";
        int pos0 = result2.indexOf(" - ");
        if (pos0 < 0) {
            String string = result2;
            if (string == null) {
                SystemShortcuts.$$$reportNull$$$0(12);
            }
            return string;
        }
        int pos1 = result2.indexOf(" - ", pos0 + " - ".length());
        if (pos1 < 0) {
            String string = result2;
            if (string == null) {
                SystemShortcuts.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = result2.substring(pos0 + " - ".length(), pos1).replace("%", "").replace("@", "");
        if (string == null) {
            SystemShortcuts.$$$reportNull$$$0(14);
        }
        return string;
    }

    private void readSystem() {
        this.myKeyStroke2SysShortcut.clear();
        if (!SystemInfo.isMac || !SystemInfo.isJetBrainsJvm) {
            return;
        }
        try {
            if (!Registry.is((String)"read.system.shortcuts")) {
                return;
            }
            if (ourShkClass == null) {
                ourShkClass = ReflectionUtil.forName((String)"java.awt.desktop.SystemHotkey");
            }
            if (ourShkClass == null) {
                return;
            }
            if (ourMethodReadSystemHotkeys == null) {
                ourMethodReadSystemHotkeys = ReflectionUtil.getMethod((Class)ourShkClass, (String)"readSystemHotkeys", (Class[])new Class[0]);
            }
            if (ourMethodReadSystemHotkeys == null) {
                return;
            }
            List all = (List)ourMethodReadSystemHotkeys.invoke((Object)ourShkClass, new Object[0]);
            if (all == null || all.isEmpty()) {
                return;
            }
            StringBuilder debugInfo = new StringBuilder();
            for (AWTKeyStroke shk : all) {
                KeyStroke sysKS;
                if (shk.getModifiers() == 0 || shk.getKeyChar() == '\uffff' && shk.getKeyCode() == 0 || "Move focus to the next window in application".equals(SystemShortcuts.getDescription(shk))) continue;
                if (shk.getKeyChar() != '\uffff') {
                    int keyCode = KeyEvent.getExtendedKeyCodeForChar(shk.getKeyChar());
                    if (keyCode == 0) continue;
                    sysKS = KeyStroke.getKeyStroke(keyCode, shk.getModifiers());
                } else {
                    sysKS = KeyStroke.getKeyStroke(shk.getKeyCode(), shk.getModifiers());
                }
                this.myKeyStroke2SysShortcut.put(sysKS, shk);
                if (!DEBUG_SYSTEM_SHORTCUTS) continue;
                debugInfo.append(shk.toString()).append(";\n");
            }
            if (DEBUG_SYSTEM_SHORTCUTS) {
                Logger.getInstance(SystemShortcuts.class).info("system shortcuts:\n" + debugInfo);
            }
        }
        catch (Throwable e) {
            Logger.getInstance(SystemShortcuts.class).debug(e);
        }
    }

    static {
        DEBUG_SYSTEM_SHORTCUTS = Boolean.getBoolean("debug.system.shortcuts");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/SystemShortcuts";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksc";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionIds";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sysKS";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicted";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemHotkey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmutedKeymapConflicts";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/SystemShortcuts";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateConflicts";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onUserPressedShortcut";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doNotify";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MuteConflictsSettings {
        private static final String MUTED_ACTIONS_KEY = "muted.system.shortcut.conflicts.actions";
        @NotNull
        private Set<String> myMutedActions;

        private MuteConflictsSettings() {
        }

        void init() {
            if (this.myMutedActions != null) {
                return;
            }
            this.myMutedActions = new HashSet<String>();
            String[] muted = PropertiesComponent.getInstance().getValues(MUTED_ACTIONS_KEY);
            if (muted != null) {
                Collections.addAll(this.myMutedActions, muted);
            }
        }

        void addMutedAction(@NotNull String actId) {
            if (actId == null) {
                MuteConflictsSettings.$$$reportNull$$$0(0);
            }
            this.init();
            this.myMutedActions.add(actId);
            PropertiesComponent.getInstance().setValues(MUTED_ACTIONS_KEY, ArrayUtilRt.toStringArray(this.myMutedActions));
        }

        void removeMutedAction(@NotNull String actId) {
            if (actId == null) {
                MuteConflictsSettings.$$$reportNull$$$0(1);
            }
            this.init();
            this.myMutedActions.remove(actId);
            PropertiesComponent.getInstance().setValues(MUTED_ACTIONS_KEY, ArrayUtilRt.toStringArray(this.myMutedActions));
        }

        public boolean isMutedAction(@NotNull String actionId) {
            if (actionId == null) {
                MuteConflictsSettings.$$$reportNull$$$0(2);
            }
            this.init();
            return this.myMutedActions.contains(actionId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/SystemShortcuts$MuteConflictsSettings";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMutedAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeMutedAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMutedAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ConflictItem {
        @NotNull
        final String mySysActionDesc;
        @NotNull
        final KeyStroke mySysKeyStroke;
        final String @NotNull [] myActionIds;

        public ConflictItem(@NotNull KeyStroke sysKeyStroke, @NotNull String sysActionDesc, String @NotNull [] actionIds) {
            if (sysKeyStroke == null) {
                ConflictItem.$$$reportNull$$$0(0);
            }
            if (sysActionDesc == null) {
                ConflictItem.$$$reportNull$$$0(1);
            }
            if (actionIds == null) {
                ConflictItem.$$$reportNull$$$0(2);
            }
            this.mySysKeyStroke = sysKeyStroke;
            this.mySysActionDesc = sysActionDesc;
            this.myActionIds = actionIds;
        }

        @NotNull
        public String getSysActionDesc() {
            String string = this.mySysActionDesc;
            if (string == null) {
                ConflictItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public KeyStroke getSysKeyStroke() {
            KeyStroke keyStroke = this.mySysKeyStroke;
            if (keyStroke == null) {
                ConflictItem.$$$reportNull$$$0(4);
            }
            return keyStroke;
        }

        public String @NotNull [] getActionIds() {
            if (this.myActionIds == null) {
                ConflictItem.$$$reportNull$$$0(5);
            }
            return this.myActionIds;
        }

        @Nullable
        String getUnmutedActionId(@NotNull MuteConflictsSettings settings) {
            if (settings == null) {
                ConflictItem.$$$reportNull$$$0(6);
            }
            for (String actId : this.myActionIds) {
                if (settings.isMutedAction(actId)) continue;
                return actId;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sysKeyStroke";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sysActionDesc";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionIds";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/keymap/impl/SystemShortcuts$ConflictItem";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/SystemShortcuts$ConflictItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSysActionDesc";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSysKeyStroke";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionIds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getUnmutedActionId";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

