/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.application.options.RegistryManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.CanonicalPathMap;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileWatcher {
    private static final Logger LOG = Logger.getInstance(FileWatcher.class);
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            return new NotificationGroup("File Watcher Messages", NotificationDisplayType.STICKY_BALLOON, true);
        }
    };
    private final ManagingFS myManagingFS;
    private final MyFileWatcherNotificationSink myNotificationSink;
    private final AtomicBoolean myFailureShown;
    private final ExecutorService myFileWatcherExecutor;
    private final AtomicReference<Future<?>> myLastTask;
    private volatile CanonicalPathMap myPathMap;
    private volatile List<Collection<String>> myManualWatchRoots;
    public static final String RESET = "(reset)";
    public static final String OTHER = "(other)";
    private volatile Consumer<? super String> myTestNotifier;

    @NotNull
    private static ExecutorService executor() {
        boolean async = RegistryManager.getInstance().is("vfs.filewatcher.works.in.async.way");
        ExecutorService executorService = async ? AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"File Watcher", (int)1) : ConcurrencyUtil.newSameThreadExecutorService();
        if (executorService == null) {
            FileWatcher.$$$reportNull$$$0(0);
        }
        return executorService;
    }

    FileWatcher(@NotNull ManagingFS managingFS, @NotNull Runnable postInitCallback) {
        if (managingFS == null) {
            FileWatcher.$$$reportNull$$$0(1);
        }
        if (postInitCallback == null) {
            FileWatcher.$$$reportNull$$$0(2);
        }
        this.myFailureShown = new AtomicBoolean(false);
        this.myFileWatcherExecutor = FileWatcher.executor();
        this.myLastTask = new AtomicReference<Object>(null);
        this.myPathMap = CanonicalPathMap.empty();
        this.myManualWatchRoots = Collections.emptyList();
        this.myManagingFS = managingFS;
        this.myNotificationSink = new MyFileWatcherNotificationSink();
        this.myFileWatcherExecutor.execute(() -> {
            PluggableFileWatcher.EP_NAME.forEachExtensionSafe(watcher -> watcher.initialize(this.myManagingFS, (FileWatcherNotificationSink)this.myNotificationSink));
            if (this.isOperational()) {
                postInitCallback.run();
            }
        });
    }

    public void dispose() {
        this.myFileWatcherExecutor.shutdown();
        Future<?> lastTask = this.myLastTask.get();
        if (lastTask != null) {
            lastTask.cancel(false);
        }
        try {
            this.myFileWatcherExecutor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        PluggableFileWatcher.EP_NAME.forEachExtensionSafe(watcher -> watcher.dispose());
    }

    public boolean isOperational() {
        for (PluggableFileWatcher watcher : PluggableFileWatcher.EP_NAME.getIterable()) {
            if (!watcher.isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean isSettingRoots() {
        Future<?> lastTask = this.myLastTask.get();
        if (lastTask != null && !lastTask.isDone()) {
            return true;
        }
        for (PluggableFileWatcher watcher : PluggableFileWatcher.EP_NAME.getIterable()) {
            if (!watcher.isSettingRoots()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    DirtyPaths getDirtyPaths() {
        DirtyPaths dirtyPaths = this.myNotificationSink.getDirtyPaths();
        if (dirtyPaths == null) {
            FileWatcher.$$$reportNull$$$0(3);
        }
        return dirtyPaths;
    }

    @NotNull
    public @NotNull Collection<@NotNull String> getManualWatchRoots() {
        List<Collection<String>> manualWatchRoots = this.myManualWatchRoots;
        Collection<String> result2 = null;
        for (Collection<String> roots : manualWatchRoots) {
            if (result2 == null) {
                result2 = new HashSet<String>(roots);
                continue;
            }
            result2.retainAll(roots);
        }
        Collection<String> collection = result2 != null ? result2 : Collections.emptyList();
        if (collection == null) {
            FileWatcher.$$$reportNull$$$0(4);
        }
        return collection;
    }

    void setWatchRoots(@NotNull Supplier<CanonicalPathMap> pathMapSupplier) {
        Future<?> prevTask;
        if (pathMapSupplier == null) {
            FileWatcher.$$$reportNull$$$0(5);
        }
        if ((prevTask = this.myLastTask.getAndSet(this.myFileWatcherExecutor.submit(() -> {
            try {
                CanonicalPathMap pathMap = (CanonicalPathMap)pathMapSupplier.get();
                if (pathMap == null) {
                    return;
                }
                this.myPathMap = pathMap;
                this.myManualWatchRoots = ContainerUtil.createLockFreeCopyOnWriteList();
                Pair<List<String>, List<String>> roots = pathMap.getCanonicalWatchRoots();
                PluggableFileWatcher.EP_NAME.forEachExtensionSafe(watcher -> watcher.setWatchRoots((List)roots.first, (List)roots.second));
            }
            catch (Error | RuntimeException e) {
                LOG.error(e);
            }
        }))) != null) {
            prevTask.cancel(false);
        }
    }

    public void notifyOnFailure(@NotNull String cause, @Nullable NotificationListener listener2) {
        if (cause == null) {
            FileWatcher.$$$reportNull$$$0(6);
        }
        LOG.warn(cause);
        if (this.myFailureShown.compareAndSet(false, true)) {
            NotificationGroup group = (NotificationGroup)NOTIFICATION_GROUP.getValue();
            String title = ApplicationBundle.message((String)"watcher.slow.sync", (Object[])new Object[0]);
            ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)group.createNotification(title, cause, NotificationType.WARNING, listener2)), ModalityState.NON_MODAL);
        }
    }

    boolean belongsToWatchRoots(@NotNull String reportedPath, boolean isFile) {
        if (reportedPath == null) {
            FileWatcher.$$$reportNull$$$0(7);
        }
        return this.myPathMap.belongsToWatchRoots(reportedPath, isFile);
    }

    @NotNull
    @NotNull Collection<@NotNull String> mapToAllSymlinks(@NotNull String reportedPath) {
        Collection<String> result2;
        if (reportedPath == null) {
            FileWatcher.$$$reportNull$$$0(8);
        }
        if (!(result2 = this.myPathMap.mapToOriginalWatchRoots(reportedPath, true)).isEmpty()) {
            result2.remove(reportedPath);
        }
        Collection<String> collection = result2;
        if (collection == null) {
            FileWatcher.$$$reportNull$$$0(9);
        }
        return collection;
    }

    private void notifyOnEvent(String path) {
        Consumer<? super String> notifier = this.myTestNotifier;
        if (notifier != null) {
            notifier.accept(path);
        }
    }

    public void startup(@Nullable Consumer<? super String> notifier) throws Exception {
        this.myTestNotifier = notifier;
        this.myFileWatcherExecutor.submit(() -> {
            for (PluggableFileWatcher watcher : PluggableFileWatcher.EP_NAME.getIterable()) {
                watcher.startup();
            }
            return null;
        }).get();
    }

    public void shutdown() throws Exception {
        this.myFileWatcherExecutor.submit(() -> {
            for (PluggableFileWatcher watcher : PluggableFileWatcher.EP_NAME.getIterable()) {
                watcher.shutdown();
            }
            this.myTestNotifier = null;
            return null;
        }).get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/FileWatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managingFS";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postInitCallback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapSupplier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "executor";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/FileWatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyPaths";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getManualWatchRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToAllSymlinks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setWatchRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnFailure";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "belongsToWatchRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mapToAllSymlinks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyFileWatcherNotificationSink
    implements FileWatcherNotificationSink {
        private final Object myLock = new Object();
        private DirtyPaths myDirtyPaths = new DirtyPaths();

        private MyFileWatcherNotificationSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        DirtyPaths getDirtyPaths() {
            DirtyPaths dirtyPaths = DirtyPaths.EMPTY;
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myDirtyPaths.isEmpty()) {
                    dirtyPaths = this.myDirtyPaths;
                    this.myDirtyPaths = new DirtyPaths();
                }
            }
            PluggableFileWatcher.EP_NAME.forEachExtensionSafe(watcher -> watcher.resetChangedPaths());
            DirtyPaths dirtyPaths2 = dirtyPaths;
            if (dirtyPaths2 == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(0);
            }
            return dirtyPaths2;
        }

        public void notifyManualWatchRoots(@NotNull Collection<String> roots) {
            if (roots == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(1);
            }
            FileWatcher.this.myManualWatchRoots.add(roots.isEmpty() ? Collections.emptySet() : new HashSet<String>(roots));
            FileWatcher.this.notifyOnEvent(FileWatcher.OTHER);
        }

        public void notifyMapping(@NotNull Collection<? extends Pair<String, String>> mapping2) {
            if (mapping2 == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(2);
            }
            if (!mapping2.isEmpty()) {
                FileWatcher.this.myPathMap.addMapping(mapping2);
            }
            FileWatcher.this.notifyOnEvent(FileWatcher.OTHER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPath(@NotNull String path) {
            Collection<String> paths;
            if (path == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(3);
            }
            if (!(paths = FileWatcher.this.myPathMap.mapToOriginalWatchRoots(path, true)).isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String eachPath : paths) {
                        this.myDirtyPaths.addDirtyPath(eachPath);
                    }
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyPathCreatedOrDeleted(@NotNull String path) {
            Collection<String> paths;
            if (path == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(4);
            }
            if (!(paths = FileWatcher.this.myPathMap.mapToOriginalWatchRoots(path, true)).isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String p : paths) {
                        this.myDirtyPaths.addDirtyPathRecursive(p);
                        String parentPath = new File(p).getParent();
                        if (parentPath == null) continue;
                        this.myDirtyPaths.addDirtyPath(parentPath);
                    }
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyDirectory(@NotNull String path) {
            Collection<String> paths;
            if (path == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(5);
            }
            if (!(paths = FileWatcher.this.myPathMap.mapToOriginalWatchRoots(path, false)).isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.dirtyDirectories.addAll(paths);
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPathRecursive(@NotNull String path) {
            Collection<String> paths;
            if (path == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(6);
            }
            if (!(paths = FileWatcher.this.myPathMap.mapToOriginalWatchRoots(path, false)).isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String each : paths) {
                        this.myDirtyPaths.addDirtyPathRecursive(each);
                    }
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyReset(@Nullable String path) {
            if (path != null) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.addDirtyPathRecursive(path);
                }
            }
            VirtualFile[] roots = FileWatcher.this.myManagingFS.getLocalRoots();
            Object object = this.myLock;
            synchronized (object) {
                for (VirtualFile root : roots) {
                    this.myDirtyPaths.addDirtyPathRecursive(root.getPresentableUrl());
                }
            }
            FileWatcher.this.notifyOnEvent(FileWatcher.RESET);
        }

        public void notifyUserOnFailure(@NotNull String cause, @Nullable NotificationListener listener2) {
            if (cause == null) {
                MyFileWatcherNotificationSink.$$$reportNull$$$0(7);
            }
            FileWatcher.this.notifyOnFailure(cause, listener2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/local/FileWatcher$MyFileWatcherNotificationSink";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirtyPaths";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/local/FileWatcher$MyFileWatcherNotificationSink";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyManualWatchRoots";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyMapping";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyDirtyPath";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyPathCreatedOrDeleted";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyDirtyDirectory";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyDirtyPathRecursive";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyUserOnFailure";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class DirtyPaths {
        final Set<String> dirtyPaths = new THashSet();
        final Set<String> dirtyPathsRecursive = new THashSet();
        final Set<String> dirtyDirectories = new THashSet();
        static final DirtyPaths EMPTY = new DirtyPaths();

        DirtyPaths() {
        }

        boolean isEmpty() {
            return this.dirtyPaths.isEmpty() && this.dirtyPathsRecursive.isEmpty() && this.dirtyDirectories.isEmpty();
        }

        void addDirtyPath(String path) {
            if (!this.dirtyPathsRecursive.contains(path)) {
                this.dirtyPaths.add(path);
            }
        }

        void addDirtyPathRecursive(String path) {
            this.dirtyPaths.remove(path);
            this.dirtyPathsRecursive.add(path);
        }
    }
}

