/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.ObjectUtils;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

class ListResult {
    private final int modStamp;
    final List<? extends ChildInfo> children;

    ListResult(@NotNull List<? extends ChildInfo> children2) {
        if (children2 == null) {
            ListResult.$$$reportNull$$$0(0);
        }
        this(FSRecords.getLocalModCount(), children2);
    }

    private ListResult(int modStamp, @NotNull List<? extends ChildInfo> children2) {
        if (children2 == null) {
            ListResult.$$$reportNull$$$0(1);
        }
        this.modStamp = modStamp;
        this.children = children2;
    }

    public String toString() {
        return "modStamp: " + this.modStamp + "; children: " + this.children;
    }

    @Contract(pure=true)
    @NotNull
    ListResult insert(@NotNull ChildInfo child2) {
        if (child2 == null) {
            ListResult.$$$reportNull$$$0(2);
        }
        ArrayList<Object> newChildren = new ArrayList<Object>(this.children.size() + 1);
        int id2 = child2.getId();
        int i2 = ObjectUtils.binarySearch((int)0, (int)this.children.size(), mid -> Integer.compare(this.children.get(mid).getId(), id2));
        if (i2 >= 0) {
            newChildren.addAll(this.children);
            newChildren.set(i2, child2);
        } else {
            int j;
            int toInsert = -i2 - 1;
            for (j = 0; j < toInsert; ++j) {
                newChildren.add(this.children.get(j));
            }
            newChildren.add(child2);
            for (j = toInsert; j < this.children.size(); ++j) {
                newChildren.add(this.children.get(j));
            }
        }
        return new ListResult(this.modStamp, newChildren);
    }

    @Contract(pure=true)
    @NotNull
    ListResult remove(@NotNull ChildInfo child2) {
        int j;
        if (child2 == null) {
            ListResult.$$$reportNull$$$0(3);
        }
        ArrayList<ChildInfo> newChildren = new ArrayList<ChildInfo>(this.children.size() + 1);
        int id2 = child2.getId();
        int toRemove2 = ObjectUtils.binarySearch((int)0, (int)this.children.size(), mid -> Integer.compare(this.children.get(mid).getId(), id2));
        if (toRemove2 < 0) {
            ListResult listResult = this;
            if (listResult == null) {
                ListResult.$$$reportNull$$$0(4);
            }
            return listResult;
        }
        for (j = 0; j < toRemove2; ++j) {
            newChildren.add(this.children.get(j));
        }
        for (j = toRemove2 + 1; j < this.children.size(); ++j) {
            newChildren.add(this.children.get(j));
        }
        return new ListResult(this.modStamp, newChildren);
    }

    @Contract(pure=true)
    @NotNull
    ListResult merge(@NotNull List<? extends ChildInfo> newList, @NotNull TObjectHashingStrategy<? super CharSequence> hashingStrategy) {
        if (newList == null) {
            ListResult.$$$reportNull$$$0(5);
        }
        if (hashingStrategy == null) {
            ListResult.$$$reportNull$$$0(6);
        }
        ListResult newChildren = FSRecords.mergeByName(this, new ListResult(newList), hashingStrategy);
        return new ListResult(this.modStamp, newChildren.children);
    }

    @Contract(pure=true)
    @NotNull
    ListResult subtract(@NotNull List<? extends ChildInfo> list2) {
        if (list2 == null) {
            ListResult.$$$reportNull$$$0(7);
        }
        ArrayList<ChildInfo> newChildren = new ArrayList<ChildInfo>(this.children.size() + list2.size());
        int index1 = 0;
        int index2 = 0;
        while (index1 < this.children.size() && index2 < list2.size()) {
            ChildInfo element2;
            ChildInfo element1 = this.children.get(index1);
            int c = ChildInfo.BY_ID.compare(element1, element2 = list2.get(index2));
            if (c == 0) {
                ++index1;
                ++index2;
                continue;
            }
            if (c < 0) {
                newChildren.add(element1);
                ++index1;
                continue;
            }
            ++index2;
        }
        for (int i2 = index1; i2 < this.children.size(); ++i2) {
            newChildren.add(this.children.get(i2));
        }
        return new ListResult(this.modStamp, newChildren);
    }

    boolean childrenWereChangedSinceLastList() {
        return this.modStamp != FSRecords.getLocalModCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/ListResult";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/ListResult";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

