/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializationManager;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexKeyDescriptorCache;
import com.intellij.psi.stubs.StubProcessingHelper;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IdIterator;
import com.intellij.util.indexing.IndexAccessValidator;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexVersionRegistrationSink;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.indexing.impl.storage.TransientChangesIndexStorage;
import com.intellij.util.indexing.impl.storage.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.memory.InMemoryIndexStorage;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubIndexImpl
extends StubIndexEx {
    private static final AtomicReference<Boolean> ourForcedClean = new AtomicReference<Object>(null);
    static final Logger LOG = Logger.getInstance(StubIndexImpl.class);
    private final Map<StubIndexKey<?, ?>, CachedValue<Map<CompositeKey<?>, StubIdList>>> myCachedStubIds = FactoryMap.createMap(k -> {
        UpdatableIndex<Integer, SerializedStubTree, FileContent> index = StubIndexImpl.getStubUpdatingIndex();
        ModificationTracker tracker = index::getModificationStamp;
        return new CachedValueImpl(() -> new CachedValueProvider.Result(new ConcurrentHashMap(), new Object[]{tracker}));
    }, ConcurrentHashMap::new);
    private final StubProcessingHelper myStubProcessingHelper = new StubProcessingHelper();
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();
    private volatile CompletableFuture<AsyncState> myStateFuture;
    private volatile AsyncState myState;
    private volatile boolean myInitialized;

    public StubIndexImpl() {
        StubIndexExtension.EP_NAME.addExtensionPointListener(new ExtensionPointListener<StubIndexExtension<?, ?>>(){

            public void extensionRemoved(@NotNull StubIndexExtension<?, ?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ID.unloadId((ID)extension.getKey());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/stubs/StubIndexImpl$1";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    @Nullable
    static StubIndexImpl getInstanceOrInvalidate() {
        if (ourForcedClean.compareAndSet(null, Boolean.TRUE)) {
            return null;
        }
        return (StubIndexImpl)StubIndexImpl.getInstance();
    }

    private AsyncState getAsyncState() {
        AsyncState state = this.myState;
        if (state == null) {
            if (this.myStateFuture == null) {
                ((FileBasedIndexImpl)FileBasedIndex.getInstance()).waitUntilIndicesAreInitialized();
            }
            this.myState = state = ProgressIndicatorUtils.awaitWithCheckCanceled(this.myStateFuture);
        }
        return state;
    }

    @NotNull
    public static <K> FileBasedIndexExtension<K, Void> wrapStubIndexExtension(final StubIndexExtension<K, ?> extension) {
        return new FileBasedIndexExtension<K, Void>(){

            @NotNull
            public ID<K, Void> getName() {
                StubIndexKey stubIndexKey = extension.getKey();
                if (stubIndexKey == null) {
                    2.$$$reportNull$$$0(0);
                }
                return stubIndexKey;
            }

            @NotNull
            public FileBasedIndex.InputFilter getInputFilter() {
                FileBasedIndex.InputFilter inputFilter = f -> {
                    throw new UnsupportedOperationException();
                };
                if (inputFilter == null) {
                    2.$$$reportNull$$$0(1);
                }
                return inputFilter;
            }

            public boolean dependsOnFileContent() {
                return true;
            }

            public boolean needsForwardIndexWhenSharing() {
                return false;
            }

            @NotNull
            public DataIndexer<K, Void, FileContent> getIndexer() {
                DataIndexer dataIndexer = i2 -> {
                    throw new AssertionError();
                };
                if (dataIndexer == null) {
                    2.$$$reportNull$$$0(2);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<K> getKeyDescriptor() {
                KeyDescriptor keyDescriptor = extension.getKeyDescriptor();
                if (keyDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                return keyDescriptor;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
                if (voidDataExternalizer == null) {
                    2.$$$reportNull$$$0(4);
                }
                return voidDataExternalizer;
            }

            public int getVersion() {
                return extension.getVersion();
            }

            public boolean traceKeyHashToVirtualFileMapping() {
                return extension instanceof StringStubIndexExtension && ((StringStubIndexExtension)extension).traceKeyHashToVirtualFileMapping();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/stubs/StubIndexImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInputFilter";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K> void registerIndexer(@NotNull StubIndexExtension<K, ?> extension, boolean forceClean, @NotNull AsyncState state, @NotNull IndexVersionRegistrationSink registrationResultSink) throws IOException {
        if (extension == null) {
            StubIndexImpl.$$$reportNull$$$0(0);
        }
        if (state == null) {
            StubIndexImpl.$$$reportNull$$$0(1);
        }
        if (registrationResultSink == null) {
            StubIndexImpl.$$$reportNull$$$0(2);
        }
        StubIndexKey indexKey = extension.getKey();
        int version2 = extension.getVersion();
        FileBasedIndexExtension<K, Void> wrappedExtension = StubIndexImpl.wrapStubIndexExtension(extension);
        AsyncState asyncState = state;
        synchronized (asyncState) {
            state.myIndexIdToVersionMap.put((Object)indexKey, version2);
        }
        File indexRootDir = IndexInfrastructure.getIndexRootDir(indexKey);
        IndexingStamp.IndexVersionDiff versionDiff = forceClean ? new IndexingStamp.IndexVersionDiff.InitialBuild(version2) : IndexingStamp.versionDiffers(indexKey, version2);
        registrationResultSink.setIndexVersionDiff(indexKey, versionDiff);
        if (versionDiff != IndexingStamp.IndexVersionDiff.UP_TO_DATE) {
            boolean needRebuild;
            File versionFile = IndexInfrastructure.getVersionFile(indexKey);
            boolean versionFileExisted = versionFile.exists();
            String[] children2 = indexRootDir.list();
            boolean indexRootHasChildren = children2 != null && children2.length > 0;
            boolean bl = needRebuild = !forceClean && (versionFileExisted || indexRootHasChildren);
            if (indexRootHasChildren) {
                FileUtil.deleteWithRenaming((File)indexRootDir);
            }
            IndexingStamp.rewriteVersion(indexKey, version2);
            try {
                if (needRebuild) {
                    for (FileBasedIndexInfrastructureExtension ex : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                        ex.onStubIndexVersionChanged(indexKey);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex = StubIndexImpl.getStubUpdatingIndex();
        ReadWriteLock lock = stubUpdatingIndex.getLock();
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                VfsAwareIndexStorage<Object, Object> storage = FileBasedIndex.USE_IN_MEMORY_INDEX ? new InMemoryIndexStorage() : new VfsAwareMapIndexStorage(IndexInfrastructure.getStorageFile(indexKey).toPath(), wrappedExtension.getKeyDescriptor(), wrappedExtension.getValueExternalizer(), wrappedExtension.getCacheSize(), wrappedExtension.keyIsUniqueForIndexedFile(), wrappedExtension.traceKeyHashToVirtualFileMapping());
                TransientChangesIndexStorage memStorage = new TransientChangesIndexStorage(storage, (ID<?, ?>)indexKey);
                UpdatableIndex<Object, Object, FileContent> index = new VfsAwareMapReduceIndex(wrappedExtension, memStorage, null, null, null, lock);
                for (FileBasedIndexInfrastructureExtension infrastructureExtension : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    UpdatableIndex<K, Void, FileContent> intermediateIndex = infrastructureExtension.combineIndex(wrappedExtension, index);
                    if (intermediateIndex == null) continue;
                    index = intermediateIndex;
                }
                AsyncState asyncState2 = state;
                synchronized (asyncState2) {
                    state.myIndices.put(indexKey, index);
                    break;
                }
            }
            catch (IOException e) {
                registrationResultSink.setIndexVersionDiff(indexKey, new IndexingStamp.IndexVersionDiff.CorruptedRebuild(version2));
                StubIndexImpl.onExceptionInstantiatingIndex(indexKey, version2, indexRootDir, e);
                continue;
            }
            catch (RuntimeException e) {
                Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
                if (cause == null) {
                    throw e;
                }
                StubIndexImpl.onExceptionInstantiatingIndex(indexKey, version2, indexRootDir, e);
            }
        }
    }

    private static <K> void onExceptionInstantiatingIndex(@NotNull StubIndexKey<K, ?> indexKey, int version2, @NotNull File indexRootDir, @NotNull Exception e) throws IOException {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(3);
        }
        if (indexRootDir == null) {
            StubIndexImpl.$$$reportNull$$$0(4);
        }
        if (e == null) {
            StubIndexImpl.$$$reportNull$$$0(5);
        }
        LOG.info((Throwable)e);
        FileUtil.deleteWithRenaming((File)indexRootDir);
        IndexingStamp.rewriteVersion(indexKey, version2);
    }

    public long getIndexModificationStamp(@NotNull StubIndexKey<?, ?> indexId, @NotNull Project project) {
        UpdatableIndex index;
        if (indexId == null) {
            StubIndexImpl.$$$reportNull$$$0(6);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(7);
        }
        if ((index = (UpdatableIndex)this.getAsyncState().myIndices.get(indexId)) != null) {
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, GlobalSearchScope.allScope((Project)project));
            return index.getModificationStamp();
        }
        return -1L;
    }

    public void flush() throws StorageException {
        if (!this.myInitialized) {
            return;
        }
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            index.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull Class<Psi> requiredClass, @NotNull Processor<? super Psi> processor2) {
        block16: {
            PairProcessor stubProcessor;
            DumbModeAccessType accessType;
            boolean dumb;
            if (indexKey == null) {
                StubIndexImpl.$$$reportNull$$$0(8);
            }
            if (key == null) {
                StubIndexImpl.$$$reportNull$$$0(9);
            }
            if (project == null) {
                StubIndexImpl.$$$reportNull$$$0(10);
            }
            if (requiredClass == null) {
                StubIndexImpl.$$$reportNull$$$0(11);
            }
            if (processor2 == null) {
                StubIndexImpl.$$$reportNull$$$0(12);
            }
            if ((dumb = DumbService.isDumb((Project)project)) && (accessType = FileBasedIndex.getInstance().getCurrentDumbModeAccessType()) == DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE) {
                throw new AssertionError((Object)"raw index data access is not available for StubIndex");
            }
            if (!ModelBranchImpl.processBranchedFilesInScope((GlobalSearchScope)(scope != null ? scope : new EverythingGlobalScope(project)), (Processor<? super VirtualFile>)((Processor)arg_0 -> StubIndexImpl.lambda$processElements$3(indexKey, key, project, stubProcessor = (file2, list2) -> this.myStubProcessingHelper.processStubsInFile(project, (VirtualFile)file2, (StubIdList)list2, processor2, scope, requiredClass), arg_0)))) {
                return false;
            }
            IdIterator ids = this.getContainingIds(indexKey, key, project, idFilter, scope);
            PersistentFS fs = PersistentFS.getInstance();
            IntPredicate accessibleFileFilter = ((FileBasedIndexEx)FileBasedIndex.getInstance()).getAccessibleFileIdFilter(project);
            try {
                while (ids.hasNext()) {
                    VirtualFile file3;
                    int id2 = ids.next();
                    ProgressManager.checkCanceled();
                    if (!accessibleFileFilter.test(id2) || (file3 = IndexInfrastructure.findFileByIdIfCached(fs, id2)) == null || scope != null && !scope.contains(file3)) continue;
                    StubIdList list3 = ((Map)this.myCachedStubIds.get(indexKey).getValue()).computeIfAbsent(new CompositeKey(key, id2), __ -> this.myStubProcessingHelper.retrieveStubIdList(indexKey, key, file3, project));
                    if (list3 == null) {
                        LOG.error("StubUpdatingIndex & " + indexKey + " stub index mismatch. No stub index key is present");
                        continue;
                    }
                    if (stubProcessor.process((Object)file3, (Object)list3)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (RuntimeException e) {
                Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
                if (cause != null) {
                    this.forceRebuild(cause);
                    break block16;
                }
                throw e;
            }
            finally {
                this.wipeProblematicFileIdsForParticularKeyAndStubIndex(indexKey, key);
            }
        }
        return true;
    }

    private static <Key, Psi extends PsiElement> boolean processInMemoryStubs(StubIndexKey<Key, Psi> indexKey, Key key, Project project, PairProcessor<VirtualFile, StubIdList> stubProcessor, VirtualFile file2) {
        Map data2 = FileBasedIndex.getInstance().getFileData(StubUpdatingIndex.INDEX_ID, file2, project);
        if (data2.size() == 1) {
            try {
                StubIdList list2 = ((SerializedStubTree)data2.values().iterator().next()).restoreIndexedStubs(indexKey, key);
                if (list2 != null) {
                    return stubProcessor.process((Object)file2, (Object)list2);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private <Key> UpdatableIndex<Key, Void, FileContent> getIndex(@NotNull StubIndexKey<Key, ?> indexKey) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(13);
        }
        return (UpdatableIndex)this.getAsyncState().myIndices.get(indexKey);
    }

    private <Key> void wipeProblematicFileIdsForParticularKeyAndStubIndex(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key key) {
        Set<VirtualFile> filesWithProblems;
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(14);
        }
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(15);
        }
        if ((filesWithProblems = this.myStubProcessingHelper.takeAccumulatedFilesWithIndexProblems()) != null) {
            LOG.info("data for " + indexKey.getName() + " will be wiped for a some files because of internal stub processing error");
            ((FileBasedIndexImpl)FileBasedIndex.getInstance()).runCleanupAction(() -> {
                Lock writeLock = this.getIndex(indexKey).getLock().writeLock();
                boolean locked = writeLock.tryLock();
                if (!locked) {
                    return;
                }
                try {
                    for (VirtualFile file2 : filesWithProblems) {
                        this.updateIndex(indexKey, FileBasedIndex.getFileId((VirtualFile)file2), Collections.singleton(key), Collections.emptySet());
                    }
                }
                finally {
                    writeLock.unlock();
                }
            });
        }
    }

    public void forceRebuild(@NotNull Throwable e) {
        if (e == null) {
            StubIndexImpl.$$$reportNull$$$0(16);
        }
        FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, e);
    }

    private static void requestRebuild() {
        FileBasedIndex.getInstance().requestRebuild(StubUpdatingIndex.INDEX_ID);
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(17);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(18);
        }
        THashSet allKeys = new THashSet();
        this.processAllKeys(indexKey, project, Processors.cancelableCollectProcessor((Collection)allKeys));
        THashSet tHashSet = allKeys;
        if (tHashSet == null) {
            StubIndexImpl.$$$reportNull$$$0(19);
        }
        return tHashSet;
    }

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Processor<? super K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        UpdatableIndex index;
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(20);
        }
        if (processor2 == null) {
            StubIndexImpl.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            StubIndexImpl.$$$reportNull$$$0(22);
        }
        if ((index = this.getIndex(indexKey)) == null || !((FileBasedIndexEx)FileBasedIndex.getInstance()).ensureUpToDate(StubUpdatingIndex.INDEX_ID, scope.getProject(), scope, null)) {
            return true;
        }
        try {
            return (Boolean)this.myAccessValidator.validate(StubUpdatingIndex.INDEX_ID, () -> (Boolean)FileBasedIndexImpl.disableUpToDateCheckIn(() -> index.processAllKeys(processor2, scope, idFilter)));
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException || cause instanceof StorageException) {
                this.forceRebuild(e);
            }
            throw e;
        }
        return true;
    }

    @NotNull
    public <Key> IdIterator getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @Nullable GlobalSearchScope scope) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(23);
        }
        if (dataKey == null) {
            StubIndexImpl.$$$reportNull$$$0(24);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(25);
        }
        return this.getContainingIds(indexKey, dataKey, project, null, scope);
    }

    @NotNull
    private <Key> IdIterator getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @Nullable IdFilter idFilter, @Nullable GlobalSearchScope scope) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(26);
        }
        if (dataKey == null) {
            StubIndexImpl.$$$reportNull$$$0(27);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(28);
        }
        FileBasedIndexEx fileBasedIndex = (FileBasedIndexEx)FileBasedIndex.getInstance();
        ID<Integer, SerializedStubTree> stubUpdatingIndexId = StubUpdatingIndex.INDEX_ID;
        UpdatableIndex index = this.getIndex(indexKey);
        if (index == null || !fileBasedIndex.ensureUpToDate(stubUpdatingIndexId, project, scope, null)) {
            IdIterator idIterator = IdIterator.EMPTY;
            if (idIterator == null) {
                StubIndexImpl.$$$reportNull$$$0(29);
            }
            return idIterator;
        }
        if (idFilter == null) {
            idFilter = ((FileBasedIndexEx)FileBasedIndex.getInstance()).projectIndexableFiles(project);
        }
        UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex = fileBasedIndex.getIndex(stubUpdatingIndexId);
        try {
            final TIntArrayList result2 = new TIntArrayList();
            IdFilter finalIdFilter = idFilter;
            this.myAccessValidator.validate(stubUpdatingIndexId, () -> (Boolean)FileBasedIndexImpl.disableUpToDateCheckIn(() -> (Boolean)ConcurrencyUtil.withLock((Lock)stubUpdatingIndex.getLock().readLock(), () -> index.getData(dataKey).forEach((id2, value2) -> {
                if (finalIdFilter == null || finalIdFilter.containsFileId(id2)) {
                    result2.add(id2);
                }
                return true;
            }))));
            return new IdIterator(){
                int cursor;

                public boolean hasNext() {
                    return this.cursor < result2.size();
                }

                public int next() {
                    return result2.get(this.cursor++);
                }

                public int size() {
                    return result2.size();
                }
            };
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause != null) {
                this.forceRebuild(cause);
            }
            throw e;
        }
        IdIterator idIterator = IdIterator.EMPTY;
        if (idIterator == null) {
            StubIndexImpl.$$$reportNull$$$0(30);
        }
        return idIterator;
    }

    void initializeStubIndexes() {
        assert (!this.myInitialized);
        FileBasedIndex.getInstance();
        this.myStateFuture = new CompletableFuture();
        Future<AsyncState> future2 = IndexInfrastructure.submitGenesisTask(new StubIndexInitialization());
        if (!IndexInfrastructure.ourDoAsyncIndicesInitialization) {
            try {
                future2.get();
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }

    public void dispose() {
        try {
            for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
                index.dispose();
            }
        }
        finally {
            this.clearState();
        }
    }

    private void clearState() {
        StubIndexKeyDescriptorCache.INSTANCE.clear();
        ((SerializationManagerImpl)SerializationManager.getInstance()).dropSerializerData();
        this.myCachedStubIds.clear();
        this.myStateFuture = null;
        this.myState = null;
        this.myInitialized = false;
        LOG.info("StubIndexExtension-s were unloaded");
    }

    void setDataBufferingEnabled(boolean enabled) {
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            index.setBufferingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupMemoryStorage() {
        UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex = StubIndexImpl.getStubUpdatingIndex();
        stubUpdatingIndex.getLock().writeLock().lock();
        try {
            for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
                index.cleanupMemoryStorage();
            }
        }
        finally {
            stubUpdatingIndex.getLock().writeLock().unlock();
        }
    }

    void clearAllIndices() {
        if (!this.myInitialized) {
            return;
        }
        for (UpdatableIndex index : this.getAsyncState().myIndices.values()) {
            try {
                index.clear();
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    <K> void removeTransientDataForFile(@NotNull StubIndexKey<K, ?> key, int inputId, @NotNull Collection<? extends K> keys2) {
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(31);
        }
        if (keys2 == null) {
            StubIndexImpl.$$$reportNull$$$0(32);
        }
        UpdatableIndex<K, Void, FileContent> index = this.getIndex(key);
        index.removeTransientDataForKeys(inputId, keys2);
    }

    public <K> void updateIndex(@NotNull StubIndexKey<K, ?> stubIndexKey, final int fileId, final @NotNull Set<K> oldKeys, final @NotNull Set<K> newKeys) {
        if (stubIndexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(33);
        }
        if (oldKeys == null) {
            StubIndexImpl.$$$reportNull$$$0(34);
        }
        if (newKeys == null) {
            StubIndexImpl.$$$reportNull$$$0(35);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            try {
                UpdatableIndex index;
                if (FileBasedIndexImpl.DO_TRACE_STUB_INDEX_UPDATE) {
                    LOG.info("stub index '" + stubIndexKey + "' update: " + fileId + " old = " + Arrays.toString(oldKeys.toArray()) + " new  = " + Arrays.toString(newKeys.toArray()) + " updated_id = " + System.identityHashCode(newKeys));
                }
                if ((index = this.getIndex(stubIndexKey)) == null) {
                    return;
                }
                index.updateWithMap(new AbstractUpdateData<K, Void>(fileId){

                    protected boolean iterateKeys(@NotNull KeyValueUpdateProcessor<? super K, ? super Void> addProcessor, @NotNull KeyValueUpdateProcessor<? super K, ? super Void> updateProcessor, @NotNull RemovedKeyProcessor<? super K> removeProcessor) throws StorageException {
                        if (addProcessor == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        if (updateProcessor == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        if (removeProcessor == null) {
                            4.$$$reportNull$$$0(2);
                        }
                        if (FileBasedIndexImpl.DO_TRACE_STUB_INDEX_UPDATE) {
                            LOG.info("iterating keys updated_id = " + System.identityHashCode(newKeys));
                        }
                        boolean modified = false;
                        for (Object oldKey : oldKeys) {
                            if (newKeys.contains(oldKey)) continue;
                            removeProcessor.process(oldKey, fileId);
                            if (modified) continue;
                            modified = true;
                        }
                        for (Object oldKey : newKeys) {
                            if (oldKeys.contains(oldKey)) continue;
                            addProcessor.process(oldKey, null, fileId);
                            if (modified) continue;
                            modified = true;
                        }
                        if (FileBasedIndexImpl.DO_TRACE_STUB_INDEX_UPDATE) {
                            LOG.info("keys iteration finished updated_id = " + System.identityHashCode(newKeys) + "; modified = " + modified);
                        }
                        return modified;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "addProcessor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "updateProcessor";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "removeProcessor";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/psi/stubs/StubIndexImpl$4";
                        objectArray[2] = "iterateKeys";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            catch (StorageException e) {
                LOG.info((Throwable)e);
                StubIndexImpl.requestRebuild();
            }
        });
    }

    static UpdatableIndex<Integer, SerializedStubTree, FileContent> getStubUpdatingIndex() {
        return ((FileBasedIndexEx)FileBasedIndex.getInstance()).getIndex(StubUpdatingIndex.INDEX_ID);
    }

    public boolean areAllProblemsProcessedInTheCurrentThread() {
        return this.myStubProcessingHelper.areAllProblemsProcessedInTheCurrentThread();
    }

    private static /* synthetic */ boolean lambda$processElements$3(StubIndexKey indexKey, Object key, Project project, PairProcessor stubProcessor, VirtualFile file2) {
        return StubIndexImpl.processInMemoryStubs(indexKey, key, project, (PairProcessor<VirtualFile, StubIdList>)stubProcessor, file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrationResultSink";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexRootDir";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 15: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClass";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubIndexImpl";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexKey";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldKeys";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubIndexImpl";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexer";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onExceptionInstantiatingIndex";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIndexModificationStamp";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "wipeProblematicFileIdsForParticularKeyAndStubIndex";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "forceRebuild";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
            case 19: 
            case 29: 
            case 30: {
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getContainingIds";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForFile";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CompositeKey<K> {
        private final K key;
        private final int fileId;

        private CompositeKey(K key, int id2) {
            this.key = key;
            this.fileId = id2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKey key1 = (CompositeKey)o;
            return this.fileId == key1.fileId && Objects.equals(this.key, key1.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.fileId);
        }
    }

    private class StubIndexInitialization
    extends IndexInfrastructure.DataInitialization<AsyncState> {
        private final AsyncState state = new AsyncState();
        private final IndexVersionRegistrationSink indicesRegistrationSink = new IndexVersionRegistrationSink();

        private StubIndexInitialization() {
        }

        @Override
        protected void prepare() {
            StubIndexExtension extension;
            boolean forceClean;
            Iterator extensionsIterator = IndexInfrastructure.hasIndices() ? ((ExtensionPointImpl)StubIndexExtension.EP_NAME.getPoint()).iterator() : Collections.emptyIterator();
            boolean bl = forceClean = Boolean.TRUE == ourForcedClean.getAndSet(Boolean.FALSE);
            while (extensionsIterator.hasNext() && (extension = (StubIndexExtension)extensionsIterator.next()) != null) {
                extension.getKey();
                this.addNestedInitializationTask(() -> StubIndexImpl.registerIndexer(extension, forceClean, this.state, this.indicesRegistrationSink));
            }
        }

        @Override
        protected void onThrowable(@NotNull Throwable t) {
            if (t == null) {
                StubIndexInitialization.$$$reportNull$$$0(0);
            }
            LOG.error(t);
        }

        @Override
        protected AsyncState finish() {
            this.indicesRegistrationSink.logChangedAndFullyBuiltIndices(LOG, "Following stub indices will be updated:", "Following stub indices will be built:");
            if (this.indicesRegistrationSink.hasChangedIndexes()) {
                Throwable e = new Throwable(this.indicesRegistrationSink.changedIndices());
                AppUIExecutor.onWriteThread((ModalityState)ModalityState.NON_MODAL).later().submit(() -> StubIndexImpl.this.forceRebuild(e));
            }
            StubIndexImpl.this.myInitialized = true;
            StubIndexImpl.this.myStateFuture.complete(this.state);
            return this.state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/stubs/StubIndexImpl$StubIndexInitialization", "onThrowable"));
        }
    }

    private static final class AsyncState {
        private final Map<StubIndexKey<?, ?>, UpdatableIndex<?, Void, FileContent>> myIndices = new THashMap();
        private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap = new TObjectIntHashMap();

        private AsyncState() {
        }
    }
}

