/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.SmartList;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class MapDataExternalizer<Key, Value>
implements DataExternalizer<Map<Key, Value>> {
    private final DataExternalizer<Value> myValueExternalizer;
    private final DataExternalizer<Collection<Key>> myKeysExternalizer;

    public MapDataExternalizer(@NotNull DataExternalizer<Value> valueExternalizer, @NotNull DataExternalizer<Collection<Key>> keysExternalizer) {
        if (valueExternalizer == null) {
            MapDataExternalizer.$$$reportNull$$$0(0);
        }
        if (keysExternalizer == null) {
            MapDataExternalizer.$$$reportNull$$$0(1);
        }
        this.myValueExternalizer = valueExternalizer;
        this.myKeysExternalizer = keysExternalizer;
    }

    public void save(@NotNull DataOutput stream, Map<Key, Value> data2) throws IOException {
        if (stream == null) {
            MapDataExternalizer.$$$reportNull$$$0(2);
        }
        int size = data2.size();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)size);
        if (size > 0) {
            THashMap values2 = new THashMap();
            List keysForNullValue = null;
            for (Map.Entry<Key, Value> e : data2.entrySet()) {
                List keys2;
                Value value2 = e.getValue();
                List list2 = keys2 = value2 != null ? (List)values2.get(value2) : keysForNullValue;
                if (keys2 == null) {
                    if (value2 != null) {
                        keys2 = new SmartList();
                        values2.put(value2, (Object)keys2);
                    } else {
                        keys2 = keysForNullValue = new SmartList();
                    }
                }
                keys2.add(e.getKey());
            }
            if (keysForNullValue != null) {
                this.myValueExternalizer.save(stream, null);
                this.myKeysExternalizer.save(stream, keysForNullValue);
            }
            for (Map.Entry<Object, Object> value3 : values2.keySet()) {
                this.myValueExternalizer.save(stream, value3);
                this.myKeysExternalizer.save(stream, (Object)((Collection)values2.get(value3)));
            }
        }
    }

    public Map<Key, Value> read(@NotNull DataInput in) throws IOException {
        int pairs;
        if (in == null) {
            MapDataExternalizer.$$$reportNull$$$0(3);
        }
        if ((pairs = DataInputOutputUtil.readINT((DataInput)in)) == 0) {
            return Collections.emptyMap();
        }
        THashMap result2 = new THashMap(pairs);
        while (((InputStream)((Object)in)).available() > 0) {
            Object value2 = this.myValueExternalizer.read(in);
            Collection keys2 = (Collection)this.myKeysExternalizer.read(in);
            for (Object k : keys2) {
                result2.put(k, value2);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keysExternalizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/MapDataExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

