/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NonProportionalOnePixelSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.frame.StackInfo;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.frame.XDebuggerThreadsList;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.intellij.xdebugger.impl.frame.XThreadsFramesView;
import com.intellij.xdebugger.impl.frame.XThreadsFramesView$sam$com_intellij_util_Function$0;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 ;2\u00020\u0001:\u0005;<=>?B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0006\u00102\u001a\u00020)J\u000e\u00103\u001a\u00020)2\u0006\u00104\u001a\u00020\u0012J\u000e\u00105\u001a\u00020)2\u0006\u00100\u001a\u000201J\u0014\u00106\u001a\u00020)*\u0002072\u0006\u00100\u001a\u000201H\u0002J \u00108\u001a\u00020\n*\u00020\n2\b\b\u0002\u00109\u001a\u00020\u00122\b\b\u0002\u0010:\u001a\u00020\u0012H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006@"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsFramesView;", "Lcom/intellij/xdebugger/impl/frame/XDebugView;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultFocusedComponent", "Ljavax/swing/JComponent;", "getDefaultFocusedComponent", "()Ljavax/swing/JComponent;", "frames", "Lcom/intellij/xdebugger/impl/frame/XDebuggerFramesList;", "getFrames", "()Lcom/intellij/xdebugger/impl/frame/XDebuggerFramesList;", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel", "()Ljavax/swing/JPanel;", "myAlreadyPaused", "", "myFramesList", "myFramesManager", "Lcom/intellij/xdebugger/impl/frame/XThreadsFramesView$FramesManager;", "myFramesPresentationCache", "", "", "", "myListenersEnabled", "myPauseDisposables", "Lcom/intellij/xdebugger/impl/frame/XThreadsFramesView$SequentialDisposables;", "mySplitter", "Lcom/intellij/openapi/ui/NonProportionalOnePixelSplitter;", "myThreadsContainer", "Lcom/intellij/xdebugger/impl/frame/XThreadsFramesView$ThreadsContainer;", "myThreadsList", "Lcom/intellij/xdebugger/impl/frame/XDebuggerThreadsList;", "getProject", "()Lcom/intellij/openapi/project/Project;", "threads", "getThreads", "()Lcom/intellij/xdebugger/impl/frame/XDebuggerThreadsList;", "clear", "", "dispose", "nextDisposable", "Lcom/intellij/openapi/Disposable;", "processSessionEvent", "event", "Lcom/intellij/xdebugger/impl/frame/XDebugView$SessionEvent;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "saveUiState", "setThreadsVisible", "visible", "start", "setActive", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "withSpeedSearch", "shouldMatchFromTheBeginning", "shouldMatchCamelCase", "Companion", "FramesContainer", "FramesManager", "SequentialDisposables", "ThreadsContainer", "intellij.platform.debugger.impl"})
public final class XThreadsFramesView
extends XDebugView {
    private final SequentialDisposables myPauseDisposables;
    private final XDebuggerThreadsList myThreadsList;
    private final XDebuggerFramesList myFramesList;
    private final NonProportionalOnePixelSplitter mySplitter;
    private boolean myListenersEnabled;
    private FramesManager myFramesManager;
    private ThreadsContainer myThreadsContainer;
    private boolean myAlreadyPaused;
    private final Map<Object, String> myFramesPresentationCache;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final JComponent defaultFocusedComponent;
    @NotNull
    private final Project project;
    private static final String splitterProportionKey = "XThreadsFramesViewSplitterKey";
    private static final float splitterProportionDefaultValue = 0.5f;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final XDebuggerThreadsList getThreads() {
        return this.myThreadsList;
    }

    @NotNull
    public final XDebuggerFramesList getFrames() {
        return this.myFramesList;
    }

    @NotNull
    public final JPanel getMainPanel() {
        return this.mainPanel;
    }

    @NotNull
    public final JComponent getDefaultFocusedComponent() {
        return this.defaultFocusedComponent;
    }

    private final XDebuggerFramesList withSpeedSearch(@NotNull XDebuggerFramesList $this$withSpeedSearch, boolean shouldMatchFromTheBeginning, boolean shouldMatchCamelCase) {
        TextTransferable.ColoredStringBuilder coloredStringBuilder = new TextTransferable.ColoredStringBuilder();
        Function1<Object, String> $fun$getPresentation$1 = new Function1<Object, String>(this, $this$withSpeedSearch, coloredStringBuilder){
            final /* synthetic */ XThreadsFramesView this$0;
            final /* synthetic */ XDebuggerFramesList $this_withSpeedSearch;
            final /* synthetic */ TextTransferable.ColoredStringBuilder $coloredStringBuilder;

            @Nullable
            public final String invoke(@Nullable Object element2) {
                Object object;
                if (element2 == null) {
                    return null;
                }
                Map $this$getOrPut$iv = XThreadsFramesView.access$getMyFramesPresentationCache$p(this.this$0);
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(element2);
                if (value$iv == null) {
                    String string;
                    boolean bl = false;
                    Object object2 = element2;
                    if (object2 instanceof XStackFrame) {
                        ((XStackFrame)element2).customizePresentation((ColoredTextContainer)this.$coloredStringBuilder);
                        String string2 = this.$coloredStringBuilder.getBuilder().toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"coloredStringBuilder.builder.toString()");
                        String value2 = string2;
                        StringBuilder stringBuilder = this.$coloredStringBuilder.getBuilder();
                        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"coloredStringBuilder.builder");
                        StringsKt.clear((StringBuilder)stringBuilder);
                        string = value2;
                    } else {
                        String string3 = this.$this_withSpeedSearch.toString();
                        string = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"toString()");
                    }
                    String answer$iv = string;
                    $this$getOrPut$iv.put(element2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                return (String)object;
            }
            {
                this.this$0 = xThreadsFramesView;
                this.$this_withSpeedSearch = xDebuggerFramesList;
                this.$coloredStringBuilder = coloredStringBuilder;
                super(1);
            }
        };
        return (XDebuggerFramesList)((Object)XThreadsFramesView.Companion.withSpeedSearch((JList)((Object)$this$withSpeedSearch), shouldMatchFromTheBeginning, shouldMatchCamelCase, (Function1<Object, String>)((Function1)new Function1<Object, String>($fun$getPresentation$1){
            final /* synthetic */ withSpeedSearch.1 $getPresentation$1;

            @Nullable
            public final String invoke(@Nullable Object p1) {
                return this.$getPresentation$1.invoke(p1);
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "getPresentation";
            }

            public final String getSignature() {
                return "invoke(Ljava/lang/Object;)Ljava/lang/String;";
            }
            {
                this.$getPresentation$1 = var1_1;
                super(1);
            }
        })));
    }

    static /* synthetic */ XDebuggerFramesList withSpeedSearch$default(XThreadsFramesView xThreadsFramesView, XDebuggerFramesList xDebuggerFramesList, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return xThreadsFramesView.withSpeedSearch(xDebuggerFramesList, bl, bl2);
    }

    public final void setThreadsVisible(boolean visible) {
        JComponent jComponent = this.mySplitter.getFirstComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"mySplitter.firstComponent");
        if (jComponent.isVisible() == visible) {
            return;
        }
        JComponent jComponent2 = this.mySplitter.getFirstComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent2, (String)"mySplitter.firstComponent");
        jComponent2.setVisible(visible);
        this.mySplitter.revalidate();
        this.mySplitter.repaint();
    }

    public final void saveUiState() {
        if (this.mySplitter.getWidth() < this.mySplitter.getMinimumSize().width) {
            return;
        }
        this.mySplitter.saveProportion();
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event, @NotNull XDebugSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)event), (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
            return;
        }
        XSuspendContext suspendContext = session2.getSuspendContext();
        if (suspendContext == null) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
                final /* synthetic */ XThreadsFramesView this$0;

                public final void run() {
                    XThreadsFramesView.access$setMyAlreadyPaused$p(this.this$0, false);
                }
                {
                    this.this$0 = xThreadsFramesView;
                }
            });
            this.requestClear();
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, event, session2){
            final /* synthetic */ XThreadsFramesView this$0;
            final /* synthetic */ XDebugView.SessionEvent $event;
            final /* synthetic */ XDebugSession $session;

            public final void run() {
                if (!XThreadsFramesView.access$getMyAlreadyPaused$p(this.this$0) && this.$event == XDebugView.SessionEvent.PAUSED) {
                    XThreadsFramesView.access$setMyAlreadyPaused$p(this.this$0, true);
                    this.this$0.cancelClear();
                    this.this$0.clear();
                    this.this$0.start(this.$session);
                    return;
                }
                if (this.$event == XDebugView.SessionEvent.FRAME_CHANGED) {
                    // empty if block
                }
                if (this.$event == XDebugView.SessionEvent.SETTINGS_CHANGED) {
                    XThreadsFramesView.access$getMyFramesManager$p(this.this$0).refresh();
                }
            }
            {
                this.this$0 = xThreadsFramesView;
                this.$event = sessionEvent;
                this.$session = xDebugSession;
            }
        });
    }

    public final void start(@NotNull XDebugSession session2) {
        XExecutionStack activeStack;
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        XSuspendContext xSuspendContext = session2.getSuspendContext();
        if (xSuspendContext == null) {
            return;
        }
        XSuspendContext suspendContext = xSuspendContext;
        Disposable disposable2 = this.nextDisposable();
        this.myFramesManager = new FramesManager(this.myFramesList, disposable2);
        XExecutionStack xExecutionStack = activeStack = suspendContext.getActiveExecutionStack();
        if (xExecutionStack != null) {
            this.setActive(xExecutionStack, session2);
        }
        this.myThreadsContainer = new ThreadsContainer(this.myThreadsList, activeStack, disposable2);
        this.myThreadsContainer.start(suspendContext);
    }

    private final void setActive(@NotNull XExecutionStack $this$setActive, XDebugSession session2) {
        this.myFramesManager.setActive($this$setActive);
        XStackFrame xStackFrame = this.myFramesManager.tryGetCurrentFrame($this$setActive);
        if (xStackFrame == null) {
            return;
        }
        XStackFrame currentFrame = xStackFrame;
        session2.setCurrentStackFrame($this$setActive, currentFrame);
    }

    private final Disposable nextDisposable() {
        Disposable disposable2 = this.myPauseDisposables.next();
        XThreadsFramesView.Companion.onTermination(disposable2, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ XThreadsFramesView this$0;

            public final void invoke() {
                XThreadsFramesView.access$setMyListenersEnabled$p(this.this$0, false);
            }
            {
                this.this$0 = xThreadsFramesView;
                super(0);
            }
        }));
        this.myListenersEnabled = true;
        return disposable2;
    }

    @Override
    protected void clear() {
        this.myPauseDisposables.terminateCurrent();
        this.myThreadsList.clear();
        this.myFramesList.clear();
        this.myFramesPresentationCache.clear();
    }

    public void dispose() {
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public XThreadsFramesView(@NotNull Project project) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.myPauseDisposables = new SequentialDisposables(this);
        this.myThreadsList = XDebuggerThreadsList.Companion.createDefault();
        this.myFramesList = new XDebuggerFramesList(this.project);
        XThreadsFramesView xThreadsFramesView = this;
        boolean bl = false;
        xThreadsFramesView.myFramesPresentationCache = map2 = (Map)new LinkedHashMap();
        this.mainPanel = new JPanel(new BorderLayout());
        this.defaultFocusedComponent = (JComponent)((Object)this.myFramesList);
        Disposable disposable2 = this.myPauseDisposables.next();
        this.myFramesManager = new FramesManager(this.myFramesList, disposable2);
        this.myThreadsContainer = new ThreadsContainer(this.myThreadsList, null, disposable2);
        this.myPauseDisposables.terminateCurrent();
        NonProportionalOnePixelSplitter nonProportionalOnePixelSplitter = new NonProportionalOnePixelSplitter(false, splitterProportionKey, 0.5f, (Disposable)this, this.project);
        xThreadsFramesView = this;
        boolean bl2 = false;
        boolean bl3 = false;
        NonProportionalOnePixelSplitter $this$apply = nonProportionalOnePixelSplitter;
        boolean bl4 = false;
        JScrollPane jScrollPane = XThreadsFramesView.Companion.toScrollPane(com.intellij.xdebugger.impl.frame.XThreadsFramesView$Companion.withSpeedSearch$default(XThreadsFramesView.Companion, (JList)((Object)this.myThreadsList), false, false, null, 7, null));
        NonProportionalOnePixelSplitter nonProportionalOnePixelSplitter2 = $this$apply;
        boolean bl5 = false;
        boolean bl6 = false;
        JScrollPane $this$apply2 = jScrollPane;
        boolean bl7 = false;
        $this$apply2.setMinimumSize(new Dimension(JBUI.scale((int)26), 0));
        JScrollPane jScrollPane2 = jScrollPane;
        nonProportionalOnePixelSplitter2.setFirstComponent((JComponent)jScrollPane2);
        $this$apply.setSecondComponent((JComponent)XThreadsFramesView.Companion.toScrollPane((Component)((Object)XThreadsFramesView.withSpeedSearch$default(this, this.myFramesList, false, false, 3, null))));
        map2 = nonProportionalOnePixelSplitter;
        xThreadsFramesView.mySplitter = map2;
        this.mainPanel.add((Component)this.mySplitter, "Center");
        this.myThreadsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent e) {
                ListSelectionEvent listSelectionEvent = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)listSelectionEvent, (String)"e");
                if (listSelectionEvent.getValueIsAdjusting() || !myListenersEnabled) {
                    return;
                }
                StackInfo stackInfo = (StackInfo)myThreadsList.getSelectedValue();
                if (stackInfo == null || (stackInfo = stackInfo.getStack()) == null) {
                    return;
                }
                StackInfo stack = stackInfo;
                XDebugSession xDebugSession = XDebugView.getSession(e);
                if (xDebugSession == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"getSession(e) ?: return@addListSelectionListener");
                XDebugSession session2 = xDebugSession;
                this.setActive((XExecutionStack)stack, session2);
            }
        });
        this.myThreadsList.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(@NotNull Component comp, int x, int y) {
                Intrinsics.checkParameterIsNotNull((Object)comp, (String)"comp");
                ActionManager actionManager = ActionManager.getInstance();
                AnAction anAction = actionManager.getAction("XDebugger.Threads.Tree.Popup");
                if (!(anAction instanceof ActionGroup)) {
                    anAction = null;
                }
                ActionGroup actionGroup = (ActionGroup)anAction;
                if (actionGroup == null) {
                    return;
                }
                ActionGroup group = actionGroup;
                ActionPopupMenu actionPopupMenu = actionManager.createActionPopupMenu("unknown", group);
                Intrinsics.checkExpressionValueIsNotNull((Object)actionPopupMenu, (String)"actionManager.createActi\u2026ionPlaces.UNKNOWN, group)");
                actionPopupMenu.getComponent().show(comp, x, y);
            }
        });
        this.myThreadsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (!myListenersEnabled) {
                    return;
                }
                XDebuggerThreadsList xDebuggerThreadsList = myThreadsList;
                Point point = e.getPoint();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"e.point");
                int i2 = xDebuggerThreadsList.locationToIndex(point);
                if (i2 == -1 || !myThreadsList.isSelectedIndex(i2)) {
                    return;
                }
                XDebugSession xDebugSession = XDebugView.getSession(e);
                if (xDebugSession == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"getSession(e) ?: return");
                XDebugSession session2 = xDebugSession;
                StackInfo stackInfo = (StackInfo)myThreadsList.getSelectedValue();
                if (stackInfo == null || (stackInfo = stackInfo.getStack()) == null) {
                    return;
                }
                StackInfo stack = stackInfo;
                this.setActive((XExecutionStack)stack, session2);
            }
        });
        this.myFramesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                ListSelectionEvent listSelectionEvent = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)listSelectionEvent, (String)"it");
                if (listSelectionEvent.getValueIsAdjusting() || !myListenersEnabled) {
                    return;
                }
                XDebugSession xDebugSession = XDebugView.getSession(it);
                if (xDebugSession == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"getSession(it) ?: return@addListSelectionListener");
                XDebugSession session2 = xDebugSession;
                StackInfo stackInfo = (StackInfo)myThreadsList.getSelectedValue();
                if (stackInfo == null || (stackInfo = stackInfo.getStack()) == null) {
                    return;
                }
                StackInfo stack = stackInfo;
                Object object = myFramesList.getSelectedValue();
                if (!(object instanceof XStackFrame)) {
                    object = null;
                }
                XStackFrame xStackFrame = (XStackFrame)object;
                if (xStackFrame == null) {
                    return;
                }
                XStackFrame frame = xStackFrame;
                session2.setCurrentStackFrame((XExecutionStack)stack, frame);
            }
        });
        this.myFramesList.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(@NotNull Component comp, int x, int y) {
                Intrinsics.checkParameterIsNotNull((Object)comp, (String)"comp");
                ActionManager actionManager = ActionManager.getInstance();
                AnAction anAction = actionManager.getAction("XDebugger.Frames.Tree.Popup");
                if (anAction == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
                }
                ActionGroup group = (ActionGroup)anAction;
                ActionPopupMenu actionPopupMenu = actionManager.createActionPopupMenu("unknown", group);
                Intrinsics.checkExpressionValueIsNotNull((Object)actionPopupMenu, (String)"actionManager.createActi\u2026ionPlaces.UNKNOWN, group)");
                actionPopupMenu.getComponent().show(comp, x, y);
            }
        });
        this.myFramesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (!myListenersEnabled) {
                    return;
                }
                int i2 = myFramesList.locationToIndex(e.getPoint());
                if (i2 == -1 || !myFramesList.isSelectedIndex(i2)) {
                    return;
                }
                XDebugSession xDebugSession = XDebugView.getSession(e);
                if (xDebugSession == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"getSession(e) ?: return");
                XDebugSession session2 = xDebugSession;
                StackInfo stackInfo = (StackInfo)myThreadsList.getSelectedValue();
                if (stackInfo == null || (stackInfo = stackInfo.getStack()) == null) {
                    return;
                }
                StackInfo stack = stackInfo;
                Object object = myFramesList.getSelectedValue();
                if (!(object instanceof XStackFrame)) {
                    object = null;
                }
                XStackFrame xStackFrame = (XStackFrame)object;
                if (xStackFrame == null) {
                    return;
                }
                XStackFrame frame = xStackFrame;
                session2.setCurrentStackFrame((XExecutionStack)stack, frame);
            }
        });
    }

    public static final /* synthetic */ Map access$getMyFramesPresentationCache$p(XThreadsFramesView $this) {
        return $this.myFramesPresentationCache;
    }

    public static final /* synthetic */ boolean access$getMyAlreadyPaused$p(XThreadsFramesView $this) {
        return $this.myAlreadyPaused;
    }

    public static final /* synthetic */ void access$setMyAlreadyPaused$p(XThreadsFramesView $this, boolean bl) {
        $this.myAlreadyPaused = bl;
    }

    public static final /* synthetic */ FramesManager access$getMyFramesManager$p(XThreadsFramesView $this) {
        return $this.myFramesManager;
    }

    public static final /* synthetic */ void access$setMyFramesManager$p(XThreadsFramesView $this, FramesManager framesManager) {
        $this.myFramesManager = framesManager;
    }

    public static final /* synthetic */ void access$setMyListenersEnabled$p(XThreadsFramesView $this, boolean bl) {
        $this.myListenersEnabled = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J \u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00122\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J&\u0010\u001c\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\"H\u0002J\u000e\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010%\u001a\u00020\u0018J\b\u0010&\u001a\u00020\u0018H\u0002R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsFramesView$FramesContainer;", "Lcom/intellij/xdebugger/impl/frame/XStackFrameContainerEx;", "myDisposable", "Lcom/intellij/openapi/Disposable;", "myFramesList", "Lcom/intellij/xdebugger/impl/frame/XDebuggerFramesList;", "myExecutionStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/xdebugger/impl/frame/XDebuggerFramesList;Lcom/intellij/xdebugger/frame/XExecutionStack;)V", "currentFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "getCurrentFrame", "()Lcom/intellij/xdebugger/frame/XStackFrame;", "isActive", "", "isProcessed", "isStarted", "myItems", "", "", "mySelectedValue", "myVisibleRectangle", "Ljava/awt/Rectangle;", "addStackFrames", "", "stackFrames", "toSelect", "last", "addStackFramesInternal", "errorOccurred", "errorMessage", "", "invokeIfNeeded", "action", "Lkotlin/Function0;", "setActive", "activeDisposable", "startIfNeeded", "updateView", "intellij.platform.debugger.impl"})
    private static final class FramesContainer
    implements XStackFrameContainerEx {
        private boolean isActive;
        private boolean isProcessed;
        private boolean isStarted;
        private Object mySelectedValue;
        private Rectangle myVisibleRectangle;
        private final List<Object> myItems;
        private final Disposable myDisposable;
        private final XDebuggerFramesList myFramesList;
        private final XExecutionStack myExecutionStack;

        @Nullable
        public final XStackFrame getCurrentFrame() {
            Object object = this.myFramesList.getSelectedValue();
            if (!(object instanceof XStackFrame)) {
                object = null;
            }
            return (XStackFrame)object;
        }

        public final void startIfNeeded() {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
                final /* synthetic */ FramesContainer this$0;

                public final void run() {
                    if (FramesContainer.access$isStarted$p(this.this$0)) {
                        return;
                    }
                    FramesContainer.access$setStarted$p(this.this$0, true);
                    FramesContainer.access$getMyItems$p(this.this$0).add(null);
                    FramesContainer.access$getMyExecutionStack$p(this.this$0).computeStackFrames(0, (XExecutionStack.XStackFrameContainer)this.this$0);
                }
                {
                    this.this$0 = framesContainer;
                }
            });
        }

        public final void setActive(@NotNull Disposable activeDisposable) {
            Intrinsics.checkParameterIsNotNull((Object)activeDisposable, (String)"activeDisposable");
            this.startIfNeeded();
            this.isActive = true;
            Companion.onTermination(activeDisposable, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ FramesContainer this$0;

                public final void invoke() {
                    FramesContainer.access$setActive$p(this.this$0, false);
                    FramesContainer.access$setMyVisibleRectangle$p(this.this$0, FramesContainer.access$getMyFramesList$p(this.this$0).getVisibleRect());
                    FramesContainer.access$setMySelectedValue$p(this.this$0, FramesContainer.access$getMyFramesList$p(this.this$0).isSelectionEmpty() ? null : FramesContainer.access$getMyFramesList$p(this.this$0).getSelectedValue());
                }
                {
                    this.this$0 = framesContainer;
                    super(0);
                }
            }));
            this.updateView();
        }

        private final void updateView() {
            if (!this.isActive) {
                return;
            }
            this.myFramesList.getModel().replaceAll(this.myItems);
            if (this.mySelectedValue != null) {
                this.myFramesList.setSelectedValue(this.mySelectedValue, true);
            } else {
                CollectionListModel collectionListModel = this.myFramesList.getModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)collectionListModel, (String)"myFramesList.model");
                List list2 = collectionListModel.getItems();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"myFramesList.model.items");
                Collection collection = list2;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    this.myFramesList.setSelectedIndex(0);
                    this.mySelectedValue = this.myFramesList.getSelectedValue();
                }
            }
            Rectangle visibleRectangle = this.myVisibleRectangle;
            if (visibleRectangle != null) {
                this.myFramesList.scrollRectToVisible(visibleRectangle);
            }
            this.myFramesList.repaint();
        }

        public void errorOccurred(@NotNull String errorMessage) {
            Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
            this.addStackFramesInternal(CollectionsKt.mutableListOf((Object[])new String[]{errorMessage}), null, true);
        }

        @Override
        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, @Nullable XStackFrame toSelect2, boolean last) {
            Intrinsics.checkParameterIsNotNull(stackFrames, (String)"stackFrames");
            this.addStackFramesInternal(stackFrames, toSelect2, last);
        }

        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
            Intrinsics.checkParameterIsNotNull(stackFrames, (String)"stackFrames");
            this.addStackFrames(stackFrames, null, last);
        }

        private final void addStackFramesInternal(List<?> stackFrames, XStackFrame toSelect2, boolean last) {
            this.invokeIfNeeded((Function0<Unit>)((Function0)new Function0<Unit>(this, stackFrames, last, toSelect2){
                final /* synthetic */ FramesContainer this$0;
                final /* synthetic */ List $stackFrames;
                final /* synthetic */ boolean $last;
                final /* synthetic */ XStackFrame $toSelect;

                public final void invoke() {
                    int insertIndex = FramesContainer.access$getMyItems$p(this.this$0).size() - 1;
                    Collection collection = this.$stackFrames;
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        FramesContainer.access$getMyItems$p(this.this$0).addAll(insertIndex, this.$stackFrames);
                    }
                    if (this.$last) {
                        FramesContainer.access$getMyItems$p(this.this$0).remove(FramesContainer.access$getMyItems$p(this.this$0).size() - 1);
                        FramesContainer.access$setProcessed$p(this.this$0, true);
                    }
                    if (this.$toSelect != null && FramesContainer.access$getMyItems$p(this.this$0).contains(this.$toSelect)) {
                        FramesContainer.access$setMySelectedValue$p(this.this$0, this.$toSelect);
                    }
                    FramesContainer.access$updateView(this.this$0);
                }
                {
                    this.this$0 = framesContainer;
                    this.$stackFrames = list2;
                    this.$last = bl;
                    this.$toSelect = xStackFrame;
                    super(0);
                }
            }));
        }

        private final void invokeIfNeeded(Function0<Unit> action2) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, action2){
                final /* synthetic */ FramesContainer this$0;
                final /* synthetic */ Function0 $action;

                public final void run() {
                    if (FramesContainer.access$isProcessed$p(this.this$0) || com.intellij.xdebugger.impl.frame.XThreadsFramesView$Companion.access$isNotAlive$p(XThreadsFramesView.Companion, FramesContainer.access$getMyDisposable$p(this.this$0))) {
                        return;
                    }
                    this.$action.invoke();
                }
                {
                    this.this$0 = framesContainer;
                    this.$action = function0;
                }
            });
        }

        public FramesContainer(@NotNull Disposable myDisposable, @NotNull XDebuggerFramesList myFramesList, @NotNull XExecutionStack myExecutionStack) {
            List list2;
            Intrinsics.checkParameterIsNotNull((Object)myDisposable, (String)"myDisposable");
            Intrinsics.checkParameterIsNotNull((Object)((Object)myFramesList), (String)"myFramesList");
            Intrinsics.checkParameterIsNotNull((Object)myExecutionStack, (String)"myExecutionStack");
            this.myDisposable = myDisposable;
            this.myFramesList = myFramesList;
            this.myExecutionStack = myExecutionStack;
            FramesContainer framesContainer = this;
            boolean bl = false;
            framesContainer.myItems = list2 = (List)new ArrayList();
        }

        public static final /* synthetic */ boolean access$isStarted$p(FramesContainer $this) {
            return $this.isStarted;
        }

        public static final /* synthetic */ void access$setStarted$p(FramesContainer $this, boolean bl) {
            $this.isStarted = bl;
        }

        public static final /* synthetic */ List access$getMyItems$p(FramesContainer $this) {
            return $this.myItems;
        }

        public static final /* synthetic */ XExecutionStack access$getMyExecutionStack$p(FramesContainer $this) {
            return $this.myExecutionStack;
        }

        public static final /* synthetic */ boolean access$isActive$p(FramesContainer $this) {
            return $this.isActive;
        }

        public static final /* synthetic */ void access$setActive$p(FramesContainer $this, boolean bl) {
            $this.isActive = bl;
        }

        public static final /* synthetic */ Rectangle access$getMyVisibleRectangle$p(FramesContainer $this) {
            return $this.myVisibleRectangle;
        }

        public static final /* synthetic */ void access$setMyVisibleRectangle$p(FramesContainer $this, Rectangle rectangle) {
            $this.myVisibleRectangle = rectangle;
        }

        public static final /* synthetic */ XDebuggerFramesList access$getMyFramesList$p(FramesContainer $this) {
            return $this.myFramesList;
        }

        public static final /* synthetic */ Object access$getMySelectedValue$p(FramesContainer $this) {
            return $this.mySelectedValue;
        }

        public static final /* synthetic */ void access$setMySelectedValue$p(FramesContainer $this, Object object) {
            $this.mySelectedValue = object;
        }

        public static final /* synthetic */ boolean access$isProcessed$p(FramesContainer $this) {
            return $this.isProcessed;
        }

        public static final /* synthetic */ void access$setProcessed$p(FramesContainer $this, boolean bl) {
            $this.isProcessed = bl;
        }

        public static final /* synthetic */ void access$updateView(FramesContainer $this) {
            $this.updateView();
        }

        public static final /* synthetic */ Disposable access$getMyDisposable$p(FramesContainer $this) {
            return $this.myDisposable;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\bJ\f\u0010\u0015\u001a\u00020\u000e*\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsFramesView$FramesManager;", "", "myFramesList", "Lcom/intellij/xdebugger/impl/frame/XDebuggerFramesList;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/xdebugger/impl/frame/XDebuggerFramesList;Lcom/intellij/openapi/Disposable;)V", "myActiveStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "myActiveStackDisposables", "Lcom/intellij/xdebugger/impl/frame/XThreadsFramesView$SequentialDisposables;", "myMap", "", "Lcom/intellij/xdebugger/impl/frame/StackInfo;", "Lcom/intellij/xdebugger/impl/frame/XThreadsFramesView$FramesContainer;", "refresh", "", "setActive", "stack", "tryGetCurrentFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "getContainer", "intellij.platform.debugger.impl"})
    private static final class FramesManager {
        private final Map<StackInfo, FramesContainer> myMap;
        private final SequentialDisposables myActiveStackDisposables;
        private XExecutionStack myActiveStack;
        private final XDebuggerFramesList myFramesList;
        private final Disposable disposable;

        /*
         * WARNING - void declaration
         */
        private final FramesContainer getContainer(@NotNull XExecutionStack $this$getContainer) {
            Object object;
            void $this$getOrPut$iv;
            Map<StackInfo, FramesContainer> map2 = this.myMap;
            StackInfo key$iv = StackInfo.Companion.from($this$getContainer);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                FramesContainer answer$iv = new FramesContainer(this.disposable, this.myFramesList, $this$getContainer);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (FramesContainer)object;
        }

        public final void setActive(@NotNull XExecutionStack stack) {
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            Disposable disposable2 = this.myActiveStackDisposables.next();
            this.myActiveStack = stack;
            this.getContainer(stack).setActive(disposable2);
        }

        @Nullable
        public final XStackFrame tryGetCurrentFrame(@NotNull XExecutionStack stack) {
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            return this.getContainer(stack).getCurrentFrame();
        }

        public final void refresh() {
            this.myMap.clear();
            XExecutionStack xExecutionStack = this.myActiveStack;
            if (xExecutionStack == null) {
                return;
            }
            this.setActive(xExecutionStack);
        }

        public FramesManager(@NotNull XDebuggerFramesList myFramesList, @NotNull Disposable disposable2) {
            Map map2;
            Intrinsics.checkParameterIsNotNull((Object)((Object)myFramesList), (String)"myFramesList");
            Intrinsics.checkParameterIsNotNull((Object)disposable2, (String)"disposable");
            this.myFramesList = myFramesList;
            this.disposable = disposable2;
            FramesManager framesManager = this;
            boolean bl = false;
            framesManager.myMap = map2 = (Map)new LinkedHashMap();
            this.myActiveStackDisposables = new SequentialDisposables(this.disposable);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\nJ \u0010\f\u001a\u00020\r2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00112\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0011H\u0002J\u0016\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsFramesView$ThreadsContainer;", "Lcom/intellij/xdebugger/frame/XSuspendContext$XExecutionStackContainer;", "myThreadsList", "Lcom/intellij/xdebugger/impl/frame/XDebuggerThreadsList;", "myActiveStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "myDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/xdebugger/impl/frame/XDebuggerThreadsList;Lcom/intellij/xdebugger/frame/XExecutionStack;Lcom/intellij/openapi/Disposable;)V", "isProcessed", "", "isStarted", "addExecutionStack", "", "executionStack", "last", "executionStacks", "", "errorOccurred", "errorMessage", "", "getThreadsList", "", "Lcom/intellij/xdebugger/impl/frame/StackInfo;", "invokeIfNeeded", "action", "Lkotlin/Function0;", "start", "suspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "Companion", "intellij.platform.debugger.impl"})
    private static final class ThreadsContainer
    implements XSuspendContext.XExecutionStackContainer {
        private boolean isProcessed;
        private boolean isStarted;
        private final XDebuggerThreadsList myThreadsList;
        private final XExecutionStack myActiveStack;
        private final Disposable myDisposable;
        private static final List<StackInfo> loading;
        public static final Companion Companion;

        public final void start(@NotNull XSuspendContext suspendContext) {
            Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, suspendContext){
                final /* synthetic */ ThreadsContainer this$0;
                final /* synthetic */ XSuspendContext $suspendContext;

                public final void run() {
                    if (ThreadsContainer.access$isStarted$p(this.this$0)) {
                        return;
                    }
                    if (ThreadsContainer.access$getMyActiveStack$p(this.this$0) != null) {
                        ThreadsContainer.access$getMyThreadsList$p(this.this$0).getModel().replaceAll(CollectionsKt.listOf((Object[])new StackInfo[]{StackInfo.Companion.from(ThreadsContainer.access$getMyActiveStack$p(this.this$0)), StackInfo.Companion.getLoading()}));
                    } else {
                        ThreadsContainer.access$getMyThreadsList$p(this.this$0).getModel().replaceAll(ThreadsContainer.access$getLoading$cp());
                    }
                    ThreadsContainer.access$getMyThreadsList$p(this.this$0).setSelectedIndex(0);
                    this.$suspendContext.computeExecutionStacks((XSuspendContext.XExecutionStackContainer)this.this$0);
                    ThreadsContainer.access$setStarted$p(this.this$0, true);
                }
                {
                    this.this$0 = threadsContainer;
                    this.$suspendContext = xSuspendContext;
                }
            });
        }

        public void errorOccurred(@NotNull String errorMessage) {
            Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
            this.invokeIfNeeded((Function0<Unit>)((Function0)new Function0<Unit>(this, errorMessage){
                final /* synthetic */ ThreadsContainer this$0;
                final /* synthetic */ String $errorMessage;

                public final void invoke() {
                    CollectionListModel<StackInfo> model = ThreadsContainer.access$getMyThreadsList$p(this.this$0).getModel();
                    model.remove(model.getSize() - 1);
                    model.add(CollectionsKt.listOf((Object)StackInfo.Companion.error(this.$errorMessage)));
                    ThreadsContainer.access$setProcessed$p(this.this$0, true);
                }
                {
                    this.this$0 = threadsContainer;
                    this.$errorMessage = string;
                    super(0);
                }
            }));
        }

        public void addExecutionStack(@NotNull List<? extends XExecutionStack> executionStacks, boolean last) {
            Intrinsics.checkParameterIsNotNull(executionStacks, (String)"executionStacks");
            this.invokeIfNeeded((Function0<Unit>)((Function0)new Function0<Unit>(this, executionStacks, last){
                final /* synthetic */ ThreadsContainer this$0;
                final /* synthetic */ List $executionStacks;
                final /* synthetic */ boolean $last;

                public final void invoke() {
                    CollectionListModel<StackInfo> model = ThreadsContainer.access$getMyThreadsList$p(this.this$0).getModel();
                    int insertIndex = model.getSize() - 1;
                    List threads = ThreadsContainer.access$getThreadsList(this.this$0, this.$executionStacks);
                    if (CollectionsKt.any((Iterable)threads)) {
                        model.addAll(insertIndex, threads);
                    }
                    if (this.$last) {
                        model.remove(model.getSize() - 1);
                        ThreadsContainer.access$setProcessed$p(this.this$0, true);
                    }
                    ThreadsContainer.access$getMyThreadsList$p(this.this$0).repaint();
                }
                {
                    this.this$0 = threadsContainer;
                    this.$executionStacks = list2;
                    this.$last = bl;
                    super(0);
                }
            }));
        }

        public final void addExecutionStack(@NotNull XExecutionStack executionStack, boolean last) {
            Intrinsics.checkParameterIsNotNull((Object)executionStack, (String)"executionStack");
            this.addExecutionStack(CollectionsKt.mutableListOf((Object[])new XExecutionStack[]{executionStack}), last);
        }

        private final List<StackInfo> getThreadsList(List<? extends XExecutionStack> executionStacks) {
            Sequence sequence = CollectionsKt.asSequence((Iterable)executionStacks);
            if (this.myActiveStack != null) {
                sequence = SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<XExecutionStack, Boolean>(this){
                    final /* synthetic */ ThreadsContainer this$0;

                    public final boolean invoke(@NotNull XExecutionStack it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it, (Object)ThreadsContainer.access$getMyActiveStack$p(this.this$0)) ^ true;
                    }
                    {
                        this.this$0 = threadsContainer;
                        super(1);
                    }
                }));
            }
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)sequence, (Function1)getThreadsList.2.INSTANCE));
        }

        private final void invokeIfNeeded(Function0<Unit> action2) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, action2){
                final /* synthetic */ ThreadsContainer this$0;
                final /* synthetic */ Function0 $action;

                public final void run() {
                    if (ThreadsContainer.access$isProcessed$p(this.this$0) || com.intellij.xdebugger.impl.frame.XThreadsFramesView$Companion.access$isNotAlive$p(XThreadsFramesView.Companion, ThreadsContainer.access$getMyDisposable$p(this.this$0))) {
                        return;
                    }
                    this.$action.invoke();
                }
                {
                    this.this$0 = threadsContainer;
                    this.$action = function0;
                }
            });
        }

        public ThreadsContainer(@NotNull XDebuggerThreadsList myThreadsList, @Nullable XExecutionStack myActiveStack, @NotNull Disposable myDisposable) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)myThreadsList), (String)"myThreadsList");
            Intrinsics.checkParameterIsNotNull((Object)myDisposable, (String)"myDisposable");
            this.myThreadsList = myThreadsList;
            this.myActiveStack = myActiveStack;
            this.myDisposable = myDisposable;
        }

        static {
            Companion = new Companion(null);
            loading = CollectionsKt.listOf((Object)StackInfo.Companion.getLoading());
        }

        public static final /* synthetic */ boolean access$isStarted$p(ThreadsContainer $this) {
            return $this.isStarted;
        }

        public static final /* synthetic */ void access$setStarted$p(ThreadsContainer $this, boolean bl) {
            $this.isStarted = bl;
        }

        public static final /* synthetic */ XExecutionStack access$getMyActiveStack$p(ThreadsContainer $this) {
            return $this.myActiveStack;
        }

        public static final /* synthetic */ XDebuggerThreadsList access$getMyThreadsList$p(ThreadsContainer $this) {
            return $this.myThreadsList;
        }

        public static final /* synthetic */ List access$getLoading$cp() {
            return loading;
        }

        public static final /* synthetic */ boolean access$isProcessed$p(ThreadsContainer $this) {
            return $this.isProcessed;
        }

        public static final /* synthetic */ void access$setProcessed$p(ThreadsContainer $this, boolean bl) {
            $this.isProcessed = bl;
        }

        public static final /* synthetic */ List access$getThreadsList(ThreadsContainer $this, List executionStacks) {
            return $this.getThreadsList(executionStacks);
        }

        public static final /* synthetic */ Disposable access$getMyDisposable$p(ThreadsContainer $this) {
            return $this.myDisposable;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsFramesView$ThreadsContainer$Companion;", "", "()V", "loading", "", "Lcom/intellij/xdebugger/impl/frame/StackInfo;", "intellij.platform.debugger.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0006\u0010\u0007\u001a\u00020\u0001J\u0006\u0010\b\u001a\u00020\u0006J\f\u0010\t\u001a\u00020\u0006*\u00020\u0001H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsFramesView$SequentialDisposables;", "Lcom/intellij/openapi/Disposable;", "parent", "(Lcom/intellij/openapi/Disposable;)V", "myCurrentDisposable", "dispose", "", "next", "terminateCurrent", "disposeIfNeeded", "intellij.platform.debugger.impl"})
    private static final class SequentialDisposables
    implements Disposable {
        private Disposable myCurrentDisposable;

        @NotNull
        public final Disposable next() {
            Disposable disposable2 = Disposer.newDisposable();
            Intrinsics.checkExpressionValueIsNotNull((Object)disposable2, (String)"Disposer.newDisposable()");
            Disposable newDisposable = disposable2;
            Disposer.register((Disposable)this, (Disposable)newDisposable);
            Disposable disposable3 = this.myCurrentDisposable;
            if (disposable3 != null) {
                this.disposeIfNeeded(disposable3);
            }
            this.myCurrentDisposable = newDisposable;
            return newDisposable;
        }

        public final void terminateCurrent() {
            Disposable disposable2 = this.myCurrentDisposable;
            if (disposable2 != null) {
                this.disposeIfNeeded(disposable2);
            }
            this.myCurrentDisposable = null;
        }

        private final void disposeIfNeeded(@NotNull Disposable $this$disposeIfNeeded) {
            if (Companion.isAlive($this$disposeIfNeeded)) {
                Disposer.dispose((Disposable)$this$disposeIfNeeded);
            }
        }

        public void dispose() {
            this.terminateCurrent();
        }

        public SequentialDisposables(@Nullable Disposable parent) {
            block0: {
                Disposable disposable2 = parent;
                if (disposable2 == null) break block0;
                Companion.onTermination(disposable2, this);
            }
        }

        public /* synthetic */ SequentialDisposables(Disposable disposable2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                disposable2 = null;
            }
            this(disposable2);
        }

        public SequentialDisposables() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000e\u001a\u00020\u000f*\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002JO\u0010\u0016\u001a\u0002H\u0017\"\f\b\u0000\u0010\u0017*\u0006\u0012\u0002\b\u00030\u0018*\u0002H\u00172\b\b\u0002\u0010\u0019\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\b2\u001a\b\u0002\u0010\u001b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\nR\u0018\u0010\u000b\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0018\u0010\f\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0018\u0010\r\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsFramesView$Companion;", "", "()V", "splitterProportionDefaultValue", "", "splitterProportionKey", "", "isAlive", "", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/Disposable;)Z", "isDisposed", "isDisposing", "isNotAlive", "onTermination", "", "action", "Lkotlin/Function0;", "disposable", "toScrollPane", "Ljavax/swing/JScrollPane;", "Ljava/awt/Component;", "withSpeedSearch", "T", "Ljavax/swing/JList;", "shouldMatchFromTheBeginning", "shouldMatchCamelCase", "converter", "Lkotlin/Function1;", "(Ljavax/swing/JList;ZZLkotlin/jvm/functions/Function1;)Ljavax/swing/JList;", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private final boolean isDisposed(@NotNull Disposable $this$isDisposed) {
            return Disposer.isDisposed((Disposable)$this$isDisposed);
        }

        private final boolean isDisposing(@NotNull Disposable $this$isDisposing) {
            return Disposer.isDisposing((Disposable)$this$isDisposing);
        }

        private final boolean isAlive(@NotNull Disposable $this$isAlive) {
            return !Companion.isDisposed($this$isAlive) && !Companion.isDisposing($this$isAlive);
        }

        private final boolean isNotAlive(@NotNull Disposable $this$isNotAlive) {
            return !Companion.isAlive($this$isNotAlive);
        }

        private final void onTermination(@NotNull Disposable $this$onTermination, Disposable disposable2) {
            Disposer.register((Disposable)$this$onTermination, (Disposable)disposable2);
        }

        private final void onTermination(@NotNull Disposable $this$onTermination, Function0<Unit> action2) {
            Disposer.register((Disposable)$this$onTermination, (Disposable)new Disposable(action2){
                final /* synthetic */ Function0 $action;

                public final void dispose() {
                    this.$action.invoke();
                }
                {
                    this.$action = function0;
                }
            });
        }

        private final JScrollPane toScrollPane(@NotNull Component $this$toScrollPane) {
            JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)$this$toScrollPane);
            Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"ScrollPaneFactory.createScrollPane(this)");
            return jScrollPane;
        }

        private final <T extends JList<?>> T withSpeedSearch(@NotNull T $this$withSpeedSearch, boolean shouldMatchFromTheBeginning, boolean shouldMatchCamelCase, Function1<Object, String> converter) {
            ListSpeedSearch listSpeedSearch;
            if (converter != null) {
                Function1<Object, String> function1 = converter;
                ListSpeedSearch listSpeedSearch2 = new ListSpeedSearch($this$withSpeedSearch, new XThreadsFramesView$sam$com_intellij_util_Function$0(function1));
                listSpeedSearch = listSpeedSearch2;
            } else {
                listSpeedSearch = new ListSpeedSearch($this$withSpeedSearch);
            }
            ListSpeedSearch search2 = listSpeedSearch;
            search2.setComparator(new SpeedSearchComparator(shouldMatchFromTheBeginning, shouldMatchCamelCase));
            return $this$withSpeedSearch;
        }

        static /* synthetic */ JList withSpeedSearch$default(Companion companion, JList jList, boolean bl, boolean bl2, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            if ((n & 4) != 0) {
                function1 = null;
            }
            return companion.withSpeedSearch(jList, bl, bl2, (Function1<Object, String>)function1);
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isNotAlive$p(Companion $this, Disposable $this$access_u24isNotAlive_u24p) {
            return $this.isNotAlive($this$access_u24isNotAlive_u24p);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

