/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeSearchSession;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.util.Collections;
import java.util.ListIterator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XDebuggerTreeSpeedSearch
extends TreeSpeedSearch {
    private XDebuggerTreeSearchSession mySearchSession;

    XDebuggerTreeSpeedSearch(XDebuggerTree tree, Convertor<? super TreePath, String> toStringConvertor) {
        super(tree, toStringConvertor, false);
        this.setComparator(new SpeedSearchComparator(false, false){

            @Override
            public int matchingDegree(String pattern, String text) {
                return this.matchingFragments(pattern, text) != null ? 1 : 0;
            }

            @Override
            @Nullable
            public Iterable<TextRange> matchingFragments(@NotNull String pattern, @NotNull String text) {
                if (pattern == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.myRecentSearchText = pattern;
                boolean sensitive = false;
                if (XDebuggerTreeSpeedSearch.this.mySearchSession != null) {
                    sensitive = XDebuggerTreeSpeedSearch.this.mySearchSession.getFindModel().isCaseSensitive();
                }
                int index = sensitive ? StringUtil.indexOf((CharSequence)text, (CharSequence)pattern, (int)0) : StringUtil.indexOfIgnoreCase((String)text, (String)pattern, (int)0);
                return index >= 0 ? Collections.singleton(TextRange.from((int)index, (int)pattern.length())) : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pattern";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch$1";
                objectArray[2] = "matchingFragments";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    boolean findOccurence(@NotNull String searchQuery) {
        Object element2;
        boolean found;
        if (searchQuery == null) {
            XDebuggerTreeSpeedSearch.$$$reportNull$$$0(0);
        }
        boolean bl = found = (element2 = this.findElement(searchQuery)) != null;
        if (found) {
            this.selectElement(element2, searchQuery);
        }
        return found;
    }

    void searchSessionStarted(XDebuggerTreeSearchSession searchSession) {
        this.mySearchSession = searchSession;
        this.myCanExpand = true;
    }

    void searchSessionStopped() {
        this.mySearchSession = null;
        this.myCanExpand = false;
    }

    @Override
    public boolean isPopupActive() {
        if (this.mySearchSession != null) {
            return true;
        }
        return super.isPopupActive();
    }

    boolean nextOccurence(@NotNull String searchQuery) {
        Object current2;
        int selectedIndex;
        ListIterator<Object> it;
        if (searchQuery == null) {
            XDebuggerTreeSpeedSearch.$$$reportNull$$$0(1);
        }
        if ((it = this.getElementIterator((selectedIndex = this.getSelectedIndex()) + 1)).hasPrevious()) {
            current2 = it.previous();
            it.next();
        } else {
            current2 = null;
        }
        String _s = searchQuery.trim();
        while (it.hasNext()) {
            Object element2 = it.next();
            if (!this.isMatchingElement(element2, _s)) continue;
            this.selectElement(element2, searchQuery);
            return true;
        }
        if (UISettings.getInstance().getCycleScrolling()) {
            ListIterator<Object> i2 = this.getElementIterator(0);
            while (i2.hasNext()) {
                Object element3 = i2.next();
                if (!this.isMatchingElement(element3, _s)) continue;
                this.selectElement(element3, searchQuery);
                return true;
            }
        }
        if (current2 != null && this.isMatchingElement(current2, _s)) {
            this.selectElement(current2, searchQuery);
            return true;
        }
        return false;
    }

    boolean previousOccurence(@NotNull String searchQuery) {
        Object current2;
        int selectedIndex;
        if (searchQuery == null) {
            XDebuggerTreeSpeedSearch.$$$reportNull$$$0(2);
        }
        if ((selectedIndex = this.getSelectedIndex()) < 0) {
            return false;
        }
        ListIterator<Object> it = this.getElementIterator(selectedIndex);
        if (it.hasNext()) {
            current2 = it.next();
            it.previous();
        } else {
            current2 = null;
        }
        String _s = searchQuery.trim();
        while (it.hasPrevious()) {
            Object element2 = it.previous();
            if (!this.isMatchingElement(element2, _s)) continue;
            this.selectElement(element2, searchQuery);
            return true;
        }
        if (UISettings.getInstance().getCycleScrolling()) {
            ListIterator<Object> i2 = this.getElementIterator(this.getElementCount());
            while (i2.hasPrevious()) {
                Object element3 = i2.previous();
                if (!this.isMatchingElement(element3, _s)) continue;
                this.selectElement(element3, searchQuery);
                return true;
            }
        }
        if (current2 != null && this.isMatchingElement(current2, _s)) {
            this.selectElement(current2, searchQuery);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected Object findElement(@NotNull String s) {
        TreePath element2;
        if (s == null) {
            XDebuggerTreeSpeedSearch.$$$reportNull$$$0(3);
        }
        if (!this.myCanExpand) {
            return super.findElement(s);
        }
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        ListIterator<Object> it = this.getElementIterator(selectedIndex);
        String _s = s.trim();
        while (it.hasNext()) {
            element2 = (TreePath)it.next();
            if (!((JTree)this.myComponent).isVisible(element2) || !this.isMatchingElement(element2, _s)) continue;
            return element2;
        }
        if (selectedIndex > 0) {
            while (it.hasPrevious()) {
                it.previous();
            }
            while (it.hasNext() && it.nextIndex() != selectedIndex) {
                element2 = (TreePath)it.next();
                if (!((JTree)this.myComponent).isVisible(element2) || !this.isMatchingElement(element2, _s)) continue;
                return element2;
            }
        }
        while (it.hasNext()) {
            element2 = (TreePath)it.next();
            if (!this.isMatchingElement(element2, _s)) continue;
            return element2;
        }
        if (selectedIndex > 0) {
            while (it.hasPrevious()) {
                it.previous();
            }
            while (it.hasNext() && it.nextIndex() != selectedIndex) {
                element2 = (TreePath)it.next();
                if (!this.isMatchingElement(element2, _s)) continue;
                return element2;
            }
        }
        return null;
    }

    @Override
    protected Object @NotNull [] getAllElements() {
        if (!this.myCanExpand) {
            Object[] objectArray = super.getAllElements();
            if (objectArray == null) {
                XDebuggerTreeSpeedSearch.$$$reportNull$$$0(4);
            }
            return objectArray;
        }
        XDebuggerTreeNode root = (XDebuggerTreeNode)ObjectUtils.tryCast((Object)((JTree)this.myComponent).getModel().getRoot(), XDebuggerTreeNode.class);
        int initialLevel = root != null ? root.getPath().getPathCount() : 0;
        Object[] objectArray = ((JBTreeTraverser)TreeUtil.treePathTraverser((JTree)((JTree)this.myComponent)).expand(n -> ((JTree)this.myComponent).isExpanded((TreePath)n) || n.getPathCount() - initialLevel < this.getSearchDepth())).traverse().filter(o -> !(o.getLastPathComponent() instanceof LoadingNode)).toArray((Object[])TreeUtil.EMPTY_TREE_PATH);
        if (objectArray == null) {
            XDebuggerTreeSpeedSearch.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    private int getSearchDepth() {
        return this.mySearchSession.getFindModel().getSearchDepth();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchQuery";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeSpeedSearch";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findOccurence";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "nextOccurence";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "previousOccurence";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

