/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.util.io.PathKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.StaticFileHandlerKt;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.ide.OpenFileHttpServiceKt;
import org.jetbrains.ide.OpenFileRequest;
import org.jetbrains.ide.OpenFileTask;
import org.jetbrains.ide.RestService;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J,\u0010\u0017\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/ide/OpenFileHttpService;", "Lorg/jetbrains/ide/RestService;", "()V", "refreshSessionId", "", "requests", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/ide/OpenFileTask;", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "isAccessible", "", "Lio/netty/handler/codec/http/HttpRequest;", "isMethodSupported", "method", "Lio/netty/handler/codec/http/HttpMethod;", "openFile", "Lorg/jetbrains/concurrency/Promise;", "Ljava/lang/Void;", "Lorg/jetbrains/ide/OpenFileRequest;", "httpRequest", "intellij.platform.builtInServer.impl"})
public final class OpenFileHttpService
extends RestService {
    private volatile long refreshSessionId;
    private final ConcurrentLinkedQueue<OpenFileTask> requests = new ConcurrentLinkedQueue();

    @Override
    @NotNull
    protected String getServiceName() {
        return "file";
    }

    @Override
    protected boolean isMethodSupported(@NotNull HttpMethod method2) {
        Intrinsics.checkParameterIsNotNull((Object)method2, (String)"method");
        return method2 == HttpMethod.GET || method2 == HttpMethod.POST;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request2));
        Channel channel = context.channel();
        OpenFileRequest apiRequest = null;
        if (request2.method() == HttpMethod.POST) {
            Object object = this.getGson().fromJson(RestService.Companion.createJsonReader(request2), (Type)((Object)OpenFileRequest.class));
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(createJson\u2026nFileRequest::class.java)");
            apiRequest = (OpenFileRequest)object;
        } else {
            apiRequest = new OpenFileRequest();
            apiRequest.setFile(StringUtil.nullize((String)RestService.Companion.getStringParameter("file", urlDecoder), (boolean)true));
            apiRequest.setLine(RestService.Companion.getIntParameter("line", urlDecoder));
            apiRequest.setColumn(RestService.Companion.getIntParameter("column", urlDecoder));
            apiRequest.setFocused(RestService.Companion.getBooleanParameter("focused", urlDecoder, true));
        }
        int prefixLength = 5 + this.getServiceName().length() + 1;
        String path = urlDecoder.path();
        if (path.length() > prefixLength) {
            Matcher matcher = OpenFileHttpServiceKt.access$getLINE_AND_COLUMN$p().matcher(path).region(prefixLength, path.length());
            RestService.LOG.assertTrue(matcher.matches());
            if (apiRequest.getFile() == null) {
                void $this$trim$iv;
                String string = matcher.group(1);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group(1)");
                String string2 = string;
                OpenFileRequest openFileRequest = apiRequest;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String string3 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                openFileRequest.setFile(string3);
            }
            if (apiRequest.getLine() == -1) {
                apiRequest.setLine(StringUtilRt.parseInt((String)matcher.group(2), (int)1));
            }
            if (apiRequest.getColumn() == -1) {
                apiRequest.setColumn(StringUtilRt.parseInt((String)matcher.group(3), (int)1));
            }
        }
        if (apiRequest.getFile() == null) {
            return RestService.Companion.parameterMissedErrorMessage("file");
        }
        Promise<Void> promise = this.openFile(apiRequest, context, (HttpRequest)request2);
        if (promise == null) {
            return null;
        }
        Promise<Void> promise2 = promise;
        promise2.onSuccess((Consumer)new Consumer<Void>(request2, context){
            final /* synthetic */ FullHttpRequest $request;
            final /* synthetic */ ChannelHandlerContext $context;

            public final void accept(@Nullable Void it) {
                RestService.Companion.sendOk(this.$request, this.$context);
            }
            {
                this.$request = fullHttpRequest;
                this.$context = channelHandlerContext;
            }
        }).onError((Consumer)new Consumer<Throwable>(keepAlive, channel, apiRequest){
            final /* synthetic */ boolean $keepAlive;
            final /* synthetic */ Channel $channel;
            final /* synthetic */ OpenFileRequest $apiRequest;

            public final void accept(Throwable it) {
                if (it == OpenFileHttpServiceKt.access$getNOT_FOUND$p()) {
                    HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
                    HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus2, (String)"HttpResponseStatus.OK");
                    HttpResponseStatus httpResponseStatus3 = Responses.orInSafeMode((HttpResponseStatus)httpResponseStatus, (HttpResponseStatus)httpResponseStatus2);
                    Channel channel = this.$channel;
                    Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"channel");
                    RestService.Companion.sendStatus(httpResponseStatus3, this.$keepAlive, channel);
                    RestService.LOG.warn("File " + this.$apiRequest.getFile() + " not found");
                } else {
                    HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.INTERNAL_SERVER_ERROR");
                    Channel channel = this.$channel;
                    Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"channel");
                    RestService.Companion.sendStatus(httpResponseStatus, this.$keepAlive, channel);
                    RestService.LOG.error(it);
                }
            }
            {
                this.$keepAlive = bl;
                this.$channel = channel;
                this.$apiRequest = openFileRequest;
            }
        });
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Promise<Void> openFile(OpenFileRequest request2, ChannelHandlerContext context, HttpRequest httpRequest) {
        Path file2;
        String string = request2.getFile();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = FileUtil.toSystemIndependentName((String)FileUtil.expandUserHome((String)string));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtil.toSystemIndepen\u2026UserHome(request.file!!))");
        String systemIndependentPath = string2;
        Path path = file2 = Paths.get(FileUtil.toSystemDependentName((String)systemIndependentPath), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
        if (path.isAbsolute()) {
            void isAllowed;
            if (!PathKt.exists((Path)file2)) {
                return Promises.rejectedPromise((Throwable)OpenFileHttpServiceKt.access$getNOT_FOUND$p());
            }
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = StaticFileHandlerKt.checkAccess$default(file2, null, 2, null);
            if (isAllowed.element && ProjectUtil.isRemotePath(systemIndependentPath)) {
                SwingUtilities.invokeAndWait(new Runnable((Ref.BooleanRef)isAllowed, systemIndependentPath){
                    final /* synthetic */ Ref.BooleanRef $isAllowed;
                    final /* synthetic */ String $systemIndependentPath;

                    public final void run() {
                        this.$isAllowed.element = ProjectUtil.confirmLoadingFromRemotePath(this.$systemIndependentPath, "warning.load.file.from.share", "title.load.file.from.share");
                    }
                    {
                        this.$isAllowed = booleanRef;
                        this.$systemIndependentPath = string;
                    }
                });
            }
            if (isAllowed.element) {
                return OpenFileHttpServiceKt.access$openAbsolutePath(file2, request2);
            }
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.FORBIDDEN;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.FORBIDDEN");
            HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus2, (String)"HttpResponseStatus.OK");
            HttpResponseStatus httpResponseStatus3 = Responses.orInSafeMode((HttpResponseStatus)httpResponseStatus, (HttpResponseStatus)httpResponseStatus2);
            Channel channel = context.channel();
            Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"context.channel()");
            Responses.send$default((HttpResponseStatus)httpResponseStatus3, (Channel)channel, (HttpRequest)httpRequest, null, null, (int)12, null);
            return null;
        }
        RefreshQueue queue = RefreshQueue.getInstance();
        queue.cancelSession(this.refreshSessionId);
        String string3 = FileUtil.toCanonicalPath((String)systemIndependentPath, (char)'/');
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"FileUtil.toCanonicalPath\u2026stemIndependentPath, '/')");
        OpenFileTask mainTask = new OpenFileTask(string3, request2);
        this.requests.offer(mainTask);
        RefreshSession refreshSession = queue.createSession(true, true, new Runnable(this){
            final /* synthetic */ OpenFileHttpService this$0;

            public final void run() {
                while ((OpenFileTask)OpenFileHttpService.access$getRequests$p(this.this$0).poll() != null) {
                    Object object;
                    OpenFileTask task2;
                    AsyncPromise<Void> $this$catchError$iv = task2.getPromise$intellij_platform_builtInServer_impl();
                    boolean $i$f$catchError = false;
                    try {
                        Object object2;
                        boolean bl = false;
                        if (OpenFileHttpServiceKt.access$openRelativePath(task2.getPath$intellij_platform_builtInServer_impl(), task2.getRequest$intellij_platform_builtInServer_impl())) {
                            task2.getPromise$intellij_platform_builtInServer_impl().setResult(null);
                            object2 = Unit.INSTANCE;
                        } else {
                            object2 = task2.getPromise$intellij_platform_builtInServer_impl().setError((Throwable)OpenFileHttpServiceKt.access$getNOT_FOUND$p());
                        }
                        object = object2;
                    }
                    catch (Throwable e$iv) {
                        $this$catchError$iv.setError(e$iv);
                        object = null;
                    }
                }
            }
            {
                this.this$0 = openFileHttpService;
            }
        }, ModalityState.NON_MODAL);
        Intrinsics.checkExpressionValueIsNotNull((Object)refreshSession, (String)"queue.createSession(true\u2026 ModalityState.NON_MODAL)");
        RefreshSession session2 = refreshSession;
        ManagingFS managingFS = ManagingFS.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)managingFS, (String)"ManagingFS.getInstance()");
        VirtualFile[] virtualFileArray = managingFS.getLocalRoots();
        session2.addAllFiles(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        this.refreshSessionId = session2.getId();
        session2.launch();
        return (Promise)mainTask.getPromise$intellij_platform_builtInServer_impl();
    }

    public boolean isAccessible(@NotNull HttpRequest request2) {
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        return true;
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getRequests$p(OpenFileHttpService $this) {
        return $this.requests;
    }
}

