/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetInterner;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcs.CacheableAnnotationProvider;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitDisposable;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.annotate.GitFileAnnotation;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryProvider;
import git4idea.i18n.GitBundle;
import git4idea.util.StringScanner;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class GitAnnotationProvider
implements AnnotationProviderEx,
CacheableAnnotationProvider {
    private final Project myProject;
    @NonNls
    private static final String SUBJECT_KEY = "summary";
    @NonNls
    private static final String FILENAME_KEY = "filename";
    @NonNls
    private static final String PREVIOUS_KEY = "previous";
    @NonNls
    private static final String AUTHOR_KEY = "author";
    @NonNls
    private static final String AUTHOR_EMAIL_KEY = "author-mail";
    @NonNls
    private static final String COMMITTER_TIME_KEY = "committer-time";
    @NonNls
    private static final String AUTHOR_TIME_KEY = "author-time";
    private static final Logger LOG = Logger.getInstance(GitAnnotationProvider.class);
    @NotNull
    private final VcsHistoryCache myCache;
    @NotNull
    private final VcsUserRegistry myUserRegistry;

    public GitAnnotationProvider(@NotNull Project project) {
        if (project == null) {
            GitAnnotationProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myCache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsHistoryCache();
        this.myUserRegistry = (VcsUserRegistry)ServiceManager.getService((Project)project, VcsUserRegistry.class);
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(1);
        }
        FileAnnotation fileAnnotation = this.annotate(file, null);
        if (fileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(2);
        }
        return fileAnnotation;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file, @Nullable VcsFileRevision revision) throws VcsException {
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(3);
        }
        if (file.isDirectory()) {
            throw new VcsException("Cannot annotate a directory");
        }
        if (revision == null) {
            Pair<FilePath, VcsRevisionNumber> pair = GitAnnotationProvider.getPathAndRevision(this.myProject, file);
            return this.annotate((FilePath)pair.first, (VcsRevisionNumber)pair.second, file);
        }
        FilePath filePath = ((VcsFileRevisionEx)revision).getPath();
        VcsRevisionNumber revisionNumber = revision.getRevisionNumber();
        return this.annotate(filePath, revisionNumber, file);
    }

    public boolean isAnnotationValid(@NotNull FilePath path, @NotNull VcsRevisionNumber revisionNumber) {
        if (path == null) {
            GitAnnotationProvider.$$$reportNull$$$0(4);
        }
        if (revisionNumber == null) {
            GitAnnotationProvider.$$$reportNull$$$0(5);
        }
        return GitContentRevision.getRepositoryIfSubmodule(this.myProject, path) == null;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull FilePath path, @NotNull VcsRevisionNumber revision) throws VcsException {
        if (path == null) {
            GitAnnotationProvider.$$$reportNull$$$0(6);
        }
        if (revision == null) {
            GitAnnotationProvider.$$$reportNull$$$0(7);
        }
        GitFileRevision fileRevision = new GitFileRevision(this.myProject, path, (GitRevisionNumber)revision);
        VcsVirtualFile file = new VcsVirtualFile(path.getPath(), (VcsFileRevision)fileRevision, (VirtualFileSystem)VcsFileSystem.getInstance());
        return this.annotate(path, revision, (VirtualFile)file);
    }

    private static void setProgressIndicatorText(@Nullable String text) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.setText(text);
        }
    }

    @NotNull
    private GitFileAnnotation annotate(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file) throws VcsException {
        GitFileAnnotation fileAnnotation;
        if (filePath == null) {
            GitAnnotationProvider.$$$reportNull$$$0(8);
        }
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(9);
        }
        VirtualFile root = GitUtil.getRootForFile(this.myProject, filePath);
        if (revision != null) {
            Object annotatedData = this.myCache.getAnnotation(filePath, GitVcs.getKey(), revision);
            if (annotatedData instanceof CachedData) {
                fileAnnotation = this.restoreFromCache(file, revision, (CachedData)annotatedData);
            } else {
                fileAnnotation = this.doAnnotate(root, filePath, revision, file);
                this.myCache.putAnnotation(filePath, GitVcs.getKey(), revision, (Object)GitAnnotationProvider.cacheData(fileAnnotation));
            }
        } else {
            fileAnnotation = this.doAnnotate(root, filePath, revision, file);
        }
        this.loadFileHistoryInBackground(fileAnnotation);
        this.loadCommitMessagesFromLog(root, fileAnnotation);
        GitFileAnnotation gitFileAnnotation = fileAnnotation;
        if (gitFileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(10);
        }
        return gitFileAnnotation;
    }

    @NotNull
    private GitFileAnnotation doAnnotate(@NotNull VirtualFile root, @NotNull FilePath filePath, @Nullable VcsRevisionNumber revision, @NotNull VirtualFile file) throws VcsException {
        if (root == null) {
            GitAnnotationProvider.$$$reportNull$$$0(11);
        }
        if (filePath == null) {
            GitAnnotationProvider.$$$reportNull$$$0(12);
        }
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(13);
        }
        GitAnnotationProvider.setProgressIndicatorText(GitBundle.message("computing.annotation", file.getName()));
        GitBinaryHandler h2 = new GitBinaryHandler(this.myProject, root, GitCommand.BLAME);
        h2.setStdoutSuppressed(true);
        h2.addParameters("--porcelain", "-l", "-t");
        h2.addParameters("--encoding=UTF-8");
        GitVcsApplicationSettings settings = GitVcsApplicationSettings.getInstance();
        if (settings.isIgnoreWhitespaces()) {
            h2.addParameters("-w");
        }
        if (settings.getAnnotateDetectMovementsOption() == GitVcsApplicationSettings.AnnotateDetectMovementsOption.INNER) {
            h2.addParameters("-M");
        } else if (settings.getAnnotateDetectMovementsOption() == GitVcsApplicationSettings.AnnotateDetectMovementsOption.OUTER) {
            h2.addParameters("-C");
        }
        if (revision == null) {
            h2.addParameters("HEAD");
        } else {
            h2.addParameters(revision.asString());
        }
        h2.endOptions();
        h2.addRelativePaths(filePath);
        String output = new String(h2.run(), StandardCharsets.UTF_8);
        return this.parseAnnotations(revision, file, root, output);
    }

    private void loadCommitMessagesFromLog(@NotNull VirtualFile root, @NotNull GitFileAnnotation annotation) {
        VcsLogManager logManager;
        if (root == null) {
            GitAnnotationProvider.$$$reportNull$$$0(14);
        }
        if (annotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(15);
        }
        if ((logManager = VcsProjectLog.getInstance((Project)this.myProject).getLogManager()) == null) {
            return;
        }
        VcsLogData dataManager = logManager.getDataManager();
        IndexDataGetter getter = dataManager.getIndex().getDataGetter();
        if (getter == null) {
            return;
        }
        Set revisions = ContainerUtil.map2Set(annotation.getLines(), it -> it.getRevisionNumber());
        for (GitRevisionNumber revision : revisions) {
            int commitIndex;
            String commitMessage;
            if (annotation.getCommitMessage((VcsRevisionNumber)revision) != null || (commitMessage = getter.getFullMessage(commitIndex = dataManager.getCommitIndex(HashImpl.build((String)revision.asString()), root))) == null) continue;
            annotation.setCommitMessage((VcsRevisionNumber)revision, commitMessage);
        }
    }

    private void loadFileHistoryInBackground(@NotNull GitFileAnnotation fileAnnotation) {
        List fileRevisions;
        if (fileAnnotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(16);
        }
        if ((fileRevisions = (List)BackgroundTaskUtil.computeInBackgroundAndTryWait(() -> (List)BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)GitDisposable.getInstance(this.myProject), () -> {
            try {
                VirtualFile file = fileAnnotation.getFile();
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
                VcsRevisionNumber currentRevision = fileAnnotation.getCurrentRevision();
                if (file.isInLocalFileSystem() || currentRevision == null) {
                    return this.loadFileHistory(filePath);
                }
                return GitFileHistory.collectHistoryForRevision(this.myProject, filePath, currentRevision, new String[0]);
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }), revisions -> {
            if (revisions == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                GitFileAnnotation newFileAnnotation = new GitFileAnnotation(fileAnnotation);
                newFileAnnotation.setRevisions((List<VcsFileRevision>)revisions);
                fileAnnotation.reload(newFileAnnotation);
            }, this.myProject.getDisposed());
        }, (long)300L)) != null) {
            fileAnnotation.setRevisions(fileRevisions);
        }
    }

    @Nullable
    private List<VcsFileRevision> loadFileHistory(@NotNull FilePath filePath) throws VcsException {
        if (filePath == null) {
            GitAnnotationProvider.$$$reportNull$$$0(17);
        }
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        GitHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
        VcsAbstractHistorySession cachedSession = this.myCache.getFull(filePath, vcs.getKeyInstanceMethod(), (VcsCacheableHistorySessionFactory)historyProvider);
        if (cachedSession != null && !ContainerUtil.isEmpty((Collection)cachedSession.getRevisionList())) {
            return cachedSession.getRevisionList();
        }
        VcsAbstractHistorySession session = historyProvider.createSessionFor(filePath);
        if (session == null) {
            return null;
        }
        this.myCache.put(filePath, null, vcs.getKeyInstanceMethod(), session, (VcsCacheableHistorySessionFactory)historyProvider, true);
        return session.getRevisionList();
    }

    @NotNull
    private GitFileAnnotation parseAnnotations(@Nullable VcsRevisionNumber revision, @NotNull VirtualFile file, @NotNull VirtualFile root, @NotNull String output) throws VcsException {
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(18);
        }
        if (root == null) {
            GitAnnotationProvider.$$$reportNull$$$0(19);
        }
        if (output == null) {
            GitAnnotationProvider.$$$reportNull$$$0(20);
        }
        HashSetInterner pathInterner = new HashSetInterner();
        try {
            ArrayList<GitFileAnnotation.LineInfo> lines = new ArrayList<GitFileAnnotation.LineInfo>();
            HashMap<String, GitFileAnnotation.CommitInfo> commits2 = new HashMap<String, GitFileAnnotation.CommitInfo>();
            StringScanner s = new StringScanner(output);
            while (s.hasMoreData()) {
                String commitHash = s.spaceToken();
                if (commitHash.equals(GitRevisionNumber.NOT_COMMITTED_HASH)) {
                    commitHash = null;
                }
                String s0 = s.spaceToken();
                int originalLineNum = Integer.parseInt(s0);
                String s1 = s.spaceToken();
                int lineNum = Integer.parseInt(s1);
                s.nextLine();
                GitFileAnnotation.CommitInfo commit2 = (GitFileAnnotation.CommitInfo)commits2.get(commitHash);
                if (commit2 != null || commitHash == null) {
                    while (s.hasMoreData() && !s.startsWith('\t')) {
                        s.nextLine();
                    }
                } else {
                    Date committerDate = null;
                    FilePath filePath = null;
                    String subject = null;
                    String authorName = null;
                    String authorEmail = null;
                    Date authorDate = null;
                    String previousRevision = null;
                    FilePath previousFilePath = null;
                    while (s.hasMoreData() && !s.startsWith('\t')) {
                        int index;
                        String key = s.spaceToken();
                        String value = s.line();
                        if (SUBJECT_KEY.equals(key)) {
                            subject = value;
                            continue;
                        }
                        if (AUTHOR_KEY.equals(key)) {
                            authorName = value;
                            continue;
                        }
                        if (AUTHOR_TIME_KEY.equals(key)) {
                            authorDate = GitUtil.parseTimestamp(value);
                            continue;
                        }
                        if (COMMITTER_TIME_KEY.equals(key)) {
                            committerDate = GitUtil.parseTimestamp(value);
                            continue;
                        }
                        if (FILENAME_KEY.equals(key)) {
                            filePath = VcsUtil.getFilePath((VirtualFile)root, (String)value);
                            continue;
                        }
                        if (AUTHOR_EMAIL_KEY.equals(key)) {
                            authorEmail = value;
                            if (!authorEmail.startsWith("<") || !authorEmail.endsWith(">")) continue;
                            authorEmail = authorEmail.substring(1, authorEmail.length() - 1);
                            continue;
                        }
                        if (!PREVIOUS_KEY.equals(key) || (index = value.indexOf(32)) == -1) continue;
                        previousRevision = value.substring(0, index);
                        previousFilePath = VcsUtil.getFilePath((VirtualFile)root, (String)value.substring(index + 1));
                    }
                    if (authorDate == null || committerDate == null || filePath == null || authorName == null || authorEmail == null || subject == null) {
                        throw new VcsException("Output for line " + lineNum + " lacks necessary data");
                    }
                    GitRevisionNumber revisionNumber = new GitRevisionNumber(commitHash);
                    VcsUser author = this.myUserRegistry.createUser(authorName, authorEmail);
                    GitRevisionNumber previousRevisionNumber = previousRevision != null ? new GitRevisionNumber(previousRevision) : null;
                    filePath = (FilePath)pathInterner.intern(filePath);
                    if (previousFilePath != null) {
                        previousFilePath = (FilePath)pathInterner.intern(previousFilePath);
                    }
                    commit2 = new GitFileAnnotation.CommitInfo(this.myProject, revisionNumber, filePath, committerDate, authorDate, author, subject, previousRevisionNumber, previousFilePath);
                    commits2.put(commitHash, commit2);
                }
                s.nextLine();
                int expectedLineNum = lines.size() + 1;
                if (lineNum != expectedLineNum) {
                    throw new VcsException("Adding for info for line " + lineNum + " but we are expecting it to be for " + expectedLineNum);
                }
                GitFileAnnotation.LineInfo lineInfo = new GitFileAnnotation.LineInfo(commit2, lineNum, originalLineNum);
                lines.add(lineInfo);
            }
            return new GitFileAnnotation(this.myProject, file, revision, lines);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Couldn't parse annotation: " + e.getMessage(), (Throwable)e, new Attachment[]{new Attachment("output.txt", output)});
            throw new VcsException((Throwable)e);
        }
    }

    public void populateCache(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(21);
        }
        Pair<FilePath, VcsRevisionNumber> pair = GitAnnotationProvider.getPathAndRevision(this.myProject, file);
        FilePath filePath = (FilePath)pair.first;
        VcsRevisionNumber revision = (VcsRevisionNumber)pair.second;
        if (revision == null) {
            return;
        }
        Object annotatedData = this.myCache.getAnnotation(filePath, GitVcs.getKey(), revision);
        if (annotatedData instanceof CachedData) {
            return;
        }
        VirtualFile root = GitUtil.getRootForFile(this.myProject, filePath);
        GitFileAnnotation fileAnnotation = this.doAnnotate(root, filePath, revision, file);
        this.myCache.putAnnotation(filePath, GitVcs.getKey(), revision, (Object)GitAnnotationProvider.cacheData(fileAnnotation));
    }

    @NotNull
    private GitFileAnnotation restoreFromCache(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber, @NotNull CachedData data) {
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(22);
        }
        if (data == null) {
            GitAnnotationProvider.$$$reportNull$$$0(23);
        }
        return new GitFileAnnotation(this.myProject, file, revisionNumber, data.lines);
    }

    private static Pair<FilePath, VcsRevisionNumber> getPathAndRevision(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            GitAnnotationProvider.$$$reportNull$$$0(24);
        }
        if (file == null) {
            GitAnnotationProvider.$$$reportNull$$$0(25);
        }
        FilePath filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file));
        VcsRevisionNumber revisionNumber = GitVcs.getInstance(project).getDiffProvider().getCurrentRevision(file);
        return Pair.create((Object)filePath, (Object)revisionNumber);
    }

    @NotNull
    private static CachedData cacheData(@NotNull GitFileAnnotation annotation) {
        if (annotation == null) {
            GitAnnotationProvider.$$$reportNull$$$0(26);
        }
        return new CachedData(annotation.getLines());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/annotate/GitAnnotationProvider";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 8: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 11: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAnnotation";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/annotate/GitAnnotationProvider";
                break;
            }
            case 2: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationValid";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doAnnotate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadCommitMessagesFromLog";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadFileHistoryInBackground";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadFileHistory";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseAnnotations";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "populateCache";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "restoreFromCache";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPathAndRevision";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "cacheData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedData {
        public final List<GitFileAnnotation.LineInfo> lines;

        CachedData(List<GitFileAnnotation.LineInfo> lines) {
            this.lines = lines;
        }
    }
}

