/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.ChildrenDescriptionsHolder;
import com.intellij.util.xml.impl.CollectionChildDescriptionImpl;
import com.intellij.util.xml.impl.CustomDomChildrenDescriptionImpl;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtenderEP;
import com.intellij.util.xml.reflect.DomExtensionImpl;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.intellij.util.xml.reflect.DomExtensionsRegistrarImpl;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import gnu.trove.THashSet;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicGenericInfo
extends DomGenericInfoEx {
    private static final Key<SoftReference<Interner<ChildrenDescriptionsHolder<?>>>> HOLDERS_CACHE = Key.create((String)"DOM_CHILDREN_HOLDERS_CACHE");
    private final StaticGenericInfo myStaticGenericInfo;
    @NotNull
    private final DomInvocationHandler myInvocationHandler;
    private volatile boolean myInitialized;
    private volatile ChildrenDescriptionsHolder<AttributeChildDescriptionImpl> myAttributes;
    private volatile ChildrenDescriptionsHolder<FixedChildDescriptionImpl> myFixeds;
    private volatile ChildrenDescriptionsHolder<CollectionChildDescriptionImpl> myCollections;
    private volatile List<CustomDomChildrenDescriptionImpl> myCustomChildren;

    public DynamicGenericInfo(@NotNull DomInvocationHandler handler, StaticGenericInfo staticGenericInfo) {
        if (handler == null) {
            DynamicGenericInfo.$$$reportNull$$$0(0);
        }
        this.myInvocationHandler = handler;
        this.myStaticGenericInfo = staticGenericInfo;
        this.myAttributes = staticGenericInfo.getAttributes();
        this.myFixeds = staticGenericInfo.getFixed();
        this.myCollections = staticGenericInfo.getCollections();
    }

    @Override
    public final boolean checkInitialized() {
        if (this.myInitialized) {
            return true;
        }
        this.myStaticGenericInfo.buildMethodMaps();
        if (!this.myInvocationHandler.exists()) {
            return true;
        }
        boolean fromIndexing = FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() != null;
        return RecursionManager.doPreventingRecursion((Object)Pair.create((Object)((Object)this.myInvocationHandler), (Object)fromIndexing), (boolean)false, () -> {
            DomExtensionsRegistrarImpl registrar = this.runDomExtenders();
            DomInvocationHandler domInvocationHandler = this.myInvocationHandler;
            synchronized (domInvocationHandler) {
                if (!this.myInitialized) {
                    if (registrar != null) {
                        this.applyExtensions(registrar);
                    }
                    this.myInitialized = true;
                }
            }
            return Boolean.TRUE;
        }) == Boolean.TRUE;
    }

    private void applyExtensions(DomExtensionsRegistrarImpl registrar) {
        List<DomExtensionImpl> customs;
        XmlFile file = this.myInvocationHandler.getFile();
        List<DomExtensionImpl> fixeds = registrar.getFixeds();
        List<DomExtensionImpl> collections = registrar.getCollections();
        List<DomExtensionImpl> attributes = registrar.getAttributes();
        if (!attributes.isEmpty()) {
            ChildrenDescriptionsHolder<AttributeChildDescriptionImpl> newAttributes = new ChildrenDescriptionsHolder<AttributeChildDescriptionImpl>(this.myStaticGenericInfo.getAttributes());
            for (DomExtensionImpl extension : attributes) {
                newAttributes.addDescription(extension.addAnnotations(new AttributeChildDescriptionImpl(extension.getXmlName(), extension.getType())));
            }
            this.myAttributes = DynamicGenericInfo.internChildrenHolder(file, newAttributes);
        }
        if (!fixeds.isEmpty()) {
            ChildrenDescriptionsHolder<FixedChildDescriptionImpl> newFixeds = new ChildrenDescriptionsHolder<FixedChildDescriptionImpl>(this.myStaticGenericInfo.getFixed());
            for (DomExtensionImpl extension : fixeds) {
                newFixeds.addDescription(extension.addAnnotations(new FixedChildDescriptionImpl(extension.getXmlName(), extension.getType(), extension.getCount(), ArrayUtilRt.EMPTY_COLLECTION_ARRAY)));
            }
            this.myFixeds = DynamicGenericInfo.internChildrenHolder(file, newFixeds);
        }
        if (!collections.isEmpty()) {
            ChildrenDescriptionsHolder<CollectionChildDescriptionImpl> newCollections = new ChildrenDescriptionsHolder<CollectionChildDescriptionImpl>(this.myStaticGenericInfo.getCollections());
            for (DomExtensionImpl extension : collections) {
                newCollections.addDescription(extension.addAnnotations(new CollectionChildDescriptionImpl(extension.getXmlName(), extension.getType(), Collections.emptyList())));
            }
            this.myCollections = DynamicGenericInfo.internChildrenHolder(file, newCollections);
        }
        this.myCustomChildren = (customs = registrar.getCustoms()).isEmpty() ? null : ContainerUtil.map(customs, CustomDomChildrenDescriptionImpl::new);
    }

    private static <T extends DomChildDescriptionImpl> ChildrenDescriptionsHolder<T> internChildrenHolder(XmlFile file, ChildrenDescriptionsHolder<T> holder) {
        SoftReference ref = (SoftReference)file.getUserData(HOLDERS_CACHE);
        Interner cache = (Interner)SoftReference.dereference((Reference)ref);
        if (cache == null) {
            cache = Interner.createWeakInterner();
            file.putUserData(HOLDERS_CACHE, (Object)new SoftReference((Object)cache));
        }
        return (ChildrenDescriptionsHolder)cache.intern(holder);
    }

    @Nullable
    private DomExtensionsRegistrarImpl runDomExtenders() {
        List<DomExtender<?>> extendersFromParent;
        DomExtensionsRegistrarImpl registrar = null;
        Project project = this.myInvocationHandler.getManager().getProject();
        for (DomExtenderEP extenderEP : DomExtenderEP.EP_NAME.getExtensionList()) {
            registrar = extenderEP.extend(project, this.myInvocationHandler, registrar);
        }
        AbstractDomChildDescriptionImpl description = this.myInvocationHandler.getChildDescription();
        if (description != null && (extendersFromParent = description.getUserData(DomExtensionImpl.DOM_EXTENDER_KEY)) != null) {
            if (registrar == null) {
                registrar = new DomExtensionsRegistrarImpl();
            }
            for (DomExtender<?> extender : extendersFromParent) {
                extender.registerExtensions(this.myInvocationHandler.getProxy(), (DomExtensionsRegistrar)registrar);
            }
        }
        return registrar;
    }

    public GenericDomValue<?> getNameDomElement(DomElement element) {
        return this.myStaticGenericInfo.getNameDomElement(element);
    }

    @NotNull
    public List<? extends CustomDomChildrenDescription> getCustomNameChildrenDescription() {
        this.checkInitialized();
        if (this.myCustomChildren != null) {
            List<CustomDomChildrenDescriptionImpl> list = this.myCustomChildren;
            if (list == null) {
                DynamicGenericInfo.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<? extends CustomDomChildrenDescriptionImpl> list = this.myStaticGenericInfo.getCustomNameChildrenDescription();
        if (list == null) {
            DynamicGenericInfo.$$$reportNull$$$0(2);
        }
        return list;
    }

    public String getElementName(DomElement element) {
        return this.myStaticGenericInfo.getElementName(element);
    }

    @NotNull
    public List<AbstractDomChildDescriptionImpl> getChildrenDescriptions() {
        this.checkInitialized();
        ArrayList<AbstractDomChildDescriptionImpl> list = new ArrayList<AbstractDomChildDescriptionImpl>();
        this.myAttributes.dumpDescriptions(list);
        this.myFixeds.dumpDescriptions(list);
        this.myCollections.dumpDescriptions(list);
        list.addAll(this.myStaticGenericInfo.getCustomNameChildrenDescription());
        ArrayList<AbstractDomChildDescriptionImpl> arrayList = list;
        if (arrayList == null) {
            DynamicGenericInfo.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public final List<FixedChildDescriptionImpl> getFixedChildrenDescriptions() {
        this.checkInitialized();
        List<FixedChildDescriptionImpl> list = this.myFixeds.getDescriptions();
        if (list == null) {
            DynamicGenericInfo.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public final List<CollectionChildDescriptionImpl> getCollectionChildrenDescriptions() {
        this.checkInitialized();
        List<CollectionChildDescriptionImpl> list = this.myCollections.getDescriptions();
        if (list == null) {
            DynamicGenericInfo.$$$reportNull$$$0(5);
        }
        return list;
    }

    public FixedChildDescriptionImpl getFixedChildDescription(String tagName) {
        this.checkInitialized();
        return this.myFixeds.findDescription(tagName);
    }

    public DomFixedChildDescription getFixedChildDescription(@NonNls String tagName, @NonNls String namespace) {
        this.checkInitialized();
        return this.myFixeds.getDescription(tagName, namespace);
    }

    public CollectionChildDescriptionImpl getCollectionChildDescription(String tagName) {
        this.checkInitialized();
        return this.myCollections.findDescription(tagName);
    }

    public DomCollectionChildDescription getCollectionChildDescription(@NonNls String tagName, @NonNls String namespace) {
        this.checkInitialized();
        return this.myCollections.getDescription(tagName, namespace);
    }

    public AttributeChildDescriptionImpl getAttributeChildDescription(String attributeName) {
        this.checkInitialized();
        return this.myAttributes.findDescription(attributeName);
    }

    public DomAttributeChildDescription<?> getAttributeChildDescription(@NonNls String attributeName, @NonNls String namespace) {
        this.checkInitialized();
        return this.myAttributes.getDescription(attributeName, namespace);
    }

    public boolean isTagValueElement() {
        return this.myStaticGenericInfo.isTagValueElement();
    }

    @Override
    @NotNull
    public List<AttributeChildDescriptionImpl> getAttributeChildrenDescriptions() {
        this.checkInitialized();
        List<AttributeChildDescriptionImpl> list = this.myAttributes.getDescriptions();
        if (list == null) {
            DynamicGenericInfo.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public boolean processAttributeChildrenDescriptions(Processor<? super AttributeChildDescriptionImpl> processor) {
        THashSet visited = new THashSet();
        if (!this.myStaticGenericInfo.processAttributeChildrenDescriptions((Processor<? super AttributeChildDescriptionImpl>)((Processor)arg_0 -> DynamicGenericInfo.lambda$processAttributeChildrenDescriptions$1((Set)visited, processor, arg_0)))) {
            return false;
        }
        for (AttributeChildDescriptionImpl description : this.getAttributeChildrenDescriptions()) {
            if (visited.contains(description) || processor.process((Object)description)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$processAttributeChildrenDescriptions$1(Set visited, Processor processor, AttributeChildDescriptionImpl attributeChildDescription) {
        visited.add(attributeChildDescription);
        return processor.process((Object)attributeChildDescription);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DynamicGenericInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DynamicGenericInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomNameChildrenDescription";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenDescriptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixedChildrenDescriptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionChildrenDescriptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeChildrenDescriptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

