/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.BuildNumber;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;
import org.jetbrains.ide.StartUpMeasurementServiceKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/ide/StartUpMeasurementService;", "Lorg/jetbrains/ide/RestService;", "()V", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "isAccessible", "", "Lio/netty/handler/codec/http/HttpRequest;", "isHostTrusted", "intellij.platform.builtInServer.impl"})
public final class StartUpMeasurementService
extends RestService {
    @Override
    @NotNull
    protected String getServiceName() {
        return "startUpMeasurement";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        if (super.isAccessible(request)) {
            return true;
        }
        if (!StartUpMeasurementServiceKt.access$isTrustedHostName(request)) return false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isInternal()) return true;
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfoEx, (String)"ApplicationInfoEx.getInstanceEx()");
        BuildNumber buildNumber = applicationInfoEx.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfoEx.getInstanceEx().build");
        if (!buildNumber.isSnapshot()) return false;
        return true;
    }

    @Override
    protected boolean isHostTrusted(@NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        return StartUpMeasurementServiceKt.access$isTrustedHostName((HttpRequest)request) || super.isHostTrusted(request, urlDecoder);
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        StartUpPerformanceService startUpPerformanceService = StartUpPerformanceService.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)startUpPerformanceService, (String)"StartUpPerformanceService.getInstance()");
        StartUpPerformanceService reporter = startUpPerformanceService;
        ByteBuffer byteBuffer = reporter.getLastReport();
        if (byteBuffer == null) {
            return "{\"error\": \"Report is not ready yet, start-up in progress\"}";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"reporter.lastReport ?: r\u2026start-up in progress\"}\"\"\"");
        ByteBuffer lastReport = byteBuffer;
        FullHttpResponse response = Responses.response((String)"application/json", (ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)lastReport));
        RestService.Companion.sendResponse((HttpRequest)request, context, (HttpResponse)response);
        return null;
    }
}

