/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.JpsExcludePattern;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsExcludePatternImpl;
import org.jetbrains.jps.model.impl.JpsUrlListRole;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryCollectionImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.module.impl.JpsDependenciesListImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleReferenceImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootRole;
import org.jetbrains.jps.model.module.impl.JpsSdkReferencesTableImpl;

public class JpsModuleImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsModuleImpl<P>>
implements JpsTypedModule<P> {
    private static final JpsUrlListRole CONTENT_ROOTS_ROLE = new JpsUrlListRole("content roots");
    private static final JpsUrlListRole EXCLUDED_ROOTS_ROLE = new JpsUrlListRole("excluded roots");
    private static final JpsElementChildRole<JpsDependenciesListImpl> DEPENDENCIES_LIST_CHILD_ROLE = JpsElementChildRoleBase.create((String)"dependencies");
    private static final JpsElementCollectionRole<JpsExcludePattern> EXCLUDE_PATTERNS_ROLE = JpsElementCollectionRole.create((JpsElementChildRole)JpsElementChildRoleBase.create((String)"exclude patterns"));
    private final JpsModuleType<P> myModuleType;
    private final JpsLibraryCollection myLibraryCollection;

    public JpsModuleImpl(JpsModuleType<P> type, @NotNull String name, @NotNull P properties) {
        if (name == null) {
            JpsModuleImpl.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            JpsModuleImpl.$$$reportNull$$$0(1);
        }
        super(name);
        this.myModuleType = type;
        this.myContainer.setChild(this.myModuleType.getPropertiesRole(), properties);
        this.myContainer.setChild((JpsElementChildRole)CONTENT_ROOTS_ROLE);
        this.myContainer.setChild((JpsElementChildRole)EXCLUDED_ROOTS_ROLE);
        this.myContainer.setChild(DEPENDENCIES_LIST_CHILD_ROLE, (JpsElement)new JpsDependenciesListImpl());
        this.getDependenciesList().addModuleSourceDependency();
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.setChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
        this.myContainer.setChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE);
        this.myContainer.setChild((JpsElementChildRole)JpsSdkReferencesTableImpl.ROLE);
    }

    private JpsModuleImpl(JpsModuleImpl<P> original) {
        super(original);
        this.myModuleType = original.myModuleType;
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    @NotNull
    public JpsModuleImpl<P> createCopy() {
        return new JpsModuleImpl<P>(this);
    }

    public JpsElementType<P> getType() {
        return this.myModuleType;
    }

    @NotNull
    public P getProperties() {
        JpsElement jpsElement = this.myContainer.getChild(this.myModuleType.getPropertiesRole());
        if (jpsElement == null) {
            JpsModuleImpl.$$$reportNull$$$0(2);
        }
        return (P)jpsElement;
    }

    public <P extends JpsElement> JpsTypedModule<P> asTyped(@NotNull JpsModuleType<P> type) {
        if (type == null) {
            JpsModuleImpl.$$$reportNull$$$0(3);
        }
        return this.myModuleType.equals(type) ? this : null;
    }

    @NotNull
    public JpsUrlList getContentRootsList() {
        JpsUrlList jpsUrlList = (JpsUrlList)this.myContainer.getChild((JpsElementChildRole)CONTENT_ROOTS_ROLE);
        if (jpsUrlList == null) {
            JpsModuleImpl.$$$reportNull$$$0(4);
        }
        return jpsUrlList;
    }

    @NotNull
    public JpsUrlList getExcludeRootsList() {
        JpsUrlList jpsUrlList = (JpsUrlList)this.myContainer.getChild((JpsElementChildRole)EXCLUDED_ROOTS_ROLE);
        if (jpsUrlList == null) {
            JpsModuleImpl.$$$reportNull$$$0(5);
        }
        return jpsUrlList;
    }

    @NotNull
    public List<JpsModuleSourceRoot> getSourceRoots() {
        List list = ((JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE)).getElements();
        if (list == null) {
            JpsModuleImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public <P extends JpsElement> Iterable<JpsTypedModuleSourceRoot<P>> getSourceRoots(@NotNull JpsModuleSourceRootType<P> type) {
        if (type == null) {
            JpsModuleImpl.$$$reportNull$$$0(7);
        }
        Iterable iterable = ((JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE)).getElementsOfType(type);
        if (iterable == null) {
            JpsModuleImpl.$$$reportNull$$$0(8);
        }
        return iterable;
    }

    @NotNull
    public <P extends JpsElement> JpsModuleSourceRoot addSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType<P> rootType) {
        if (url == null) {
            JpsModuleImpl.$$$reportNull$$$0(9);
        }
        if (rootType == null) {
            JpsModuleImpl.$$$reportNull$$$0(10);
        }
        JpsModuleSourceRoot jpsModuleSourceRoot = this.addSourceRoot(url, rootType, (JpsElement)rootType.createDefaultProperties());
        if (jpsModuleSourceRoot == null) {
            JpsModuleImpl.$$$reportNull$$$0(11);
        }
        return jpsModuleSourceRoot;
    }

    @NotNull
    public <P extends JpsElement> JpsModuleSourceRoot addSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType<P> rootType, @NotNull P properties) {
        if (url == null) {
            JpsModuleImpl.$$$reportNull$$$0(12);
        }
        if (rootType == null) {
            JpsModuleImpl.$$$reportNull$$$0(13);
        }
        if (properties == null) {
            JpsModuleImpl.$$$reportNull$$$0(14);
        }
        JpsModuleSourceRootImpl<P> root = new JpsModuleSourceRootImpl<P>(url, rootType, properties);
        this.addSourceRoot((JpsModuleSourceRoot)root);
        JpsModuleSourceRootImpl<P> jpsModuleSourceRootImpl = root;
        if (jpsModuleSourceRootImpl == null) {
            JpsModuleImpl.$$$reportNull$$$0(15);
        }
        return jpsModuleSourceRootImpl;
    }

    public void addSourceRoot(@NotNull JpsModuleSourceRoot root) {
        if (root == null) {
            JpsModuleImpl.$$$reportNull$$$0(16);
        }
        ((JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE)).addChild((JpsElement)root);
    }

    public void removeSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType rootType) {
        if (url == null) {
            JpsModuleImpl.$$$reportNull$$$0(17);
        }
        if (rootType == null) {
            JpsModuleImpl.$$$reportNull$$$0(18);
        }
        JpsElementCollection roots = (JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE);
        for (JpsModuleSourceRoot root : roots.getElements()) {
            if (!root.getRootType().equals(rootType) || !root.getUrl().equals(url)) continue;
            roots.removeChild((JpsElement)root);
            break;
        }
    }

    public void addExcludePattern(@NotNull String baseDirUrl, @NotNull String pattern) {
        if (baseDirUrl == null) {
            JpsModuleImpl.$$$reportNull$$$0(19);
        }
        if (pattern == null) {
            JpsModuleImpl.$$$reportNull$$$0(20);
        }
        ((JpsElementCollection)this.myContainer.getOrSetChild(EXCLUDE_PATTERNS_ROLE)).addChild((JpsElement)new JpsExcludePatternImpl(baseDirUrl, pattern));
    }

    public void removeExcludePattern(@NotNull String baseDirUrl, @NotNull String pattern) {
        JpsElementCollection child;
        if (baseDirUrl == null) {
            JpsModuleImpl.$$$reportNull$$$0(21);
        }
        if (pattern == null) {
            JpsModuleImpl.$$$reportNull$$$0(22);
        }
        if ((child = (JpsElementCollection)this.myContainer.getChild(EXCLUDE_PATTERNS_ROLE)) != null) {
            for (JpsExcludePattern excludePattern : child.getElements()) {
                if (!excludePattern.getBaseDirUrl().equals(baseDirUrl) || !excludePattern.getPattern().equals(pattern)) continue;
                child.removeChild((JpsElement)excludePattern);
            }
        }
    }

    public List<JpsExcludePattern> getExcludePatterns() {
        JpsElementCollection child = (JpsElementCollection)this.myContainer.getChild(EXCLUDE_PATTERNS_ROLE);
        return child != null ? child.getElements() : Collections.emptyList();
    }

    @NotNull
    public JpsDependenciesList getDependenciesList() {
        JpsDependenciesList jpsDependenciesList = (JpsDependenciesList)this.myContainer.getChild(DEPENDENCIES_LIST_CHILD_ROLE);
        if (jpsDependenciesList == null) {
            JpsModuleImpl.$$$reportNull$$$0(23);
        }
        return jpsDependenciesList;
    }

    @NotNull
    public JpsSdkReferencesTable getSdkReferencesTable() {
        JpsSdkReferencesTable jpsSdkReferencesTable = (JpsSdkReferencesTable)this.myContainer.getChild((JpsElementChildRole)JpsSdkReferencesTableImpl.ROLE);
        if (jpsSdkReferencesTable == null) {
            JpsModuleImpl.$$$reportNull$$$0(24);
        }
        return jpsSdkReferencesTable;
    }

    public <P extends JpsElement> JpsSdkReference<P> getSdkReference(@NotNull JpsSdkType<P> type) {
        JpsSdkReference sdkReference;
        if (type == null) {
            JpsModuleImpl.$$$reportNull$$$0(25);
        }
        if ((sdkReference = this.getSdkReferencesTable().getSdkReference(type)) != null) {
            return sdkReference;
        }
        JpsProject project = this.getProject();
        if (project != null) {
            return project.getSdkReferencesTable().getSdkReference(type);
        }
        return null;
    }

    public <P extends JpsElement> JpsSdk<P> getSdk(@NotNull JpsSdkType<P> type) {
        JpsSdkReference<P> reference;
        if (type == null) {
            JpsModuleImpl.$$$reportNull$$$0(26);
        }
        if ((reference = this.getSdkReference(type)) == null) {
            return null;
        }
        JpsTypedLibrary library = (JpsTypedLibrary)reference.resolve();
        return library != null ? (JpsSdk)library.getProperties() : null;
    }

    public void delete() {
        ((JpsElementCollection)this.myParent).removeChild((JpsElement)this);
    }

    @NotNull
    public JpsModuleReference createReference() {
        return new JpsModuleReferenceImpl(this.getName());
    }

    @NotNull
    public <P extends JpsElement, Type extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addModuleLibrary(@NotNull String name, @NotNull Type type) {
        if (name == null) {
            JpsModuleImpl.$$$reportNull$$$0(27);
        }
        if (type == null) {
            JpsModuleImpl.$$$reportNull$$$0(28);
        }
        JpsLibrary jpsLibrary = this.myLibraryCollection.addLibrary(name, type);
        if (jpsLibrary == null) {
            JpsModuleImpl.$$$reportNull$$$0(29);
        }
        return jpsLibrary;
    }

    public void addModuleLibrary(@NotNull JpsLibrary library) {
        if (library == null) {
            JpsModuleImpl.$$$reportNull$$$0(30);
        }
        this.myLibraryCollection.addLibrary(library);
    }

    @NotNull
    public JpsLibraryCollection getLibraryCollection() {
        JpsLibraryCollection jpsLibraryCollection = this.myLibraryCollection;
        if (jpsLibraryCollection == null) {
            JpsModuleImpl.$$$reportNull$$$0(31);
        }
        return jpsLibraryCollection;
    }

    @Nullable
    public JpsProject getProject() {
        JpsModel model = this.getModel();
        return model != null ? model.getProject() : null;
    }

    @NotNull
    public JpsModuleType<P> getModuleType() {
        JpsModuleType<P> jpsModuleType = this.myModuleType;
        if (jpsModuleType == null) {
            JpsModuleImpl.$$$reportNull$$$0(32);
        }
        return jpsModuleType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 23: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 23: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 23: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/module/impl/JpsModuleImpl";
                break;
            }
            case 3: 
            case 7: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirUrl";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/module/impl/JpsModuleImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootsList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeRootsList";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceRoot";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesList";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkReferencesTable";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "addModuleLibrary";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryCollection";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 23: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "asTyped";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRoot";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceRoot";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addExcludePattern";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludePattern";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSdkReference";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSdk";
                break;
            }
            case 27: 
            case 28: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addModuleLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 23: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

