/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.util;

import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.data.GithubResponsePage;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00040\fH\u0007\u00a2\u0006\u0002\u0010\rJ:\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00040\u000f\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00040\u000f\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\nH\u0007JF\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\n2\u0018\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u000f\u0012\u0004\u0012\u00020\u00130\u0015H\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader;", "", "()V", "find", "T", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "pagesRequest", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "predicate", "Ljava/util/function/Predicate;", "(Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;Ljava/util/function/Predicate;)Ljava/lang/Object;", "load", "", "maximum", "", "loadAll", "", "pageItemsConsumer", "Lkotlin/Function1;", "Request", "intellij.vcs.github"})
public final class GithubApiPagesLoader {
    public static final GithubApiPagesLoader INSTANCE;

    @JvmStatic
    @NotNull
    public static final <T> List<T> loadAll(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull Request<T> pagesRequest) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull(pagesRequest, (String)"pagesRequest");
        boolean bl = false;
        List result = new ArrayList();
        GithubApiPagesLoader.loadAll(executor, indicator, pagesRequest, (Function1)new Function1<List<? extends T>, Unit>(result){
            final /* synthetic */ List $result;

            public final void invoke(@NotNull List<? extends T> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.$result.addAll((Collection)it);
            }
            {
                this.$result = list2;
                super(1);
            }
        });
        return result;
    }

    @JvmStatic
    public static final <T> void loadAll(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull Request<T> pagesRequest, @NotNull Function1<? super List<? extends T>, Unit> pageItemsConsumer2) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull(pagesRequest, (String)"pagesRequest");
        Intrinsics.checkParameterIsNotNull(pageItemsConsumer2, (String)"pageItemsConsumer");
        GithubApiRequest<GithubResponsePage<T>> request = pagesRequest.getInitialRequest();
        while (request != null) {
            GithubApiRequest githubApiRequest;
            GithubResponsePage<T> page = executor.execute(indicator, request);
            pageItemsConsumer2.invoke(page.getItems());
            if (page.getNextLink() != null) {
                String string;
                Function1<String, GithubApiRequest<GithubResponsePage<T>>> function1 = pagesRequest.getUrlRequestProvider();
                boolean bl = false;
                boolean bl2 = false;
                githubApiRequest = (GithubApiRequest)function1.invoke((Object)string);
            } else {
                githubApiRequest = null;
            }
            request = githubApiRequest;
        }
    }

    @JvmStatic
    @Nullable
    public static final <T> T find(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull Request<T> pagesRequest, @NotNull Predicate<T> predicate) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull(pagesRequest, (String)"pagesRequest");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        GithubApiRequest<GithubResponsePage<T>> request = pagesRequest.getInitialRequest();
        while (request != null) {
            GithubApiRequest githubApiRequest;
            Object v0;
            boolean bl;
            boolean bl2;
            Object object;
            GithubResponsePage<T> page;
            block5: {
                page = executor.execute(indicator, request);
                object = page.getItems();
                bl2 = false;
                Iterable iterable = object;
                bl = false;
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Object t;
                    Object it = t = iterator.next();
                    boolean bl3 = false;
                    if (!predicate.test(it)) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            if (v0 != null) {
                object = v0;
                bl2 = false;
                boolean bl4 = false;
                Iterable it = object;
                boolean bl5 = false;
                return (T)it;
            }
            String string = page.getNextLink();
            if (string != null) {
                object = string;
                Function1<String, GithubApiRequest<GithubResponsePage<T>>> function1 = pagesRequest.getUrlRequestProvider();
                boolean bl6 = false;
                bl = false;
                githubApiRequest = (GithubApiRequest)function1.invoke(object);
            } else {
                githubApiRequest = null;
            }
            request = githubApiRequest;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> load(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull Request<T> pagesRequest, int maximum) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        Intrinsics.checkParameterIsNotNull(pagesRequest, (String)"pagesRequest");
        boolean bl = false;
        List result = new ArrayList();
        GithubApiRequest<GithubResponsePage<T>> request = pagesRequest.getInitialRequest();
        while (request != null) {
            GithubApiRequest githubApiRequest;
            GithubResponsePage<T> page = executor.execute(indicator, request);
            for (T item : page.getItems()) {
                result.add(item);
                if (result.size() != maximum) continue;
                return result;
            }
            if (page.getNextLink() != null) {
                String string;
                Iterator<T> iterator = pagesRequest.getUrlRequestProvider();
                boolean bl2 = false;
                boolean bl3 = false;
                githubApiRequest = (GithubApiRequest)iterator.invoke(string);
            } else {
                githubApiRequest = null;
            }
            request = githubApiRequest;
        }
        return result;
    }

    private GithubApiPagesLoader() {
    }

    static {
        GithubApiPagesLoader githubApiPagesLoader;
        INSTANCE = githubApiPagesLoader = new GithubApiPagesLoader();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B9\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u00040\u0007\u00a2\u0006\u0002\u0010\tR\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR)\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "T", "", "initialRequest", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "urlRequestProvider", "Lkotlin/Function1;", "", "(Lorg/jetbrains/plugins/github/api/GithubApiRequest;Lkotlin/jvm/functions/Function1;)V", "getInitialRequest", "()Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "getUrlRequestProvider", "()Lkotlin/jvm/functions/Function1;", "intellij.vcs.github"})
    public static final class Request<T> {
        @NotNull
        private final GithubApiRequest<GithubResponsePage<T>> initialRequest;
        @NotNull
        private final Function1<String, GithubApiRequest<GithubResponsePage<T>>> urlRequestProvider;

        @NotNull
        public final GithubApiRequest<GithubResponsePage<T>> getInitialRequest() {
            return this.initialRequest;
        }

        @NotNull
        public final Function1<String, GithubApiRequest<GithubResponsePage<T>>> getUrlRequestProvider() {
            return this.urlRequestProvider;
        }

        public Request(@NotNull GithubApiRequest<GithubResponsePage<T>> initialRequest, @NotNull Function1<? super String, ? extends GithubApiRequest<GithubResponsePage<T>>> urlRequestProvider) {
            Intrinsics.checkParameterIsNotNull(initialRequest, (String)"initialRequest");
            Intrinsics.checkParameterIsNotNull(urlRequestProvider, (String)"urlRequestProvider");
            this.initialRequest = initialRequest;
            this.urlRequestProvider = urlRequestProvider;
        }
    }
}

