/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorEmbeddedComponentManager;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u00060\u000bR\u00020\u0000\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "editorWidthWatcher", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager$EditorTextWidthWatcher;", "managedInlays", "", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager$ComponentWrapper;", "dispose", "", "insertAfter", "lineIndex", "", "component", "Ljavax/swing/JComponent;", "ComponentWrapper", "EditorTextWidthWatcher", "intellij.vcs.github"})
public final class EditorComponentInlaysManager
implements Disposable {
    private final Map<ComponentWrapper, Disposable> managedInlays;
    private final EditorTextWidthWatcher editorWidthWatcher;
    @NotNull
    private final EditorImpl editor;

    @Nullable
    public final Disposable insertAfter(int lineIndex, @NotNull JComponent component) {
        Inlay inlay;
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        if (Disposer.isDisposed((Disposable)this)) {
            return null;
        }
        ComponentWrapper wrappedComponent = new ComponentWrapper(component);
        int offset = this.editor.getDocument().getLineEndOffset(lineIndex);
        Inlay inlay2 = EditorEmbeddedComponentManager.getInstance().addComponent((EditorEx)this.editor, (JComponent)((Object)wrappedComponent), new EditorEmbeddedComponentManager.Properties(EditorEmbeddedComponentManager.ResizePolicy.none(), null, true, false, 0, offset));
        if (inlay2 != null) {
            Inlay inlay3 = inlay2;
            boolean bl = false;
            boolean bl2 = false;
            Inlay it = inlay3;
            boolean bl3 = false;
            Inlay inlay4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)inlay4, (String)"it");
            this.managedInlays.put(wrappedComponent, (Disposable)inlay4);
            Disposer.register((Disposable)((Disposable)it), (Disposable)new Disposable(this, wrappedComponent){
                final /* synthetic */ EditorComponentInlaysManager this$0;
                final /* synthetic */ ComponentWrapper $wrappedComponent$inlined;
                {
                    this.this$0 = editorComponentInlaysManager;
                    this.$wrappedComponent$inlined = componentWrapper;
                }

                public final void dispose() {
                    EditorComponentInlaysManager.access$getManagedInlays$p(this.this$0).remove((Object)((Object)this.$wrappedComponent$inlined));
                }
            });
            inlay = inlay3;
        } else {
            inlay = null;
        }
        return (Disposable)inlay;
    }

    public void dispose() {
        Iterable $this$forEach$iv = this.managedInlays.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable p1 = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)p1);
        }
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public EditorComponentInlaysManager(@NotNull EditorImpl editor) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.editor = editor;
        EditorComponentInlaysManager editorComponentInlaysManager = this;
        boolean bl = false;
        editorComponentInlaysManager.managedInlays = map2 = (Map)new LinkedHashMap();
        this.editorWidthWatcher = new EditorTextWidthWatcher();
        JScrollPane jScrollPane = this.editor.getScrollPane();
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"editor.scrollPane");
        jScrollPane.getViewport().addComponentListener(this.editorWidthWatcher);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public final void dispose() {
                JScrollPane jScrollPane = this.getEditor().getScrollPane();
                Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"editor.scrollPane");
                jScrollPane.getViewport().removeComponentListener(editorWidthWatcher);
            }
        });
        EditorUtil.disposeWithEditor((Editor)((Editor)this.editor), (Disposable)this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager$ComponentWrapper;", "Lcom/intellij/ui/components/JBScrollPane;", "component", "Ljavax/swing/JComponent;", "(Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager;Ljavax/swing/JComponent;)V", "getPreferredSize", "Ljava/awt/Dimension;", "intellij.vcs.github"})
    private final class ComponentWrapper
    extends JBScrollPane {
        private final JComponent component;

        @NotNull
        public Dimension getPreferredSize() {
            return new Dimension(EditorComponentInlaysManager.this.editorWidthWatcher.getEditorTextWidth(), this.component.getPreferredSize().height);
        }

        public ComponentWrapper(JComponent component) {
            Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
            super((Component)component);
            this.component = component;
            this.setOpaque(false);
            JViewport jViewport = this.viewport;
            Intrinsics.checkExpressionValueIsNotNull((Object)jViewport, (String)"viewport");
            jViewport.setOpaque(false);
            this.setBorder((Border)JBUI.Borders.empty());
            this.setViewportBorder((Border)JBUI.Borders.empty());
            this.horizontalScrollBarPolicy = 31;
            JScrollBar jScrollBar = this.verticalScrollBar;
            Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"verticalScrollBar");
            jScrollBar.setPreferredSize(new Dimension(0, 0));
            this.setViewportView(this.component);
            this.component.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(@NotNull ComponentEvent e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    this.dispatchEvent(new ComponentEvent(component, 101));
                }
            });
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0002J\b\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u0010\u0015\u001a\u00020\u000eH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager$EditorTextWidthWatcher;", "Ljava/awt/event/ComponentAdapter;", "(Lorg/jetbrains/plugins/github/pullrequest/comment/ui/EditorComponentInlaysManager;)V", "editorTextWidth", "", "getEditorTextWidth", "()I", "setEditorTextWidth", "(I)V", "maximumEditorTextWidth", "verticalScrollbarFlipped", "", "calcWidth", "componentHidden", "", "e", "Ljava/awt/event/ComponentEvent;", "componentResized", "componentShown", "getGutterTextGap", "getVerticalScrollbarWidth", "updateWidthForAllInlays", "intellij.vcs.github"})
    private final class EditorTextWidthWatcher
    extends ComponentAdapter {
        private int editorTextWidth;
        private final int maximumEditorTextWidth;
        private final boolean verticalScrollbarFlipped;

        public final int getEditorTextWidth() {
            return this.editorTextWidth;
        }

        public final void setEditorTextWidth(int n) {
            this.editorTextWidth = n;
        }

        @Override
        public void componentResized(@NotNull ComponentEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            this.updateWidthForAllInlays();
        }

        @Override
        public void componentHidden(@NotNull ComponentEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            this.updateWidthForAllInlays();
        }

        @Override
        public void componentShown(@NotNull ComponentEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            this.updateWidthForAllInlays();
        }

        private final void updateWidthForAllInlays() {
            int newWidth = this.calcWidth();
            if (this.editorTextWidth == newWidth) {
                return;
            }
            this.editorTextWidth = newWidth;
            Iterable $this$forEach$iv = EditorComponentInlaysManager.this.managedInlays.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ComponentWrapper it = (ComponentWrapper)((Object)element$iv);
                boolean bl = false;
                it.dispatchEvent(new ComponentEvent((Component)((Object)it), 101));
                it.invalidate();
            }
        }

        private final int calcWidth() {
            JScrollPane jScrollPane = EditorComponentInlaysManager.this.getEditor().getScrollPane();
            Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"editor.scrollPane");
            JViewport jViewport = jScrollPane.getViewport();
            Intrinsics.checkExpressionValueIsNotNull((Object)jViewport, (String)"editor.scrollPane.viewport");
            int visibleEditorTextWidth = jViewport.getWidth() - this.getVerticalScrollbarWidth() - this.getGutterTextGap();
            int n = 0;
            int n2 = 0;
            n = Math.max(visibleEditorTextWidth, n);
            n2 = this.maximumEditorTextWidth;
            boolean bl = false;
            return Math.min(n, n2);
        }

        private final int getVerticalScrollbarWidth() {
            JScrollPane jScrollPane = EditorComponentInlaysManager.this.getEditor().getScrollPane();
            Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"editor.scrollPane");
            JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
            Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"editor.scrollPane.verticalScrollBar");
            int width = jScrollBar.getWidth();
            return !this.verticalScrollbarFlipped ? width * 2 : width;
        }

        private final int getGutterTextGap() {
            int n;
            if (this.verticalScrollbarFlipped) {
                EditorImpl editorImpl = EditorComponentInlaysManager.this.getEditor();
                if (editorImpl == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
                }
                EditorGutterComponentEx editorGutterComponentEx = ((EditorEx)editorImpl).getGutterComponentEx();
                Intrinsics.checkExpressionValueIsNotNull((Object)editorGutterComponentEx, (String)"(editor as EditorEx).gutterComponentEx");
                EditorGutterComponentEx gutter = editorGutterComponentEx;
                n = gutter.getWidth() - gutter.getWhitespaceSeparatorOffset();
            } else {
                n = 0;
            }
            return n;
        }

        public EditorTextWidthWatcher() {
            FontMetrics fontMetrics = EditorComponentInlaysManager.this.getEditor().getFontMetrics(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)fontMetrics, (String)"editor.getFontMetrics(Font.PLAIN)");
            FontMetrics metrics = fontMetrics;
            float spaceWidth = FontLayoutService.getInstance().charWidth2D(metrics, 32);
            float f = spaceWidth * (float)EditorComponentInlaysManager.this.getEditor().getSettings().getRightMargin(EditorComponentInlaysManager.this.getEditor().getProject()) - (float)4;
            EditorTextWidthWatcher editorTextWidthWatcher = this;
            boolean bl = false;
            float f2 = (float)Math.ceil(f);
            editorTextWidthWatcher.maximumEditorTextWidth = (int)f2;
            Object scrollbarFlip = EditorComponentInlaysManager.this.getEditor().getScrollPane().getClientProperty(JBScrollPane.Flip.class);
            this.verticalScrollbarFlipped = scrollbarFlip == JBScrollPane.Flip.HORIZONTAL || scrollbarFlip == JBScrollPane.Flip.BOTH;
        }
    }
}

