/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingErrorHandler;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingModel;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingPanel;
import org.jetbrains.plugins.github.util.GithubUIUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u0015*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u00020\u0004:\u0002\u0015\u0016B)\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel;", "T", "Ljavax/swing/JComponent;", "Lcom/intellij/util/ui/ComponentWithEmptyText;", "Lcom/intellij/ui/components/JBLoadingPanel;", "model", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingModel;", "content", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "textBundle", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingModel;Ljavax/swing/JComponent;Lcom/intellij/openapi/Disposable;Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle;)V", "errorHandler", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;", "getErrorHandler", "()Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;", "setErrorHandler", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;)V", "updateLoadingPanel", "Lcom/intellij/vcs/log/ui/frame/ProgressStripe;", "Companion", "EmptyTextBundle", "intellij.vcs.github"})
public final class GHLoadingPanel<T extends JComponent>
extends JBLoadingPanel {
    private final ProgressStripe updateLoadingPanel;
    @Nullable
    private GHLoadingErrorHandler errorHandler;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final GHLoadingErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(@Nullable GHLoadingErrorHandler gHLoadingErrorHandler) {
        this.errorHandler = gHLoadingErrorHandler;
    }

    @Deprecated(message="Replaced with factory because JBLoadingPanel is not really needed for initial loading", replaceWith=@ReplaceWith(imports={}, expression="GHLoadingPanelFactory().create()"))
    public GHLoadingPanel(@NotNull GHLoadingModel model2, @NotNull T content2, @NotNull Disposable parentDisposable, @NotNull EmptyTextBundle textBundle) {
        ProgressStripe progressStripe;
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        Intrinsics.checkParameterIsNotNull(content2, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkParameterIsNotNull((Object)textBundle, (String)"textBundle");
        super((LayoutManager)new BorderLayout(), GHLoadingPanel.Companion.createDecorator(parentDisposable));
        ProgressStripe progressStripe2 = new ProgressStripe(content2, parentDisposable, 300);
        GHLoadingPanel gHLoadingPanel = this;
        boolean bl = false;
        boolean bl2 = false;
        ProgressStripe $this$apply = progressStripe2;
        boolean bl3 = false;
        $this$apply.setOpaque(false);
        gHLoadingPanel.updateLoadingPanel = progressStripe = progressStripe2;
        this.setOpaque(false);
        this.add((Component)this.updateLoadingPanel, "Center");
        JBLoadingPanel jBLoadingPanel = this;
        StatusText statusText = ((ComponentWithEmptyText)content2).getEmptyText();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"content.emptyText");
        new Companion.Controller(model2, jBLoadingPanel, this.updateLoadingPanel, statusText, textBundle, (Function0<? extends GHLoadingErrorHandler>)((Function0)new Function0<GHLoadingErrorHandler>(){

            @Nullable
            public final GHLoadingErrorHandler invoke() {
                return this.getErrorHandler();
            }
        }));
    }

    public /* synthetic */ GHLoadingPanel(GHLoadingModel gHLoadingModel, JComponent jComponent, Disposable disposable, EmptyTextBundle emptyTextBundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            emptyTextBundle = EmptyTextBundle.Default.INSTANCE;
        }
        this(gHLoadingModel, jComponent, disposable, emptyTextBundle);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\bf\u0018\u00002\u00020\u0001:\u0002\n\u000bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle;", "", "default", "", "getDefault", "()Ljava/lang/String;", "empty", "getEmpty", "errorPrefix", "getErrorPrefix", "Default", "Simple", "intellij.vcs.github"})
    public static interface EmptyTextBundle {
        @NotNull
        public String getDefault();

        @NotNull
        public String getEmpty();

        @NotNull
        public String getErrorPrefix();

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle$Simple;", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle;", "default", "", "errorPrefix", "empty", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDefault", "()Ljava/lang/String;", "getEmpty", "getErrorPrefix", "intellij.vcs.github"})
        public static final class Simple
        implements EmptyTextBundle {
            @NotNull
            private final String default;
            @NotNull
            private final String errorPrefix;
            @NotNull
            private final String empty;

            @Override
            @NotNull
            public String getDefault() {
                return this.default;
            }

            @Override
            @NotNull
            public String getErrorPrefix() {
                return this.errorPrefix;
            }

            @Override
            @NotNull
            public String getEmpty() {
                return this.empty;
            }

            public Simple(@NotNull String string, @NotNull String errorPrefix, @NotNull String empty) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"default");
                Intrinsics.checkParameterIsNotNull((Object)errorPrefix, (String)"errorPrefix");
                Intrinsics.checkParameterIsNotNull((Object)empty, (String)"empty");
                this.default = string;
                this.errorPrefix = errorPrefix;
                this.empty = empty;
            }

            public /* synthetic */ Simple(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string3 = "";
                }
                this(string, string2, string3);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle$Default;", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle;", "()V", "default", "", "getDefault", "()Ljava/lang/String;", "empty", "getEmpty", "errorPrefix", "getErrorPrefix", "intellij.vcs.github"})
        public static final class Default
        implements EmptyTextBundle {
            @NotNull
            private static final String default = "";
            @NotNull
            private static final String empty = "";
            @NotNull
            private static final String errorPrefix;
            public static final Default INSTANCE;

            @Override
            @NotNull
            public String getDefault() {
                return default;
            }

            @Override
            @NotNull
            public String getEmpty() {
                return empty;
            }

            @Override
            @NotNull
            public String getErrorPrefix() {
                return errorPrefix;
            }

            private Default() {
            }

            static {
                Default default_;
                INSTANCE = default_ = new Default();
                default = "";
                empty = "";
                String string = GithubBundle.message("cannot.load.data", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GithubBundle.message(\"cannot.load.data\")");
                errorPrefix = string;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$Companion;", "", "()V", "createDecorator", "Lcom/intellij/util/NotNullFunction;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/ui/LoadingDecorator;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "Controller", "intellij.vcs.github"})
    public static final class Companion {
        private final NotNullFunction<JPanel, LoadingDecorator> createDecorator(Disposable parentDisposable) {
            return (NotNullFunction)new NotNullFunction<JPanel, LoadingDecorator>(parentDisposable){
                final /* synthetic */ Disposable $parentDisposable;

                @NotNull
                public final Companion.createDecorator.1 fun(JPanel it) {
                    return new LoadingDecorator(this, it, it, this.$parentDisposable, 300){
                        final /* synthetic */ createDecorator.1 this$0;
                        final /* synthetic */ JPanel $it;

                        @NotNull
                        protected NonOpaquePanel customizeLoadingLayer(@NotNull JPanel parent, @NotNull JLabel text, @NotNull AsyncProcessIcon icon) {
                            Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
                            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                            Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
                            parent.setLayout(new GridBagLayout());
                            text.setText(ApplicationBundle.message((String)"label.loading.page.please.wait", (Object[])new Object[0]));
                            text.setIcon((Icon)new AnimatedIcon.Default());
                            text.setForeground(UIUtil.getContextHelpForeground());
                            NonOpaquePanel result = new NonOpaquePanel((JComponent)text);
                            parent.add((Component)result);
                            return result;
                        }
                        {
                            this.this$0 = $outer;
                            this.$it = $captured_local_variable$1;
                            super($super_call_param$2, $super_call_param$3, $super_call_param$4);
                        }
                    };
                }
                {
                    this.$parentDisposable = disposable;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$Companion$Controller;", "", "model", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingModel;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "updateLoadingPanel", "Lcom/intellij/vcs/log/ui/frame/ProgressStripe;", "statusText", "Lcom/intellij/util/ui/StatusText;", "textBundle", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle;", "errorHandlerProvider", "Lkotlin/Function0;", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingModel;Lcom/intellij/ui/components/JBLoadingPanel;Lcom/intellij/vcs/log/ui/frame/ProgressStripe;Lcom/intellij/util/ui/StatusText;Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle;Lkotlin/jvm/functions/Function0;)V", "update", "", "intellij.vcs.github"})
        public static final class Controller {
            private final GHLoadingModel model;
            private final JBLoadingPanel loadingPanel;
            private final ProgressStripe updateLoadingPanel;
            private final StatusText statusText;
            private final EmptyTextBundle textBundle;
            private final Function0<GHLoadingErrorHandler> errorHandlerProvider;

            private final void update() {
                if (this.model.getLoading()) {
                    this.loadingPanel.setFocusable(true);
                    this.statusText.clear();
                    if (this.model.getResultAvailable()) {
                        this.updateLoadingPanel.startLoading();
                    } else {
                        this.loadingPanel.startLoading();
                    }
                } else {
                    this.loadingPanel.stopLoading();
                    this.updateLoadingPanel.stopLoading();
                    if (this.model.getResultAvailable()) {
                        this.loadingPanel.setFocusable(false);
                        this.loadingPanel.resetKeyboardActions();
                        this.statusText.setText(this.textBundle.getEmpty());
                    } else {
                        Throwable error = this.model.getError();
                        if (error != null) {
                            StatusText statusText = this.statusText.clear().appendText(this.textBundle.getErrorPrefix(), SimpleTextAttributes.ERROR_ATTRIBUTES);
                            String string = error.getMessage();
                            if (string == null) {
                                string = GithubBundle.message("unknown.loading.error", new Object[0]);
                            }
                            statusText.appendSecondaryText(string, SimpleTextAttributes.ERROR_ATTRIBUTES, null);
                            Object object = (GHLoadingErrorHandler)this.errorHandlerProvider.invoke();
                            if (object != null && (object = object.getActionForError(error)) != null) {
                                Object object2 = object;
                                boolean bl = false;
                                boolean bl2 = false;
                                Object it = object2;
                                boolean bl3 = false;
                                this.statusText.appendSecondaryText(' ' + GithubUIUtilKt.getName((Action)it), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, (ActionListener)it);
                                this.loadingPanel.registerKeyboardAction((ActionListener)it, KeyStroke.getKeyStroke(10, 0), 0);
                            }
                        } else {
                            this.statusText.setText(this.textBundle.getDefault());
                        }
                    }
                }
            }

            public Controller(@NotNull GHLoadingModel model2, @NotNull JBLoadingPanel loadingPanel, @NotNull ProgressStripe updateLoadingPanel, @NotNull StatusText statusText, @NotNull EmptyTextBundle textBundle, @NotNull Function0<? extends GHLoadingErrorHandler> errorHandlerProvider) {
                Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
                Intrinsics.checkParameterIsNotNull((Object)loadingPanel, (String)"loadingPanel");
                Intrinsics.checkParameterIsNotNull((Object)updateLoadingPanel, (String)"updateLoadingPanel");
                Intrinsics.checkParameterIsNotNull((Object)statusText, (String)"statusText");
                Intrinsics.checkParameterIsNotNull((Object)textBundle, (String)"textBundle");
                Intrinsics.checkParameterIsNotNull(errorHandlerProvider, (String)"errorHandlerProvider");
                this.model = model2;
                this.loadingPanel = loadingPanel;
                this.updateLoadingPanel = updateLoadingPanel;
                this.statusText = statusText;
                this.textBundle = textBundle;
                this.errorHandlerProvider = errorHandlerProvider;
                this.model.addStateChangeListener(new GHLoadingModel.StateChangeListener(){

                    @Override
                    public void onLoadingStarted() {
                        this.update();
                    }

                    @Override
                    public void onLoadingCompleted() {
                        this.update();
                    }

                    @Override
                    public void onReset() {
                        this.update();
                    }
                });
                this.update();
            }
        }
    }
}

