/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class PySuperMethodsSearchExecutor
implements QueryExecutor<PsiElement, PySuperMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull PySuperMethodsSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiElement> consumer) {
        if (queryParameters == null) {
            PySuperMethodsSearchExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PySuperMethodsSearchExecutor.$$$reportNull$$$0(1);
        }
        PyFunction func = queryParameters.getDerivedMethod();
        String name = func.getName();
        PyClass containingClass = func.getContainingClass();
        TypeEvalContext context = queryParameters.getContext();
        if (name != null && containingClass != null) {
            for (PyClass superClass : containingClass.getAncestorClasses(context)) {
                PyFunction superMethod = superClass.findMethodByName(name, false, context);
                if (superMethod == null) continue;
                Property property = func.getProperty();
                Property superProperty = superMethod.getProperty();
                if (property != null && superProperty != null) {
                    AccessDirection direction = PyUtil.getPropertyAccessDirection(func);
                    PyCallable callable = superProperty.getByDirection(direction).valueOrNull();
                    superMethod = callable instanceof PyFunction ? (PyFunction)callable : null;
                }
                boolean consumerWantsMore = consumer.process((Object)superMethod);
                if (queryParameters.isDeepSearch() && consumerWantsMore) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/psi/search/PySuperMethodsSearchExecutor";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

