/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.UnixPythonSdkFlavor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacPythonSdkFlavor
extends CPythonSdkFlavor {
    private static final String[] POSSIBLE_BINARY_NAMES = new String[]{"python", "python2", "python3"};

    private MacPythonSdkFlavor() {
    }

    @Override
    public boolean isApplicable() {
        return SystemInfo.isMac;
    }

    @Override
    @NotNull
    public Collection<String> suggestHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        HashSet<String> candidates = new HashSet<String>();
        MacPythonSdkFlavor.collectPythonInstallations("/Library/Frameworks/Python.framework/Versions", candidates);
        MacPythonSdkFlavor.collectPythonInstallations("/System/Library/Frameworks/Python.framework/Versions", candidates);
        MacPythonSdkFlavor.collectPythonInstallations("/usr/local/Cellar/python", candidates);
        UnixPythonSdkFlavor.collectUnixPythons("/usr/local/bin", candidates);
        UnixPythonSdkFlavor.collectUnixPythons("/usr/bin", candidates);
        HashSet<String> hashSet = candidates;
        if (hashSet == null) {
            MacPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static void collectPythonInstallations(String pythonPath, Set<String> candidates) {
        VirtualFile rootVDir = LocalFileSystem.getInstance().findFileByPath(pythonPath);
        if (rootVDir != null) {
            if (rootVDir instanceof NewVirtualFile) {
                ((NewVirtualFile)rootVDir).markDirty();
            }
            rootVDir.refresh(true, false);
            block0: for (VirtualFile dir : rootVDir.getChildren()) {
                VirtualFile binDir;
                String dirName = StringUtil.toLowerCase((String)dir.getName());
                if (!dir.isDirectory() || !"Current".equals(dirName) && !dirName.startsWith("2") && !dirName.startsWith("3") || (binDir = dir.findChild("bin")) == null || !binDir.isDirectory()) continue;
                for (String name : POSSIBLE_BINARY_NAMES) {
                    String path;
                    VirtualFile child = binDir.findChild(name);
                    if (child == null || candidates.contains(path = child.getPath())) continue;
                    candidates.add(path);
                    continue block0;
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/flavors/MacPythonSdkFlavor", "suggestHomePaths"));
    }
}

