/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.changeReminder.predict;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.jetbrains.changeReminder.predict.Factor;
import com.jetbrains.changeReminder.prediction.model.PredictionModel;
import com.jetbrains.changeReminder.repository.Commit;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/changeReminder/predict/ProbabilityProvider;", "", "()V", "collectFileFactors", "", "newCommit", "Lcom/jetbrains/changeReminder/repository/Commit;", "candidateFile", "Lcom/intellij/openapi/vcs/FilePath;", "candidateFileHistory", "", "predict", "", "commit", "FactorCounter", "intellij.vcs.changeReminder"})
public final class ProbabilityProvider {
    public static final ProbabilityProvider INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final double[] collectFileFactors(Commit newCommit, FilePath candidateFile, Set<Commit> candidateFileHistory) {
        double d;
        void $this$sumByDouble$iv;
        Object v3;
        Iterable $this$maxBy$iv;
        Object it;
        double[] factors = new double[Factor.values().length];
        FactorCounter timeDistanceCounter = new FactorCounter();
        boolean bl = false;
        Map intersectionCounters = new LinkedHashMap();
        FactorCounter countFilesCounter = new FactorCounter();
        FactorCounter filePrefixCounter = new FactorCounter();
        FactorCounter pathPrefixCounter = new FactorCounter();
        double authorCommitted = 0.0;
        Iterable $this$forEach$iv = candidateFileHistory;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Commit oldCommit = (Commit)element$iv;
            boolean bl2 = false;
            Set filesFromCommit = CollectionsKt.intersect((Iterable)oldCommit.getFiles(), (Iterable)newCommit.getFiles());
            countFilesCounter.append((Number)filesFromCommit.size());
            Collection collection = filesFromCommit;
            boolean bl3 = false;
            if (!collection.isEmpty()) {
                timeDistanceCounter.append((Number)(newCommit.getTime() - oldCommit.getTime()));
            }
            if (authorCommitted != 1.0 && StringsKt.startsWith$default((String)oldCommit.getAuthor(), (String)newCommit.getAuthor(), (boolean)false, (int)2, null)) {
                authorCommitted = 1.0;
            }
            Iterable $this$forEach$iv2 = filesFromCommit;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                FilePath file = (FilePath)element$iv2;
                boolean bl4 = false;
                Map $this$getOrPut$iv = intersectionCounters;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(file);
                if (value$iv == null) {
                    boolean bl5 = false;
                    FactorCounter answer$iv = new FactorCounter();
                    $this$getOrPut$iv.put(file, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((FactorCounter)object).append((Number)1);
            }
        }
        String string = candidateFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"candidateFile.path");
        String candidateFilePath = string;
        String string2 = candidateFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"candidateFile.name");
        String candidateFileName = string2;
        Iterable $this$forEach$iv3 = newCommit.getFiles();
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            it = (FilePath)element$iv;
            boolean bl6 = false;
            pathPrefixCounter.append((Number)StringUtil.commonPrefixLength((CharSequence)candidateFilePath, (CharSequence)it.getPath()));
            filePrefixCounter.append((Number)StringUtil.commonPrefixLength((CharSequence)candidateFileName, (CharSequence)it.getName()));
        }
        $this$forEach$iv3 = intersectionCounters.values();
        int n = Factor.MAX_INTERSECTION.ordinal();
        double[] dArray = factors;
        boolean $i$f$maxBy = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = maxElem$iv;
            } else {
                it = (FactorCounter)maxElem$iv;
                boolean bl7 = false;
                double maxValue$iv = ((FactorCounter)it).getSum();
                do {
                    Object e$iv = iterator$iv.next();
                    FactorCounter it2 = (FactorCounter)e$iv;
                    $i$a$-maxBy-ProbabilityProvider$collectFileFactors$3 = false;
                    double v$iv = it2.getSum();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = maxElem$iv;
            }
        }
        Object var31_50 = v3;
        FactorCounter factorCounter = var31_50;
        dArray[n] = factorCounter != null ? factorCounter.getSum() : 0.0;
        $this$maxBy$iv = intersectionCounters.values();
        n = Factor.SUM_INTERSECTION.ordinal();
        dArray = factors;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        for (Object element$iv : $this$sumByDouble$iv) {
            void it3;
            FactorCounter v$iv = (FactorCounter)element$iv;
            double d2 = sum$iv;
            boolean bl8 = false;
            double d3 = it3.getSum();
            sum$iv = d2 + d3;
        }
        dArray[n] = d = sum$iv;
        factors[Factor.MIN_DISTANCE_TIME.ordinal()] = timeDistanceCounter.getMin();
        factors[Factor.COMMIT_SIZE.ordinal()] = newCommit.getFiles().size();
        factors[Factor.MAX_DISTANCE_TIME.ordinal()] = timeDistanceCounter.getMax();
        factors[Factor.AVG_DISTANCE_TIME.ordinal()] = timeDistanceCounter.getSum() / (double)candidateFileHistory.size();
        factors[Factor.MAX_COUNT.ordinal()] = countFilesCounter.getMax();
        factors[Factor.MIN_COUNT.ordinal()] = countFilesCounter.getMin();
        factors[Factor.AUTHOR_COMMITTED_THE_FILE.ordinal()] = authorCommitted;
        factors[Factor.MAX_PREFIX_PATH.ordinal()] = pathPrefixCounter.getMax();
        factors[Factor.MAX_PREFIX_FILE_NAME.ordinal()] = filePrefixCounter.getMax();
        return factors;
    }

    public final double predict(@NotNull Commit commit, @NotNull FilePath candidateFile, @NotNull Set<Commit> candidateFileHistory) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        Intrinsics.checkParameterIsNotNull((Object)candidateFile, (String)"candidateFile");
        Intrinsics.checkParameterIsNotNull(candidateFileHistory, (String)"candidateFileHistory");
        return PredictionModel.makePrediction((double[])this.collectFileFactors(commit, candidateFile, candidateFileHistory));
    }

    private ProbabilityProvider() {
    }

    static {
        ProbabilityProvider probabilityProvider;
        INSTANCE = probabilityProvider = new ProbabilityProvider();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0004\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/changeReminder/predict/ProbabilityProvider$FactorCounter;", "", "()V", "<set-?>", "", "max", "getMax", "()D", "min", "getMin", "sum", "getSum", "append", "newValue", "", "intellij.vcs.changeReminder"})
    private static final class FactorCounter {
        private double sum;
        private double max;
        private double min = DoubleCompanionObject.INSTANCE.getMAX_VALUE();

        public final double getSum() {
            return this.sum;
        }

        public final double getMax() {
            return this.max;
        }

        public final double getMin() {
            return this.min;
        }

        @NotNull
        public final FactorCounter append(@NotNull Number newValue) {
            Intrinsics.checkParameterIsNotNull((Object)newValue, (String)"newValue");
            return this.append(newValue.doubleValue());
        }

        private final FactorCounter append(double newValue) {
            double d;
            this.sum += newValue;
            double d2 = this.max;
            FactorCounter factorCounter = this;
            boolean bl = false;
            factorCounter.max = d = Math.max(d2, newValue);
            d2 = this.min;
            factorCounter = this;
            bl = false;
            factorCounter.min = d = Math.min(d2, newValue);
            return this;
        }
    }
}

