/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.util.Function;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public interface TreeVisitor {
    @NotNull
    public Action visit(@NotNull TreePath var1);

    public static class ByTreePath<T>
    implements TreeVisitor {
        private final Function<TreePath, T> converter;
        private final boolean ignoreRoot;
        private final TreePath path;
        private final int count;

        public ByTreePath(@NotNull TreePath path2, @NotNull Function<Object, ? extends T> converter) {
            if (path2 == null) {
                ByTreePath.$$$reportNull$$$0(0);
            }
            if (converter == null) {
                ByTreePath.$$$reportNull$$$0(1);
            }
            this(false, path2, converter);
        }

        public ByTreePath(boolean ignoreRoot, @NotNull TreePath path2, @NotNull Function<Object, ? extends T> converter) {
            if (path2 == null) {
                ByTreePath.$$$reportNull$$$0(2);
            }
            if (converter == null) {
                ByTreePath.$$$reportNull$$$0(3);
            }
            this.converter = currentPath -> converter.fun(currentPath.getLastPathComponent());
            this.ignoreRoot = ignoreRoot;
            this.path = path2;
            this.count = ignoreRoot ? path2.getPathCount() + 1 : path2.getPathCount();
        }

        @Override
        @NotNull
        public Action visit(@NotNull TreePath path2) {
            if (path2 == null) {
                ByTreePath.$$$reportNull$$$0(4);
            }
            Action action = this.ignoreRoot && null == path2.getParentPath() ? Action.CONTINUE : this.visit(path2, this.converter.fun((Object)path2));
            if (action == null) {
                ByTreePath.$$$reportNull$$$0(5);
            }
            return action;
        }

        @NotNull
        protected Action visit(@NotNull TreePath path2, T component) {
            if (path2 == null) {
                ByTreePath.$$$reportNull$$$0(6);
            }
            if (component == null) {
                Action action = Action.SKIP_CHILDREN;
                if (action == null) {
                    ByTreePath.$$$reportNull$$$0(7);
                }
                return action;
            }
            int count = path2.getPathCount();
            if (count < this.count) {
                TreePath parent;
                for (parent = this.path.getParentPath(); ++count < this.count && parent != null; parent = parent.getParentPath()) {
                }
                boolean found = parent != null && this.matches(component, parent.getLastPathComponent());
                Action action = !found ? Action.SKIP_CHILDREN : Action.CONTINUE;
                if (action == null) {
                    ByTreePath.$$$reportNull$$$0(8);
                }
                return action;
            }
            boolean found = count > this.count || this.matches(component, this.path.getLastPathComponent());
            Action action = !found ? Action.SKIP_CHILDREN : this.visit(path2, component, count - this.count);
            if (action == null) {
                ByTreePath.$$$reportNull$$$0(9);
            }
            return action;
        }

        @NotNull
        protected Action visit(@NotNull TreePath path2, @NotNull T component, int depth) {
            if (path2 == null) {
                ByTreePath.$$$reportNull$$$0(10);
            }
            if (component == null) {
                ByTreePath.$$$reportNull$$$0(11);
            }
            Action action = depth == 0 ? Action.INTERRUPT : Action.SKIP_CHILDREN;
            if (action == null) {
                ByTreePath.$$$reportNull$$$0(12);
            }
            return action;
        }

        protected boolean matches(@NotNull T pathComponent, @NotNull Object thisComponent) {
            if (pathComponent == null) {
                ByTreePath.$$$reportNull$$$0(13);
            }
            if (thisComponent == null) {
                ByTreePath.$$$reportNull$$$0(14);
            }
            return pathComponent.equals(thisComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converter";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/TreeVisitor$ByTreePath";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathComponent";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thisComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/TreeVisitor$ByTreePath";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 6: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class ByComponent<C, T>
    implements TreeVisitor {
        private final Function<TreePath, T> converter;
        private final C component;

        public ByComponent(@NotNull C component, @NotNull Function<Object, ? extends T> converter) {
            if (component == null) {
                ByComponent.$$$reportNull$$$0(0);
            }
            if (converter == null) {
                ByComponent.$$$reportNull$$$0(1);
            }
            this.converter = currentPath -> converter.fun(currentPath.getLastPathComponent());
            this.component = component;
        }

        public ByComponent(@NotNull C component, @NotNull Class<? extends T> type) {
            if (component == null) {
                ByComponent.$$$reportNull$$$0(2);
            }
            if (type == null) {
                ByComponent.$$$reportNull$$$0(3);
            }
            this(component, object -> type.isInstance(object) ? type.cast(object) : null);
        }

        @Override
        @NotNull
        public Action visit(@NotNull TreePath path2) {
            if (path2 == null) {
                ByComponent.$$$reportNull$$$0(4);
            }
            Action action = this.visit(this.converter.fun((Object)path2));
            if (action == null) {
                ByComponent.$$$reportNull$$$0(5);
            }
            return action;
        }

        @NotNull
        protected Action visit(T component) {
            if (component == null) {
                Action action = Action.SKIP_CHILDREN;
                if (action == null) {
                    ByComponent.$$$reportNull$$$0(6);
                }
                return action;
            }
            if (this.matches(component, this.component)) {
                Action action = Action.INTERRUPT;
                if (action == null) {
                    ByComponent.$$$reportNull$$$0(7);
                }
                return action;
            }
            if (this.contains(component, this.component)) {
                Action action = Action.CONTINUE;
                if (action == null) {
                    ByComponent.$$$reportNull$$$0(8);
                }
                return action;
            }
            Action action = Action.SKIP_CHILDREN;
            if (action == null) {
                ByComponent.$$$reportNull$$$0(9);
            }
            return action;
        }

        protected boolean matches(@NotNull T pathComponent, @NotNull C thisComponent) {
            if (pathComponent == null) {
                ByComponent.$$$reportNull$$$0(10);
            }
            if (thisComponent == null) {
                ByComponent.$$$reportNull$$$0(11);
            }
            return pathComponent.equals(thisComponent);
        }

        protected abstract boolean contains(@NotNull T var1, @NotNull C var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/TreeVisitor$ByComponent";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathComponent";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thisComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/TreeVisitor$ByComponent";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Acceptor {
        @NotNull
        public Promise<TreePath> accept(@NotNull TreeVisitor var1);
    }

    public static enum Action {
        INTERRUPT,
        CONTINUE,
        SKIP_CHILDREN,
        SKIP_SIBLINGS;

    }
}

