/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.DateTimeFormatManager;
import com.intellij.util.text.JBDateTimeFormatter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class CustomJBDateTimeFormatter
extends JBDateTimeFormatter {
    @NotNull
    private final DateFormat myDateFormat;
    @NotNull
    private final DateFormat myDateTimeFormat;
    @NotNull
    private final DateFormat myDateTimeSecondsFormat;

    public CustomJBDateTimeFormatter(@NotNull String pattern, boolean use24hour) {
        if (pattern == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(0);
        }
        this.myDateFormat = new SimpleDateFormat(pattern);
        this.myDateTimeFormat = new SimpleDateFormat(pattern + ", " + (use24hour ? "HH:mm" : "h:mm a"));
        this.myDateTimeSecondsFormat = new SimpleDateFormat(pattern + ", " + (use24hour ? "HH:mm:ss" : "h:mm:ss a"));
    }

    @NotNull
    protected DateFormat getFormat() {
        DateFormat dateFormat = this.myDateFormat;
        if (dateFormat == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(1);
        }
        return dateFormat;
    }

    @NotNull
    protected DateFormat getDateTimeFormat() {
        DateFormat dateFormat = this.myDateTimeFormat;
        if (dateFormat == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(2);
        }
        return dateFormat;
    }

    @NotNull
    protected DateFormat getDateTimeSecondsFormat() {
        DateFormat dateFormat = this.myDateTimeSecondsFormat;
        if (dateFormat == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(3);
        }
        return dateFormat;
    }

    @Override
    protected boolean isPrettyFormattingSupported() {
        return false;
    }

    @Override
    @NotNull
    public String formatTime(long time) {
        String string = this.getDateTimeFormat().format(new Date(time));
        if (string == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String formatTimeWithSeconds(long time) {
        String string = this.getDateTimeSecondsFormat().format(time);
        if (string == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String formatDate(long time) {
        String string = this.getFormat().format(time);
        if (string == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String formatPrettyDateTime(long time) {
        if (DateTimeFormatManager.getInstance().isPrettyFormattingAllowed() && DateFormatUtil.isPrettyFormattingPossible((long)time)) {
            String string = DateFormatUtil.formatPrettyDateTime((long)time);
            if (string == null) {
                CustomJBDateTimeFormatter.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = this.formatTime(time);
        if (string == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String formatPrettyDate(long time) {
        if (DateTimeFormatManager.getInstance().isPrettyFormattingAllowed() && DateFormatUtil.isPrettyFormattingPossible((long)time)) {
            String string = DateFormatUtil.formatPrettyDate((long)time);
            if (string == null) {
                CustomJBDateTimeFormatter.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = this.formatDate(time);
        if (string == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public String formatDateTime(Date date) {
        String string = this.formatTime(date);
        if (string == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String formatDateTime(long time) {
        String string = this.formatTime(time);
        if (string == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String formatPrettyDateTime(@NotNull Date date) {
        if (date == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(13);
        }
        String string = this.formatPrettyDateTime(date.getTime());
        if (string == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @NotNull
    public String formatPrettyDate(@NotNull Date date) {
        if (date == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(15);
        }
        String string = this.formatPrettyDate(date.getTime());
        if (string == null) {
            CustomJBDateTimeFormatter.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/CustomJBDateTimeFormatter";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/CustomJBDateTimeFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeFormat";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeSecondsFormat";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTime";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTimeWithSeconds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDate";
                break;
            }
            case 7: 
            case 8: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "formatPrettyDateTime";
                break;
            }
            case 9: 
            case 10: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "formatPrettyDate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDateTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "formatPrettyDateTime";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "formatPrettyDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

