/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.StringWithId;

public class TextMateLexerState {
    private final int hashcode;
    @NotNull
    public final SyntaxNodeDescriptor syntaxRule;
    @NotNull
    public final MatchData matchData;
    @NotNull
    public final TextMateWeigh.Priority priorityMatch;
    @Nullable
    public final StringWithId string;

    TextMateLexerState(@NotNull SyntaxNodeDescriptor syntaxRule, @NotNull MatchData matchData, @NotNull TextMateWeigh.Priority priority, @Nullable StringWithId line) {
        if (syntaxRule == null) {
            TextMateLexerState.$$$reportNull$$$0(0);
        }
        if (matchData == null) {
            TextMateLexerState.$$$reportNull$$$0(1);
        }
        if (priority == null) {
            TextMateLexerState.$$$reportNull$$$0(2);
        }
        this.syntaxRule = syntaxRule;
        this.matchData = matchData;
        this.priorityMatch = priority;
        this.string = matchData.matched() ? line : null;
        this.hashcode = Objects.hash(new Object[]{syntaxRule, matchData, this.priorityMatch, this.stringId()});
    }

    public static TextMateLexerState notMatched(@NotNull SyntaxNodeDescriptor syntaxRule) {
        if (syntaxRule == null) {
            TextMateLexerState.$$$reportNull$$$0(3);
        }
        return new TextMateLexerState(syntaxRule, MatchData.NOT_MATCHED, TextMateWeigh.Priority.NORMAL, null);
    }

    @NotNull
    public String toString() {
        String string = "TextMateLexerState{syntaxRule=" + this.syntaxRule + ", matchData=" + this.matchData + '}';
        if (string == null) {
            TextMateLexerState.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMateLexerState state = (TextMateLexerState)o;
        return this.syntaxRule.equals(state.syntaxRule) && this.matchData.equals(state.matchData) && this.priorityMatch == state.priorityMatch && this.stringId() == state.stringId();
    }

    public int hashCode() {
        return this.hashcode;
    }

    @Nullable
    private Object stringId() {
        return this.string != null ? this.string.id : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxRule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexerState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexerState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notMatched";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

