/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import it.unimi.dsi.fastutil.Hash;

final class CharSequenceHashingStrategy
implements Hash.Strategy<CharSequence> {
    static final CharSequenceHashingStrategy CASE_SENSITIVE = new CharSequenceHashingStrategy(true);
    static final CharSequenceHashingStrategy CASE_INSENSITIVE = new CharSequenceHashingStrategy(false);
    private final boolean isCaseSensitive;

    private CharSequenceHashingStrategy(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    public int hashCode(CharSequence o) {
        if (o == null) {
            return 0;
        }
        return this.isCaseSensitive ? StringUtil.stringHashCode(o) : StringUtil.stringHashCodeInsensitive(o);
    }

    public boolean equals(CharSequence s1, CharSequence s2) {
        return StringUtilRt.equal(s1, s2, this.isCaseSensitive);
    }
}

