/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlDomBundle;
import org.jetbrains.annotations.NotNull;

public class RemoveDomElementQuickFix
implements LocalQuickFix {
    private final boolean myIsTag;
    private final String myName;

    public RemoveDomElementQuickFix(@NotNull DomElement element) {
        if (element == null) {
            RemoveDomElementQuickFix.$$$reportNull$$$0(0);
        }
        this.myIsTag = element.getXmlElement() instanceof XmlTag;
        this.myName = element.getXmlElementName();
    }

    @NotNull
    public String getName() {
        String string = XmlDomBundle.message(this.myIsTag ? "remove.element.fix.name" : "remove.attribute.fix.name", this.myName);
        if (string == null) {
            RemoveDomElementQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlDomBundle.message("remove.element.fix.family", new Object[0]);
        if (string == null) {
            RemoveDomElementQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            RemoveDomElementQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            RemoveDomElementQuickFix.$$$reportNull$$$0(4);
        }
        if (this.myIsTag) {
            XmlTag tag = (XmlTag)descriptor.getPsiElement();
            XmlTag parentTag = tag.getParentTag();
            DomElement domElement = DomManager.getDomManager(project).getDomElement(tag);
            assert (domElement != null);
            domElement.undefine();
            if (parentTag != null && parentTag.isValid()) {
                parentTag.collapseIfEmpty();
            }
        } else {
            GenericAttributeValue<?> domElement = DomManager.getDomManager(project).getDomElement((XmlAttribute)descriptor.getPsiElement());
            assert (domElement != null);
            domElement.undefine();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/RemoveDomElementQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/RemoveDomElementQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

