/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J%\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceErrorHighlightingIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "()V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "setHideErrors", "hideErrors", "startInWriteAction", "CodeFenceHighlightErrorFilter", "SettingsListener", "intellij.markdown"})
public final class MarkdownCodeFenceErrorHighlightingIntention
implements IntentionAction {
    public static final SettingsListener SettingsListener = new SettingsListener(null);

    @NotNull
    public String getText() {
        String string = MarkdownBundle.message("markdown.hide.errors.intention.text", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MarkdownBundle.message(\"\u2026e.errors.intention.text\")");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        PsiFile psiFile;
        block10: {
            block9: {
                block8: {
                    block7: {
                        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                        PsiFile psiFile2 = file;
                        if (Intrinsics.areEqual((Object)(psiFile2 != null ? psiFile2.getFileType() : null), (Object)((Object)MarkdownFileType.INSTANCE)) ^ true) break block7;
                        MarkdownApplicationSettings markdownApplicationSettings = MarkdownApplicationSettings.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)markdownApplicationSettings, (String)"MarkdownApplicationSettings.getInstance()");
                        if (!markdownApplicationSettings.isHideErrors()) break block8;
                    }
                    return false;
                }
                psiFile = file;
                if (psiFile == null) break block9;
                Editor editor2 = editor;
                if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) {
                    return false;
                }
                if ((psiFile = psiFile.findElementAt(editor2.getOffset())) != null) break block10;
            }
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file?.findElementAt(edit\u2026rn false) ?: return false");
        PsiFile element = psiFile;
        return PsiTreeUtil.getParentOfType((PsiElement)element, MarkdownCodeFenceImpl.class) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.setHideErrors(true);
        Notification notification = new Notification("Markdown", MarkdownBundle.message("markdown.hide.errors.notification.title", new Object[0]), MarkdownBundle.message("markdown.hide.errors.notification.content", new Object[0]), NotificationType.INFORMATION);
        notification.addAction((AnAction)new NotificationAction(this, MarkdownBundle.message("markdown.hide.errors.notification.rollback.action.text", new Object[0])){
            final /* synthetic */ MarkdownCodeFenceErrorHighlightingIntention this$0;

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                MarkdownCodeFenceErrorHighlightingIntention.access$setHideErrors(this.this$0, false);
                notification.expire();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        });
        notification.notify(project);
    }

    private final void setHideErrors(boolean hideErrors) {
        MarkdownApplicationSettings markdownApplicationSettings = MarkdownApplicationSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)markdownApplicationSettings, (String)"MarkdownApplicationSettings.getInstance()");
        markdownApplicationSettings.setHideErrors(hideErrors);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        ((MarkdownApplicationSettings.SettingsChangedListener)application.getMessageBus().syncPublisher(MarkdownApplicationSettings.SettingsChangedListener.TOPIC)).settingsChanged(MarkdownApplicationSettings.getInstance());
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static final /* synthetic */ void access$setHideErrors(MarkdownCodeFenceErrorHighlightingIntention $this, boolean hideErrors) {
        $this.setHideErrors(hideErrors);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceErrorHighlightingIntention$CodeFenceHighlightErrorFilter;", "Lcom/intellij/codeInsight/highlighting/HighlightErrorFilter;", "()V", "shouldHighlightErrorElement", "", "element", "Lcom/intellij/psi/PsiErrorElement;", "intellij.markdown"})
    public static final class CodeFenceHighlightErrorFilter
    extends HighlightErrorFilter {
        public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject());
            PsiFile psiFile = injectedLanguageManager.getTopLevelFile((PsiElement)element);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"injectedLanguageManager.getTopLevelFile(element)");
            if (Intrinsics.areEqual((Object)psiFile.getFileType(), (Object)((Object)MarkdownFileType.INSTANCE)) && injectedLanguageManager.getInjectionHost((PsiElement)element) instanceof MarkdownCodeFenceImpl) {
                MarkdownApplicationSettings markdownApplicationSettings = MarkdownApplicationSettings.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)markdownApplicationSettings, (String)"MarkdownApplicationSettings.getInstance()");
                return !markdownApplicationSettings.isHideErrors();
            }
            return true;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceErrorHighlightingIntention$SettingsListener;", "Lorg/intellij/plugins/markdown/settings/MarkdownApplicationSettings$SettingsChangedListener;", "()V", "settingsChanged", "", "settings", "Lorg/intellij/plugins/markdown/settings/MarkdownApplicationSettings;", "intellij.markdown"})
    public static final class SettingsListener
    implements MarkdownApplicationSettings.SettingsChangedListener {
        /*
         * WARNING - void declaration
         */
        @Override
        public void settingsChanged(@NotNull MarkdownApplicationSettings settings) {
            Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project[] projectArray = projectManager.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
            Project[] $this$forEach$iv = projectArray;
            boolean $i$f$forEach = false;
            Project[] projectArray2 = $this$forEach$iv;
            int n = projectArray2.length;
            for (int i = 0; i < n; ++i) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$filterTo$iv$iv;
                VirtualFile[] $this$filter$iv;
                Project element$iv;
                Project project = element$iv = projectArray2[i];
                boolean bl = false;
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
                Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager.getOpenFiles(), (String)"FileEditorManager.getInstance(project).openFiles");
                boolean $i$f$filter = false;
                VirtualFile[] virtualFileArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                void var15_16 = $this$filterTo$iv$iv;
                int n2 = ((void)var15_16).length;
                for (int j = 0; j < n2; ++j) {
                    void element$iv$iv;
                    void file = element$iv$iv = var15_16[j];
                    boolean bl2 = false;
                    void v3 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"file");
                    if (!Intrinsics.areEqual((Object)v3.getFileType(), (Object)((Object)MarkdownFileType.INSTANCE))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    PsiFile psiFile;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    VirtualFile file = (VirtualFile)element$iv$iv;
                    boolean bl4 = false;
                    if (PsiManager.getInstance((Project)project).findFile(file) == null) continue;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    PsiFile it$iv$iv = psiFile;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$forEach$iv2 = (List)destination$iv$iv;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    PsiFile it = (PsiFile)element$iv2;
                    boolean bl8 = false;
                    DaemonCodeAnalyzerImpl.getInstance((Project)project).restart(it);
                }
            }
        }

        private SettingsListener() {
        }

        public /* synthetic */ SettingsListener(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

